/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.attributes;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.ExcelExport;
import com.vividsolutions.jump.util.FlexibleDateParser;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.LabelLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.components.TitledPopupMenu;
import com.vividsolutions.jump.workbench.ui.components.filtertabletableheader.Filterable;
import com.vividsolutions.jump.workbench.ui.components.filtertabletableheader.FilterableTableHeader;
import com.vividsolutions.jump.workbench.ui.layertree.LayerNameRenderer;
import com.vividsolutions.jump.workbench.ui.plugin.EditSelectedFeaturePlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.AttributeTablePanelListener;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.AttributesToClipboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.AttributesToExcelPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.FeatureInfoWriter;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.LayerTableModel;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.guitools.Tasks;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.components.SelfClosingMessageBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultButtonModel;
import javax.swing.DefaultCellEditor;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.JTextComponent;
import javax.swing.text.NumberFormatter;
import org.apache.commons.lang3.math.NumberUtils;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeTablePanel
extends JPanel {
    private static final Logger LOG = LoggerFactory.getLogger(AttributeTablePanel.class);
    public static final int GEOM_COLUMN_INDEX = 0;
    private static final Color LIGHT_GRAY = new Color(230, 230, 230);
    private final FeatureEditor featureEditor = new FeatureEditor(){

        @Override
        public void edit(PlugInContext context, SimpleFeature feature, final Layer myLayer) throws Exception {
            boolean editable = AttributeTablePanel.this.isLayerEditable(myLayer);
            new EditSelectedFeaturePlugIn(this){

                @Override
                protected Layer layer(PlugInContext context) {
                    return myLayer;
                }
            }.execute(context, feature, editable);
        }
    };
    private boolean isFiltered = false;
    private final MyTable table = new MyTable();
    private final LayerNameRenderer layerNameRenderer = new LayerNameRenderer(LayerNameRenderer.Style.SINGLE_ROW_PREVIEW_LEFT);
    private final Collection<AttributeTablePanelListener> listeners = new LinkedHashSet<AttributeTablePanelListener>();
    private final boolean tableContextMenuAllowed;
    private boolean showInScrollPane = false;
    private TitledPopupMenu tableHeaderPopupMenu;
    private JPopupMenu tablePopupMenu;
    private AttributeDescriptor currentAttributeDescriptor;
    private FilterableTableHeader filterableTableHeader;
    private Map<Integer, JComponent> replacementFilterComponentMap;
    private int initialRowCount;
    private JMenuItem mniCreateNewFeature;
    private JMenuItem mniCopyRows;
    private JMenuItem mniDeleteRows;

    private boolean isLayerEditable(Layer layer) {
        boolean isEditable = layer.isEditable();
        if (isEditable && layer instanceof LabelLayer) {
            isEditable = ((LabelLayer)layer).isLabelTextEditable();
        }
        return isEditable;
    }

    public AttributeTablePanel(final LayerTableModel model, final WorkbenchContext workbenchContext, boolean showInScrollPane, final boolean tableContextMenuAllowed) {
        this.showInScrollPane = showInScrollPane;
        this.initialRowCount = model.getRowCount();
        this.tableContextMenuAllowed = tableContextMenuAllowed;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LOG.error("Error initializing AttributeTablePanel.", (Throwable)ex);
        }
        try {
            JList list = new JList();
            list.setBackground(new JLabel().getBackground());
            this.layerNameRenderer.getListCellRendererComponent((JList<? extends Layerable>)list, model.getLayer(), -1, false, false);
            this.table.setModel(model);
            model.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    if (e.getFirstRow() == -1) {
                        AttributeTablePanel.this.initColumnWidths();
                    }
                    AttributeTablePanel.this.updateLabel();
                }
            });
            this.layerNameRenderer.getLabel().setFont(this.layerNameRenderer.getLabel().getFont().deriveFont(1));
            this.updateLabel();
            this.table.setSelectionModel(new SelectionModelWrapper(this, this));
            this.table.getTableHeader().setComponentPopupMenu(this.tableHeaderPopupMenu);
            this.table.getTableHeader().setReorderingAllowed(false);
            this.filterableTableHeader = new FilterableTableHeader(this.table, this.getReplacementFilterComponentMap());
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this, this.table.getModel()){

                @Override
                protected boolean useToString(int column) {
                    if (0 == column) {
                        return false;
                    }
                    return super.useToString(column);
                }
            };
            sorter.setSortable(0, false);
            this.table.setRowSorter((RowSorter<? extends TableModel>)sorter);
            this.initColumnWidths();
            this.setToolTips();
            this.setBorder(BorderFactory.createMatteBorder(0, 5, 0, 0, new FeatureInfoWriter().sidebarColor(model.getLayer())));
            if (!this.getModel().isLoadDataFromDatabaseEnabled()) {
                TableColumn column0 = this.table.getColumnModel().getColumn(0);
                column0.setHeaderRenderer(new ControlPanelTableHeaderRenderer());
            }
            this.table.getTableHeader().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        int columnIndex = AttributeTablePanel.this.table.columnAtPoint(e.getPoint());
                        if (AttributeTablePanel.this.isEditButtonColumn(columnIndex)) {
                            return;
                        }
                        if (SwingUtilities.isRightMouseButton(e)) {
                            String columnName = AttributeTablePanel.this.table.getColumnName(columnIndex);
                            AttributeTablePanel.this.currentAttributeDescriptor = AttributeTablePanel.this.getModel().getLayer().getFeatureType().getDescriptor(columnName);
                            if (AttributeTablePanel.this.isLayerEditable(AttributeTablePanel.this.getModel().getLayer()) && !AttributeTablePanel.this.getModel().getLayer().getFMD().getEditInOtherDatatype() && AttributeTablePanel.this.currentAttributeDescriptor != null && AttributeTablePanel.this.currentAttributeDescriptor.getType() != null) {
                                String layerName = AttributeTablePanel.this.getModel().getLayer().getName();
                                AttributeTablePanel.this.getTableHeaderPopupMenu().setTitle(AttributeTablePanel.this.createInformationText(columnName, layerName));
                                AttributeTablePanel.this.getTableHeaderPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                            }
                        }
                    }
                    catch (Throwable t) {
                        WorkbenchContext.getErrorHandler().handleThrowable(t);
                    }
                }
            });
            this.table.addMouseListener(new MouseAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void mouseClicked(MouseEvent e) {
                    block8: {
                        try {
                            int column = AttributeTablePanel.this.table.columnAtPoint(e.getPoint());
                            int row = AttributeTablePanel.this.table.rowAtPoint(e.getPoint());
                            if (row == -1) {
                                return;
                            }
                            if (AttributeTablePanel.this.isEditButtonColumn(column)) {
                                PlugInContext context = new PlugInContext(workbenchContext, null, model.getLayer(), null, null);
                                model.getLayer().getLayerManager().getUndoableEditReceiver().startReceiving();
                                try {
                                    AttributeTablePanel.this.featureEditor.edit(context, model.getFeature(AttributeTablePanel.this.table.convertRowIndexToModel(row)), model.getLayer());
                                    break block8;
                                }
                                finally {
                                    model.getLayer().getLayerManager().getUndoableEditReceiver().stopReceiving();
                                }
                            }
                            if (SwingUtilities.isRightMouseButton(e) && AttributeTablePanel.this.isLayerEditable(AttributeTablePanel.this.getModel().getLayer()) && tableContextMenuAllowed) {
                                AttributeTablePanel.this.getTablePopupMenu().show(e.getComponent(), e.getX(), e.getY());
                            }
                        }
                        catch (Throwable t) {
                            WorkbenchContext.getErrorHandler().handleThrowable(t);
                        }
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (AttributeTablePanel.this.table.isEditing()) {
                        AttributeTablePanel.this.table.getEditorComponent().requestFocusInWindow();
                    }
                }
            });
        }
        catch (Throwable t) {
            WorkbenchContext.getErrorHandler().handleThrowable(t);
        }
    }

    private TitledPopupMenu getTableHeaderPopupMenu() {
        if (this.tableHeaderPopupMenu == null) {
            this.tableHeaderPopupMenu = new TitledPopupMenu();
            String titleGlobalColumnUpdate = I18N.get("change-values-of-the-column");
            JMenuItem mniGlobalColumnUpdate = new JMenuItem(titleGlobalColumnUpdate);
            mniGlobalColumnUpdate.addActionListener(e -> {
                GlobalColumnUpdateDialog globalColumnUpdateDialog = new GlobalColumnUpdateDialog(WorkbenchContext.getFrame(), titleGlobalColumnUpdate);
                globalColumnUpdateDialog.setInputLabelText(this.tableHeaderPopupMenu.getTitle());
                globalColumnUpdateDialog.setVisible(true);
            });
            this.tableHeaderPopupMenu.add(mniGlobalColumnUpdate);
        }
        return this.tableHeaderPopupMenu;
    }

    private JPopupMenu getTablePopupMenu() {
        if (this.tablePopupMenu == null) {
            this.tablePopupMenu = new JPopupMenu();
            String titleCreateNewFeature = I18N.get("create-new-feature");
            this.mniCreateNewFeature = new JMenuItem(titleCreateNewFeature);
            this.mniCreateNewFeature.addActionListener(e -> {
                int rowCountBefore = this.table.getRowCount();
                SimpleFeature newFeature = FeatureUtil.createFeature((SimpleFeatureType)this.getModel().getLayer().getFeatureType());
                List<SimpleFeature> newFeatures = Arrays.asList(newFeature);
                this.executeTableContextCommand(newFeatures, 1, 3);
                this.table.setRowSelectionInterval(rowCountBefore, rowCountBefore);
                this.table.scrollRectToVisible(new Rectangle(this.table.getCellRect(rowCountBefore, 0, true)));
            });
            String titleCopyRows = I18N.get("insert-selected-features-as-new");
            this.mniCopyRows = new JMenuItem(titleCopyRows);
            this.mniCopyRows.addActionListener(e -> {
                if (this.getSelectedFeatures().isEmpty()) {
                    return;
                }
                int rowCountBefore = this.table.getRowCount();
                ArrayList<SimpleFeature> copiedFeatures = new ArrayList<SimpleFeature>();
                for (SimpleFeature feature : this.getSelectedFeatures()) {
                    SimpleFeature newFeature = FeatureUtil.createFeature((SimpleFeatureType)feature.getFeatureType());
                    FeatureUtil.copyFeatureData((SimpleFeature)feature, (SimpleFeature)newFeature);
                    copiedFeatures.add(newFeature);
                }
                this.executeTableContextCommand(copiedFeatures, 1, 3);
                this.table.setRowSelectionInterval(rowCountBefore, this.table.getRowCount() - 1);
                this.table.scrollRectToVisible(this.table.getCellRect(rowCountBefore, 0, true));
            });
            String titleDeleteRows = I18N.get("delete-selected-features");
            this.mniDeleteRows = new JMenuItem(titleDeleteRows);
            this.mniDeleteRows.addActionListener(e -> {
                if (this.getSelectedFeatures().isEmpty()) {
                    return;
                }
                ArrayList<SimpleFeature> deletedFeatures = new ArrayList<SimpleFeature>(this.getSelectedFeatures());
                this.executeTableContextCommand(deletedFeatures, 3, 1);
            });
            this.tablePopupMenu.add(this.mniCreateNewFeature);
            this.tablePopupMenu.add(this.mniCopyRows);
            this.tablePopupMenu.add(this.mniDeleteRows);
        }
        this.mniCreateNewFeature.setEnabled(!this.getModel().getLayer().getFMD().getEditInOtherDatatype() && this.getModel().getLayer().getFMD().isInsertAllowed());
        this.mniCopyRows.setEnabled(!this.getModel().getLayer().getFMD().getEditInOtherDatatype() && this.getModel().getLayer().getFMD().isInsertAllowed());
        this.mniDeleteRows.setEnabled(!this.getModel().getLayer().getFMD().getEditInOtherDatatype() && this.getModel().getLayer().getFMD().isDeleteAllowed());
        this.mniCreateNewFeature.setVisible(!(this.getModel().getLayer() instanceof RedlineLayer));
        return this.tablePopupMenu;
    }

    private void executeTableContextCommand(final Collection<SimpleFeature> features, final int executeLayerFeatureFlag, final int unexecuteLayerFeatureFlag) {
        this.getModel().getLayer().getLayerManager().getUndoableEditReceiver().startReceiving();
        Tasks.submit(() -> {
            UndoableCommand command = new UndoableCommand(I18N.get("ui.plugin.LayerTableModel.edit") + " " + this.getModel().getLayer().getName()){

                @Override
                public void execute() {
                    boolean success = false;
                    AttributeTablePanel.this.getModel().getLayer().getLayerManager().setFiringEvents(false);
                    try {
                        AttributeTablePanel.this.getModel().getLayer().editFeature(features, executeLayerFeatureFlag);
                        success = true;
                    }
                    finally {
                        AttributeTablePanel.this.getModel().getLayer().getLayerManager().setFiringEvents(true);
                        if (success) {
                            AttributeTablePanel.this.handleFeaturesBasedOnLayerFeatureFlag(features, executeLayerFeatureFlag);
                        }
                    }
                }

                @Override
                public void unexecute() {
                    boolean success = false;
                    AttributeTablePanel.this.getModel().getLayer().getLayerManager().setFiringEvents(false);
                    try {
                        AttributeTablePanel.this.getModel().getLayer().editFeature(features, unexecuteLayerFeatureFlag);
                        success = true;
                    }
                    finally {
                        AttributeTablePanel.this.getModel().getLayer().getLayerManager().setFiringEvents(true);
                        if (success) {
                            AttributeTablePanel.this.handleFeaturesBasedOnLayerFeatureFlag(features, unexecuteLayerFeatureFlag);
                        }
                    }
                }
            };
            command.execute();
            this.getModel().getLayer().getLayerManager().getUndoableEditReceiver().receive(command.toUndoableEdit());
        });
        this.getModel().getLayer().getLayerManager().getUndoableEditReceiver().stopReceiving();
    }

    private void handleFeaturesBasedOnLayerFeatureFlag(Collection<SimpleFeature> features, int layerFeatureFlag) {
        switch (layerFeatureFlag) {
            case 1: {
                this.getModel().addAll(features);
                break;
            }
            case 3: {
                this.getModel().removeAll(features);
                break;
            }
        }
    }

    private Map<Integer, JComponent> getReplacementFilterComponentMap() {
        if (this.replacementFilterComponentMap == null) {
            this.replacementFilterComponentMap = new HashMap<Integer, JComponent>();
            this.replacementFilterComponentMap.put(0, new FiltertableTableControlPanel());
        }
        return this.replacementFilterComponentMap;
    }

    private boolean isEditButtonColumn(int column) {
        return this.getModel().getColumnName(0).equals(this.table.getColumnName(column));
    }

    private void updateLabel() {
        int modelRowCount = this.getModel().getRowCount();
        StringBuilder sb = new StringBuilder();
        sb.append(this.getModel().getLayer().getName());
        sb.append(" (");
        sb.append(modelRowCount);
        sb.append(" ");
        if (modelRowCount == 1) {
            sb.append(I18N.get("ui.AttributeTablePanel.feature"));
        } else {
            sb.append(I18N.get("ui.AttributeTablePanel.features"));
        }
        if (this.isFiltered) {
            sb.append(" - ");
            sb.append(I18N.get("ui.layertree.LayerNameRenderer.filtered"));
        }
        sb.append(")");
        this.layerNameRenderer.getLabel().setText(sb.toString());
    }

    public final LayerTableModel getModel() {
        return (LayerTableModel)this.table.getModel();
    }

    public JTable getTable() {
        return this.table;
    }

    public void addListener(AttributeTablePanelListener listener) {
        this.listeners.add(listener);
    }

    private void jbInit() throws Exception {
        if (this.showInScrollPane) {
            JScrollPane scrollPane = new JScrollPane(this.table);
            scrollPane.getViewport().setBackground(this.table.getBackground());
            this.table.setFillsViewportHeight(true);
            super.setLayout(new BorderLayout());
            super.add((Component)this.layerNameRenderer, "First");
            super.add((Component)scrollPane, "Center");
        } else {
            this.setLayout(new GridBagLayout());
            this.add((Component)this.layerNameRenderer, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.table.getTableHeader(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.table, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 200), 0, 0));
        }
    }

    public void showScrollPane() {
        try {
            this.showInScrollPane = true;
            this.jbInit();
        }
        catch (Exception ex) {
            LOG.error("Error initializing AttributeTablePanel.", (Throwable)ex);
        }
    }

    public void hideScrollPane() {
        try {
            this.showInScrollPane = false;
            this.jbInit();
        }
        catch (Exception ex) {
            LOG.error("Error initializing AttributeTablePanel.", (Throwable)ex);
        }
    }

    private void initColumnWidths() {
        GUIUtil.chooseGoodColumnWidths(this.table);
        this.table.getColumnModel().getColumn(0).setMinWidth(this.getReplacementFilterComponentMap().get((Object)Integer.valueOf((int)0)).getPreferredSize().width);
        this.table.getColumnModel().getColumn(0).setResizable(false);
        ArrayList<TableColumn> columns = Collections.list(this.table.getColumnModel().getColumns());
        for (int i = 1; i < columns.size(); ++i) {
            TableColumn column = columns.get(i);
            column.setMinWidth(120);
        }
    }

    private void setToolTips() {
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int column = AttributeTablePanel.this.table.columnAtPoint(e.getPoint());
                if (column == -1) {
                    return;
                }
                AttributeTablePanel.this.table.setToolTipText(AttributeTablePanel.this.createInformationText(AttributeTablePanel.this.table.getColumnName(column), AttributeTablePanel.this.getModel().getLayer().getName()));
            }
        });
    }

    private String createInformationText(String columnName, String layerName) {
        return columnName + " [" + layerName + "]";
    }

    private void fireSelectionReplaced() {
        for (AttributeTablePanelListener listener : this.listeners) {
            listener.selectionReplaced(this);
        }
    }

    public Collection<SimpleFeature> getSelectedFeatures() {
        ArrayList<SimpleFeature> selectedFeatures = new ArrayList<SimpleFeature>();
        for (int currRow : this.table.getSelectedRows()) {
            selectedFeatures.add(this.getModel().getFeature(this.table.convertRowIndexToModel(currRow)));
        }
        return selectedFeatures;
    }

    public void setSelectedFeatures(Collection<SimpleFeature> featuresToSelect) {
        this.table.getSelectionModel().clearSelection();
        featuresToSelect.stream().map(sf -> this.getModel().getFeatureRow((SimpleFeature)sf)).forEach(i -> this.table.getSelectionModel().addSelectionInterval((int)i, (int)i));
    }

    public LayerNameRenderer getLayerNameRenderer() {
        return this.layerNameRenderer;
    }

    public FilterableTableHeader getFilterableTableHeader() {
        return this.filterableTableHeader;
    }

    private static interface FeatureEditor {
        public void edit(PlugInContext var1, SimpleFeature var2, Layer var3) throws Exception;
    }

    private class MyTable
    extends JTable {
        private final Color LIGHT_GREEN = new Color(188, 250, 165);
        private final Color LIGHT_VIOLET = new Color(227, 163, 250);

        MyTable() {
            this.setAutoResizeMode(0);
            this.setDefaultEditor(Date.class, new FlexibleDateParser.CellEditor());
            this.setDefaultEditor(String.class, new TextCellEditor());
            this.setDefaultEditor(Number.class, new NumberCellEditor());
            this.setDefaultRenderer(Number.class, new CustomNumberRenderer());
            this.setDefaultRenderer(Date.class, new CustomDateRenderer());
            this.setDefaultRenderer(Float.class, new CustomNumberRenderer());
            this.setDefaultRenderer(Double.class, new CustomDoubleRenderer());
            this.setDefaultRenderer(Object.class, new CustomRenderer());
            this.setRowHeight(18);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            if (AttributeTablePanel.this.isEditButtonColumn(column)) {
                return new TableCellRenderer(this){
                    private final JButton button = new JButton(IconLoader.svgIcon((String)"common_edit_blue.svg", (int)10));

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        this.button.setToolTipText(I18N.get("ui.AttributeTablePanel.edit-geometry"));
                        return this.button;
                    }
                };
            }
            JComponent renderer = (JComponent)((Object)super.getCellRenderer(row, column));
            LayerTableModel layerTablemodel = (LayerTableModel)this.getModel();
            SimpleFeature feature = layerTablemodel.getFeature(this.convertRowIndexToModel(row));
            if (feature != null) {
                if (layerTablemodel.isAddedFeature(feature)) {
                    renderer.setBackground(this.LIGHT_GREEN);
                } else if (layerTablemodel.isModifiedFeature(feature)) {
                    renderer.setBackground(this.LIGHT_VIOLET);
                } else {
                    renderer.setBackground(Color.WHITE);
                }
            }
            return (TableCellRenderer)((Object)renderer);
        }
    }

    private class SelectionModelWrapper
    implements ListSelectionModel {
        private final AttributeTablePanel panel;
        private final ListSelectionModel selectionModel;

        SelectionModelWrapper(AttributeTablePanel attributeTablePanel, AttributeTablePanel panel) {
            this.panel = panel;
            this.selectionModel = panel.getTable().getSelectionModel();
        }

        @Override
        public void setAnchorSelectionIndex(int index) {
            this.selectionModel.setAnchorSelectionIndex(index);
        }

        @Override
        public void setLeadSelectionIndex(int index) {
            this.selectionModel.setLeadSelectionIndex(index);
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
            this.selectionModel.setSelectionInterval(index0, index1);
            this.panel.fireSelectionReplaced();
        }

        @Override
        public void setSelectionMode(int selectionMode) {
            this.selectionModel.setSelectionMode(selectionMode);
        }

        @Override
        public void setValueIsAdjusting(boolean valueIsAdjusting) {
            this.selectionModel.setValueIsAdjusting(valueIsAdjusting);
        }

        @Override
        public int getAnchorSelectionIndex() {
            return this.selectionModel.getAnchorSelectionIndex();
        }

        @Override
        public int getLeadSelectionIndex() {
            return this.selectionModel.getLeadSelectionIndex();
        }

        @Override
        public int getMaxSelectionIndex() {
            return this.selectionModel.getMaxSelectionIndex();
        }

        @Override
        public int getMinSelectionIndex() {
            return this.selectionModel.getMinSelectionIndex();
        }

        @Override
        public int getSelectionMode() {
            return this.selectionModel.getSelectionMode();
        }

        @Override
        public boolean getValueIsAdjusting() {
            return this.selectionModel.getValueIsAdjusting();
        }

        @Override
        public boolean isSelectedIndex(int index) {
            return this.selectionModel.isSelectedIndex(index);
        }

        @Override
        public boolean isSelectionEmpty() {
            return this.selectionModel.isSelectionEmpty();
        }

        @Override
        public void addListSelectionListener(ListSelectionListener x) {
            this.selectionModel.addListSelectionListener(x);
        }

        @Override
        public void addSelectionInterval(int index0, int index1) {
            this.selectionModel.addSelectionInterval(index0, index1);
        }

        @Override
        public void clearSelection() {
            this.selectionModel.clearSelection();
        }

        @Override
        public void insertIndexInterval(int index, int length, boolean before) {
            this.selectionModel.insertIndexInterval(index, length, before);
        }

        @Override
        public void removeIndexInterval(int index0, int index1) {
            this.selectionModel.removeIndexInterval(index0, index1);
        }

        @Override
        public void removeListSelectionListener(ListSelectionListener x) {
            this.selectionModel.removeListSelectionListener(x);
        }

        @Override
        public void removeSelectionInterval(int index0, int index1) {
            this.selectionModel.removeSelectionInterval(index0, index1);
        }
    }

    private class ControlPanelTableHeaderRenderer
    extends JPanel
    implements TableCellRenderer {
        private final List<JButton> buttons;
        private final DefaultButtonModel defaultButtonModel;
        private final DefaultButtonModel hoveredButtonModel;

        public ControlPanelTableHeaderRenderer() {
            super(new GridBagLayout());
            this.buttons = new ArrayList<JButton>();
            this.defaultButtonModel = new DefaultButtonModel();
            this.hoveredButtonModel = new DefaultButtonModel(){

                @Override
                public boolean isRollover() {
                    return true;
                }
            };
            this.init();
        }

        private void init() {
            this.setBorder(FilterableTableHeader.CONTROL_BORDER);
            JButton btnCopyToClipboard = new JButton(IconLoader.svgIcon((String)"copy2clipboard.svg", (int)16));
            btnCopyToClipboard.setToolTipText(AttributesToClipboardPlugIn.NAME);
            btnCopyToClipboard.addActionListener(e -> {
                AttributesToClipboardPlugIn attributesToClipboardPlugIn = new AttributesToClipboardPlugIn(this::getTables);
                try {
                    attributesToClipboardPlugIn.execute(null);
                }
                catch (Exception ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                }
            });
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.add((Component)btnCopyToClipboard, gridBagConstraints);
            JButton btnExportToExcel = new JButton(IconLoader.svgIcon((String)"export_excel.svg", (int)16));
            btnExportToExcel.setToolTipText(AttributesToExcelPlugIn.NAME);
            btnExportToExcel.addActionListener(e -> {
                AttributesToExcelPlugIn attributesToExcelPlugIn = new AttributesToExcelPlugIn(this::getTablesWithLayerName);
                try {
                    attributesToExcelPlugIn.execute(null);
                }
                catch (Exception ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                }
            });
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            this.add((Component)btnExportToExcel, gridBagConstraints);
            this.buttons.add(btnCopyToClipboard);
            this.buttons.add(btnExportToExcel);
            AttributeTablePanel.this.getTable().getTableHeader().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        JTable table = ((JTableHeader)e.getSource()).getTable();
                        int index = table.getColumnModel().getColumnIndexAtX(e.getX());
                        if (index == -1) {
                            return;
                        }
                        Rectangle headerRect = table.getTableHeader().getHeaderRect(index);
                        if (0 == index && headerRect.contains(e.getX(), e.getY())) {
                            int xx = e.getX() - headerRect.x;
                            for (JButton button : ControlPanelTableHeaderRenderer.this.buttons) {
                                Rectangle btnRect = button.getBounds();
                                if (!btnRect.contains(xx, e.getY())) continue;
                                button.doClick();
                            }
                        }
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    for (JButton button : ControlPanelTableHeaderRenderer.this.buttons) {
                        button.setModel(ControlPanelTableHeaderRenderer.this.defaultButtonModel);
                    }
                    AttributeTablePanel.this.getTable().getTableHeader().repaint();
                }
            });
            AttributeTablePanel.this.getTable().getTableHeader().addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    JTable table = ((JTableHeader)e.getSource()).getTable();
                    int index = table.getColumnModel().getColumnIndexAtX(e.getX());
                    if (index == -1) {
                        return;
                    }
                    Rectangle headerRect = table.getTableHeader().getHeaderRect(index);
                    if (0 == index) {
                        if (headerRect.contains(e.getX(), e.getY())) {
                            int xx = e.getX() - headerRect.x;
                            for (JButton button : ControlPanelTableHeaderRenderer.this.buttons) {
                                Rectangle btnRect = button.getBounds();
                                if (btnRect.contains(xx, e.getY())) {
                                    button.setModel(ControlPanelTableHeaderRenderer.this.hoveredButtonModel);
                                    AttributeTablePanel.this.getTable().getTableHeader().setToolTipText(button.getToolTipText());
                                    continue;
                                }
                                button.setModel(ControlPanelTableHeaderRenderer.this.defaultButtonModel);
                            }
                        } else {
                            AttributeTablePanel.this.getTable().getTableHeader().setToolTipText(null);
                        }
                        AttributeTablePanel.this.getTable().getTableHeader().repaint();
                    }
                }
            });
        }

        private Collection<JTable> getTables() {
            ArrayList<JTable> tables = new ArrayList<JTable>();
            tables.add(AttributeTablePanel.this.getTable());
            return tables;
        }

        public Map<String, ExcelExport.TableAttributes> getTablesWithLayerName() {
            return Collections.singletonMap(AttributeTablePanel.this.getModel().getLayer().getName(), new ExcelExport.TableAttributes(AttributeTablePanel.this.getTable(), Set.of(Integer.valueOf(0))));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table != null && table.getTableHeader() != null) {
                JTableHeader header = table.getTableHeader();
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
                this.setFont(header.getFont());
            }
            return this;
        }
    }

    private class FiltertableTableControlPanel
    extends JPanel
    implements Filterable {
        private JButton btnFilter;
        private JButton btnResetFilter;

        public FiltertableTableControlPanel() {
            super(new GridBagLayout());
            this.init();
        }

        private void init() {
            this.btnFilter = new JButton(IconLoader.svgIcon((String)"table_search.svg", (int)16));
            this.btnFilter.setToolTipText(I18N.get("ui.AboutDialog.infotable-filter"));
            this.btnFilter.addActionListener(e -> {
                this.btnResetFilter.setEnabled(true);
                this.clearSelection();
                AttributeTablePanel.this.filterableTableHeader.filter();
            });
            this.btnResetFilter = new JButton(IconLoader.svgIcon((String)"table_search_reset.svg", (int)16));
            this.btnResetFilter.setToolTipText(I18N.get("reset-filter"));
            this.btnResetFilter.setEnabled(false);
            this.btnResetFilter.addActionListener(e -> {
                this.btnResetFilter.setEnabled(false);
                this.clearSelection();
                AttributeTablePanel.this.filterableTableHeader.resetFilter();
                AttributeTablePanel.this.isFiltered = false;
                AttributeTablePanel.this.updateLabel();
            });
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.add((Component)this.btnFilter, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            this.add((Component)this.btnResetFilter, gridBagConstraints);
        }

        @Override
        public void fireTableFiltered(boolean filtered) {
            AttributeTablePanel.this.isFiltered = filtered;
            AttributeTablePanel.this.updateLabel();
            this.btnResetFilter.setEnabled(true);
        }

        public void clearSelection() {
            AttributeTablePanel.this.getTable().clearSelection();
            AttributeTablePanel.this.getTable().getSelectionModel().setAnchorSelectionIndex(-1);
            AttributeTablePanel.this.getTable().getSelectionModel().setLeadSelectionIndex(-1);
            AttributeTablePanel.this.getTable().getColumnModel().getSelectionModel().setAnchorSelectionIndex(-1);
            AttributeTablePanel.this.getTable().getColumnModel().getSelectionModel().setLeadSelectionIndex(-1);
        }
    }

    private class GlobalColumnUpdateDialog
    extends JDialog
    implements ActionListener,
    PropertyChangeListener {
        private static final Color WARNING_BORDER_COLOR = Color.decode("#b8860b");
        private static final Color WARNING_BACKGROUND_COLOR = Color.decode("#fafad2");
        private final JLabel lblInput;
        private final JTextField tfiInput;
        private final JLabel lblInfo;
        private final JCheckBox chkAttention2SelectedRows;
        private final JTextPane tpWarning;
        private JOptionPane optionPane;

        public GlobalColumnUpdateDialog(JFrame parent, String title) {
            super(parent, title, true);
            this.lblInput = new JLabel();
            this.tfiInput = new JTextField();
            this.lblInfo = new JLabel();
            this.chkAttention2SelectedRows = new JCheckBox(I18N.get("only-change-selected-data-records"));
            this.tpWarning = new JTextPane();
            this.init();
        }

        private void init() {
            Font fontLblInfo = this.lblInfo.getFont();
            this.lblInfo.setFont(fontLblInfo.deriveFont(fontLblInfo.getStyle() | 1));
            this.lblInfo.setText(String.format(I18N.get("x-lines-will-be-updated"), AttributeTablePanel.this.table.getRowCount()));
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    GlobalColumnUpdateDialog.this.tfiInput.requestFocusInWindow();
                }
            });
            this.tfiInput.putClientProperty("JTextField.showClearButton", true);
            this.tfiInput.addActionListener(this);
            this.tfiInput.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent comp) {
                    String text = ((JTextField)comp).getText();
                    return GlobalColumnUpdateDialog.this.validateInput(text);
                }
            });
            this.chkAttention2SelectedRows.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    AttributeTablePanel.this.table.getSelectedRow();
                    this.lblInfo.setText(String.format(I18N.get("x-lines-will-be-updated"), AttributeTablePanel.this.table.getSelectedRows().length));
                } else {
                    this.lblInfo.setText(String.format(I18N.get("x-lines-will-be-updated"), AttributeTablePanel.this.table.getRowCount()));
                }
            });
            CompoundBorder tarBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(WARNING_BORDER_COLOR), BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.tpWarning.setEditable(false);
            this.tpWarning.setBorder(tarBorder);
            this.tpWarning.setBackground(WARNING_BACKGROUND_COLOR);
            this.tpWarning.insertIcon(IconLoader.svgIcon((String)"common_save.svg", (int)16));
            try {
                this.tpWarning.getDocument().insertString(0, I18N.get("to-save-changes-permanently-click-following-button") + " ", null);
            }
            catch (BadLocationException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
            this.optionPane = new JOptionPane();
            this.optionPane.setMessageType(1);
            this.optionPane.setOptionType(2);
            this.optionPane.setMessage(new Object[]{this.lblInput, this.tfiInput, this.chkAttention2SelectedRows, this.lblInfo, " ", this.tpWarning});
            this.optionPane.addPropertyChangeListener(this);
            this.setContentPane(this.optionPane);
            this.setPreferredSize(new Dimension(450, 250));
            this.pack();
            this.setResizable(false);
            this.setLocationRelativeTo(this.getParent());
            this.setDefaultCloseOperation(2);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.optionPane.setInputValue(this.tfiInput.getText());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.isVisible()) {
                if (evt.getNewValue().equals(2)) {
                    this.setVisible(false);
                    this.dispose();
                    return;
                }
                if (this.validateInput(this.tfiInput.getText())) {
                    if (evt.getSource() == this.optionPane) {
                        Object value = this.tfiInput.getText();
                        String className = AttributeTablePanel.this.currentAttributeDescriptor.getType().getBinding().getName();
                        if (!className.equals(String.class.getName()) && !className.equals(Date.class.getName())) {
                            value = this.replaceCommaByDotForDecimalValidation((String)value);
                        } else if (className.equals(Date.class.getName())) {
                            FlexibleDateParser flexDateParser = new FlexibleDateParser();
                            try {
                                value = flexDateParser.parse((String)value, true);
                            }
                            catch (ParseException ex) {
                                LOG.error(ex.getMessage(), (Throwable)ex);
                            }
                        }
                        this.setVisible(false);
                        this.updateRows(value);
                        this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                    }
                } else {
                    this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                }
            }
        }

        private boolean validateInput(Object value) {
            this.tfiInput.putClientProperty("JComponent.outline", "");
            String className = AttributeTablePanel.this.currentAttributeDescriptor.getType().getBinding().getName();
            try {
                if (className.equals(String.class.getName())) {
                    return true;
                }
                if (className.equals(Byte.class.getName())) {
                    Byte.valueOf((String)value);
                } else if (className.equals(Short.class.getName())) {
                    Short.valueOf((String)value);
                } else if (className.equals(Integer.class.getName())) {
                    Integer.valueOf((String)value);
                } else if (className.equals(Long.class.getName())) {
                    Long.valueOf((String)value);
                } else if (className.equals(Float.class.getName()) || className.equals(Double.class.getName()) || className.equals(BigDecimal.class.getName())) {
                    boolean isParsable = NumberUtils.isParsable((String)this.replaceCommaByDotForDecimalValidation((String)value));
                    if (!isParsable) {
                        throw new NumberFormatException();
                    }
                } else if (className.equals(BigInteger.class.getName())) {
                    BigInteger.valueOf(Long.parseLong((String)value));
                } else if (className.equals(Date.class.getName())) {
                    FlexibleDateParser flexDateParser = new FlexibleDateParser();
                    flexDateParser.parse((String)value, true);
                }
            }
            catch (NumberFormatException | ParseException ex) {
                this.tfiInput.putClientProperty("JComponent.outline", "error");
                return false;
            }
            return true;
        }

        private String replaceCommaByDotForDecimalValidation(String value) {
            return value.replace(",", ".");
        }

        public void setInputLabelText(String text) {
            this.lblInput.setText(text + ":");
        }

        private void updateRows(Object value) {
            if (AttributeTablePanel.this.table == null) {
                return;
            }
            Tasks.submit(() -> {
                SimpleFeatureType featureType = AttributeTablePanel.this.getModel().getLayer().getFeatureType();
                int columnIndex = featureType.indexOf(AttributeTablePanel.this.currentAttributeDescriptor.getName());
                Collection<SimpleFeature> sourceFeatures = this.chkAttention2SelectedRows.isSelected() ? AttributeTablePanel.this.getSelectedFeatures() : AttributeTablePanel.this.getModel().getFeatures();
                List<SimpleFeature> updatedFeatures = this.cloneFeatures(sourceFeatures);
                AttributeTablePanel.this.getModel().getLayer().addFeaturesToIndex(sourceFeatures);
                List<SimpleFeature> featureBackups = this.cloneFeatures(updatedFeatures);
                updatedFeatures.forEach(f -> f.setAttribute(columnIndex, value));
                AttributeTablePanel.this.getModel().batchCommitEditedFeatures(updatedFeatures, featureBackups, I18N.get("ui.plugin.LayerTableModel.edit") + " " + AttributeTablePanel.this.currentAttributeDescriptor.getLocalName());
            });
        }

        private List<SimpleFeature> cloneFeatures(Collection<SimpleFeature> features) {
            ArrayList<SimpleFeature> clonedFeatures = new ArrayList<SimpleFeature>(features.size());
            for (SimpleFeature feature : features) {
                clonedFeatures.add(FeatureUtil.cloneFeature((SimpleFeature)feature));
            }
            return clonedFeatures;
        }
    }

    private static class CustomRenderer
    extends DefaultTableCellRenderer.UIResource {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (hasFocus) {
                this.setBackground(LIGHT_GRAY);
                this.setForeground(Color.BLACK);
            }
            return this;
        }
    }

    private static class CustomNumberRenderer
    extends CustomRenderer {
        NumberFormat formatter;

        public CustomNumberRenderer() {
            this.setHorizontalAlignment(4);
        }

        protected NumberFormat getNumberFormatter() {
            return NumberFormat.getInstance();
        }

        @Override
        public void setValue(Object value) {
            if (this.formatter == null) {
                this.formatter = this.getNumberFormatter();
                this.formatter.setGroupingUsed(false);
            }
            this.setText(value == null ? "" : this.formatter.format(value));
        }
    }

    private static class CustomDoubleRenderer
    extends CustomNumberRenderer {
        private CustomDoubleRenderer() {
        }

        @Override
        protected NumberFormat getNumberFormatter() {
            return new DecimalFormat("##############0.###############");
        }
    }

    private static class CustomDateRenderer
    extends CustomRenderer {
        DateFormat formatter;

        @Override
        public void setValue(Object value) {
            if (this.formatter == null) {
                this.formatter = DateFormat.getDateInstance();
            }
            this.setText(value == null ? "" : this.formatter.format(value));
        }
    }

    private class NumberCellEditor
    extends DefaultCellEditor {
        private final NumberFormat nf;
        private Object checkvalue;

        NumberCellEditor() {
            super(new JFormattedTextField());
            this.nf = NumberFormat.getInstance();
            this.checkvalue = null;
            this.nf.setGroupingUsed(false);
            JTextField txtEdit = (JTextField)this.editorComponent;
            GUISupport.addCopyInsertPopup((JTextComponent)txtEdit);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JFormattedTextField editor = (JFormattedTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            editor.setBorder(new LineBorder(Color.black));
            this.checkvalue = null;
            if (value instanceof Number) {
                editor.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(this.nf)));
                editor.setHorizontalAlignment(4);
                editor.setValue(value);
            }
            return editor;
        }

        @Override
        public boolean stopCellEditing() {
            try {
                String val = (String)super.getCellEditorValue();
                if (val == null) {
                    return super.stopCellEditing();
                }
                if (val.length() == 0) {
                    return super.stopCellEditing();
                }
                ParsePosition pos = new ParsePosition(0);
                Number n = this.nf.parse(val, pos);
                if (pos.getIndex() != val.length()) {
                    ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
                    SelfClosingMessageBox msgbox = new SelfClosingMessageBox(null, I18N.get("ui.AttributeTablePanel.wrong-number"), 1500);
                    msgbox.setVisible(true);
                    return false;
                }
                this.checkvalue = n.doubleValue();
                return super.stopCellEditing();
            }
            catch (Exception ex) {
                LOG.error("Error while entering new value in attribute panel", (Throwable)ex);
                return false;
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.checkvalue;
        }
    }

    private static final class TextCellEditor
    extends DefaultCellEditor {
        private Object checkvalue;
        private Collection<Filter> lstRestrictions = null;

        TextCellEditor() {
            super(new JTextField());
            JTextField txtEdit = (JTextField)this.editorComponent;
            GUISupport.addCopyInsertPopup((JTextComponent)txtEdit);
        }

        @Override
        public boolean stopCellEditing() {
            this.checkvalue = super.getCellEditorValue();
            if (this.lstRestrictions != null) {
                for (Filter filt : this.lstRestrictions) {
                    boolean bolOK = filt.evaluate(this.checkvalue);
                    if (bolOK) continue;
                    ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
                    SelfClosingMessageBox msgbox = new SelfClosingMessageBox(null, I18N.get("ui.AttributeTablePanel.text-to-long"), 1500);
                    msgbox.setVisible(true);
                    return false;
                }
            }
            return super.stopCellEditing();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.checkvalue = null;
            String strColName = ((LayerTableModel)table.getModel()).getColumnAttributeName(column);
            AttributeDescriptor attDesc = ((LayerTableModel)table.getModel()).getLayer().getFeatureType().getDescriptor(strColName);
            this.lstRestrictions = attDesc.getType().getRestrictions();
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            return this.checkvalue;
        }
    }
}

