/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.attributes;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.ui.EnableableToolBar;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.components.CloseablePanel;
import com.vividsolutions.jump.workbench.ui.components.ErrorHandler;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.AddFeatureGeomDialog;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.AttributePanel;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.AttributeTableRetriever;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.AttributesToClipboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.AttributesToExcelPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.ClearTableGraphicsFilterPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.InfoModel;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.InfoModelListener;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.LayerTableModel;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.UrlFeatureInfoPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.RollbackTableFeatureChangesPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveTableFeatureChangesPlugIn;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import com.vividsolutions.jump.workbench.ui.task.TaskMonitorManager;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.icons.IconLoader;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import de.riwagis.riwajump.feature.WhiteListFeatureIterator;
import de.riwagis.util.ThrowingRunnable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.geom.NoninvertibleTransformException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public abstract class AttributeTab
extends JPanel
implements AttributeTableRetriever {
    private final AttributePanel panel;
    private final BorderLayout borderLayout1 = new BorderLayout();
    private final EnableableToolBar toolBar = new EnableableToolBar();
    private final JScrollPane scrollPane = new JScrollPane();
    private final ErrorHandler errorHandler;
    private final TaskFrame taskFrame;
    private final InfoModel model;
    private final AttributesToClipboardPlugIn attributesToClipboardPlugIn;
    private final AttributesToExcelPlugIn attributesToExcelPlugIn;
    private final SaveTableFeatureChangesPlugIn saveTableFeatureChangesPlugIn = new SaveTableFeatureChangesPlugIn(() -> this.toolBar.updateEnabledState());
    private final RollbackTableFeatureChangesPlugIn rollbackTableFeatureChangesPlugIn = new RollbackTableFeatureChangesPlugIn();
    private final ClearTableGraphicsFilterPlugIn clearTableGraphicsFilterPlugIn = new ClearTableGraphicsFilterPlugIn();
    private boolean isRedlineLayer = false;
    private static AddFeatureGeomDialog dlgAddFeatGeom = null;

    public AttributeTab(InfoModel model, WorkbenchContext workbenchContext, TaskFrame taskFrame) {
        this(model, workbenchContext, taskFrame, false);
    }

    public AttributeTab(InfoModel model, WorkbenchContext workbenchContext, TaskFrame taskFrame, boolean isRedlineLayer) {
        this.attributesToClipboardPlugIn = new AttributesToClipboardPlugIn(this::getTables);
        this.attributesToExcelPlugIn = new AttributesToExcelPlugIn(this::getTablesWithLayerName);
        this.model = model;
        this.taskFrame = taskFrame;
        this.isRedlineLayer = isRedlineLayer;
        this.panel = this.createPanel(model, workbenchContext, taskFrame);
        this.createListeners(model, taskFrame);
        this.errorHandler = WorkbenchContext.getErrorHandler();
        this.jbInit();
        this.initScrollPane();
        this.installToolBarButtons(workbenchContext, taskFrame);
        this.toolBar.updateEnabledState();
    }

    private void createListeners(final InfoModel model, TaskFrame taskFrame) {
        taskFrame.getLayerManager().addLayerListener(new LayerListener(){

            @Override
            public void featuresChanged(FeatureEvent e) {
                AttributeTab.this.toolBar.updateEnabledState();
            }

            @Override
            public void layerChanged(LayerEvent e) {
                if (e.getType() == LayerEventType.METADATA_CHANGED || e.getType() == LayerEventType.APPEARANCE_CHANGED || e.getType() == LayerEventType.TABLE_DATA_CHANGED) {
                    AttributeTab.this.toolBar.updateEnabledState();
                } else if (e.getType() == LayerEventType.REMOVED && e.getLayerable() instanceof Layer && model.getLayers().contains((Layer)e.getLayerable())) {
                    for (Container p = AttributeTab.this.getParent(); p != null; p = p.getParent()) {
                        if (!(p instanceof CloseablePanel)) continue;
                        ((CloseablePanel)p).executeCloseActions();
                        break;
                    }
                }
            }

            @Override
            public void categoryChanged(CategoryEvent e) {
            }
        });
        model.addListener(new InfoModelListener(){

            @Override
            public void layerAdded(LayerTableModel layerTableModel) {
                AttributeTab.this.panel.getTablePanel(layerTableModel.getLayer()).getTable().getSelectionModel().addListSelectionListener(e -> {
                    if (!e.getValueIsAdjusting()) {
                        AttributeTab.this.toolBar.updateEnabledState();
                    }
                });
                AttributeTab.this.saveTableFeatureChangesPlugIn.setLayers(model.getLayers());
                AttributeTab.this.rollbackTableFeatureChangesPlugIn.setLayers(model.getLayers());
                AttributeTab.this.clearTableGraphicsFilterPlugIn.setLayers(model.getLayers());
                AttributeTab.this.toolBar.updateEnabledState();
            }

            @Override
            public void layerRemoved(LayerTableModel layerTableModel) {
                AttributeTab.this.saveTableFeatureChangesPlugIn.setLayers(model.getLayers());
                AttributeTab.this.rollbackTableFeatureChangesPlugIn.setLayers(model.getLayers());
                AttributeTab.this.clearTableGraphicsFilterPlugIn.setLayers(model.getLayers());
                AttributeTab.this.toolBar.updateEnabledState();
            }
        });
    }

    private AttributePanel createPanel(InfoModel model, WorkbenchContext workbenchContext, TaskFrame taskFrame) {
        return new AttributePanel(model, workbenchContext, taskFrame);
    }

    public InfoModel getModel() {
        return this.model;
    }

    private void installToolBarButtons(WorkbenchContext workbenchContext, TaskFrame taskFrame) {
        Consumer<ThrowingRunnable> catchingRunner = runner -> {
            try {
                runner.run();
            }
            catch (Exception e) {
                this.errorHandler.handleThrowable(e);
            }
        };
        BiFunction<Supplier, String, EnableCheck> enabler = (valid, errorMessage) -> arg_0 -> AttributeTab.lambda$installToolBarButtons$2((Supplier)valid, errorMessage, arg_0);
        EnableCheck taskFrameEnableCheck = enabler.apply(taskFrame::isVisible, "ui.AttributeTab.task-frame-must-be-open");
        EnableCheck layersEnableCheck = enabler.apply(() -> !this.panel.getModel().getLayers().isEmpty(), "ui.AttributeTab.one-or-more-layers-must-be-present");
        EnableCheck tableIsNotEmptyEnableCheck = enabler.apply(() -> this.panel.rowCount() > 0, "ui.AttributeTab.one-or-more-rows-must-be-present");
        EnableCheck rowsSelectedEnableCheck = enabler.apply(() -> !this.panel.selectedFeatures().isEmpty(), "ui.AttributeTab.one-or-more-rows-must-be-selected");
        EnableCheck singleRowSelectedEnableCheck = enabler.apply(() -> this.panel.selectedFeatures().size() == 1, "ui.AttributeTab.one-row-must-be-selected");
        EnableCheck editableLayerEnableCheck = enabler.apply(() -> this.panel.getModel().getLayers().stream().allMatch(Layer::isEditable), "ui.AttributeTab.editable-layer-must-be-selected");
        EnableCheck editInOtherTableEnableCheck = enabler.apply(() -> this.panel.getModel().getLayers().stream().map(layer -> layer.getFMD()).allMatch(Predicate.not(FeaturestoreMetadata::getEditInOtherDatatype)), "data-entry-in-other-table-must-be-disabled");
        EnableCheck insertDataEnableCheck = enabler.apply(() -> this.panel.getModel().getLayers().stream().map(layer -> layer.getFMD()).allMatch(FeaturestoreMetadata::isInsertAllowed), "inserting-data-sets-must-be-permitted");
        EnableCheck objectInfoFeatureEnableCheck = enabler.apply(() -> this.model.isLoadDataFromDatabase(), "only-supported-by-attribute-table");
        this.toolBar.add(new JButton(), I18N.get("ui.AttributeTab.zoom-to-previous-row"), IconLoader.svgIcon((String)"zoom_previous_row.svg"), e -> catchingRunner.accept(() -> this.zoom(this.panel.topSelectedRow().previousRow())), new MultiEnableCheck().add(taskFrameEnableCheck).add(layersEnableCheck).add(tableIsNotEmptyEnableCheck));
        this.toolBar.add(new JButton(), I18N.get("ui.AttributeTab.zoom-to-next-row"), IconLoader.svgIcon((String)"zoom_next_row.svg"), e -> catchingRunner.accept(() -> this.zoom(this.panel.topSelectedRow().nextRow())), new MultiEnableCheck().add(taskFrameEnableCheck).add(layersEnableCheck).add(tableIsNotEmptyEnableCheck));
        this.toolBar.addSeparator();
        this.toolBar.add(new JButton(), I18N.get("ui.AttributeTab.zoom-to-selected-rows"), IconLoader.svgIcon((String)"zoom_row.svg"), e -> catchingRunner.accept(() -> this.panel.zoom(this.panel.selectedFeatures())), new MultiEnableCheck().add(taskFrameEnableCheck).add(layersEnableCheck).add(rowsSelectedEnableCheck));
        this.toolBar.add(new JButton(), I18N.get("ui.AttributeTab.zoom-to-full-extent"), IconLoader.svgIcon((String)"zoom_bounds.svg"), e -> catchingRunner.accept(() -> taskFrame.getLayerViewPanel().zoomToFullExtent()), new MultiEnableCheck().add(taskFrameEnableCheck).add(layersEnableCheck));
        this.toolBar.addSeparator();
        this.toolBar.add(new JButton(), I18N.get("ui.AttributeTab.select-in-task-window"), IconLoader.svgIcon((String)"selection_select.svg"), e -> catchingRunner.accept(this.panel::selectInLayerViewPanel), new MultiEnableCheck().add(taskFrameEnableCheck).add(layersEnableCheck).add(rowsSelectedEnableCheck));
        this.toolBar.add(new JButton(), I18N.get("ui.AttributeTab.flash-selected-rows"), IconLoader.svgIcon((String)"common_highlight.svg"), e -> catchingRunner.accept(this.panel::flashSelectedFeatures), new MultiEnableCheck().add(taskFrameEnableCheck).add(layersEnableCheck).add(rowsSelectedEnableCheck));
        this.toolBar.add(new JButton(), I18N.get("ui.plugin.attributes.UrlFeatureInfoPlugIn.name"), GUIUtil.toSmallIcon(UrlFeatureInfoPlugIn.ICON), e -> catchingRunner.accept(() -> UrlFeatureInfoPlugIn.openURL(this.panel.getSelectionManager())), UrlFeatureInfoPlugIn.createEnableCheck(workbenchContext, this.panel));
        this.toolBar.addSeparator();
        this.toolBar.add(new JButton(), I18N.get("ui.AttributeTab.edit-geometry"), IconLoader.svgIcon((String)"geometry_edit.svg"), e -> catchingRunner.accept(this::showEditGeometry), new MultiEnableCheck().add(taskFrameEnableCheck).add(layersEnableCheck).add(editableLayerEnableCheck).add(singleRowSelectedEnableCheck));
        this.toolBar.addSeparator();
        this.toolBar.add(new JButton(), I18N.get("com.vividsolutions.jump.workbench.ui.plugin.attributes.SetSelectionToGraphicsFilterPlugIn"), IconLoader.svgIcon((String)"filter_exchange_all.svg"), e -> catchingRunner.accept(this::setFidFilterForSelectedFeatures), new MultiEnableCheck().add(taskFrameEnableCheck).add(layersEnableCheck).add(rowsSelectedEnableCheck));
        this.toolBar.add(new JButton(), this.clearTableGraphicsFilterPlugIn.getName(), this.clearTableGraphicsFilterPlugIn.getIcon(), AbstractPlugIn.toActionListener(this.clearTableGraphicsFilterPlugIn, workbenchContext, new TaskMonitorManager()), this.clearTableGraphicsFilterPlugIn.createEnableCheck());
        this.toolBar.addSeparator();
        this.toolBar.add(new JButton(), AttributesToClipboardPlugIn.NAME, AttributesToClipboardPlugIn.ICON_COPY_2_CLIPBOARD, e -> catchingRunner.accept(this::copy2Clipboard), new MultiEnableCheck().add(this.attributesToClipboardPlugIn.createEnableCheck()).add(tableIsNotEmptyEnableCheck));
        this.toolBar.add(new JButton(), AttributesToExcelPlugIn.NAME, AttributesToExcelPlugIn.ICON_EXPORT_2_EXCEL, e -> catchingRunner.accept(this::export2Excel), new MultiEnableCheck().add(this.attributesToExcelPlugIn.createEnableCheck()).add(tableIsNotEmptyEnableCheck));
        if (this.getModel().isLoadDataFromDatabase() && !this.isRedlineLayer) {
            this.toolBar.addSeparator();
            this.toolBar.add(new JButton(), I18N.get("create-new-feature"), IconLoader.svgIcon((String)"common_add.svg"), e -> catchingRunner.accept(this::addRow), new MultiEnableCheck().add(taskFrameEnableCheck).add(layersEnableCheck).add(editableLayerEnableCheck).add(objectInfoFeatureEnableCheck).add(insertDataEnableCheck).add(editInOtherTableEnableCheck));
        }
        this.toolBar.addSeparator();
        this.toolBar.add(new JButton(), this.saveTableFeatureChangesPlugIn.getName(), this.saveTableFeatureChangesPlugIn.getIcon(), AbstractPlugIn.toActionListener(this.saveTableFeatureChangesPlugIn, workbenchContext, new TaskMonitorManager()), this.saveTableFeatureChangesPlugIn.createEnableCheck());
        this.toolBar.add(new JButton(), this.rollbackTableFeatureChangesPlugIn.getName(), this.rollbackTableFeatureChangesPlugIn.getIcon(), AbstractPlugIn.toActionListener(this.rollbackTableFeatureChangesPlugIn, workbenchContext, new TaskMonitorManager()), this.rollbackTableFeatureChangesPlugIn.createEnableCheck());
    }

    private void showEditGeometry() {
        Layer ly;
        WorkbenchContext.getFrame().activateDefaultCT();
        Collection<SimpleFeature> colFeatures = this.panel.selectedFeatures();
        if (colFeatures.size() == 1 && (ly = this.panel.getSelectionManager().getLayersWithSelectedItems().iterator().next()).isEditable()) {
            boolean featureIsNotPersistedYet;
            SimpleFeature f = colFeatures.iterator().next();
            boolean bl = featureIsNotPersistedYet = ly.getFeatureAddedByKey(f.getID()) != null;
            if (dlgAddFeatGeom != null) {
                dlgAddFeatGeom.setVisible(false);
                dlgAddFeatGeom.dispose();
            }
            dlgAddFeatGeom = new AddFeatureGeomDialog(WorkbenchContext.getFrame(), ly, f, false, featureIsNotPersistedYet);
        }
    }

    private void setFidFilterForSelectedFeatures() {
        Map<Layer, Collection<SimpleFeature>> map = this.panel.getSelectedFeaturesForLayers();
        SelectionManager selectionManager = WorkbenchContext.getInstance().getSelectionManager();
        for (Map.Entry<Layer, Collection<SimpleFeature>> entry : map.entrySet()) {
            Layer layer = entry.getKey();
            String whiteListAttribute = WhiteListFeatureIterator.getWhiteListAttribute(layer.getFMD());
            List<String> primaryKeys = entry.getValue().stream().map(feature -> WhiteListFeatureIterator.extractKey(feature, whiteListAttribute)).collect(Collectors.toList());
            layer.setFidFilterWhiteList(primaryKeys);
            layer.fireAppearanceChanged();
            layer.fireLayerChanged(LayerEventType.TABLE_DATA_CHANGED);
            Collection<SimpleFeature> featuresWithSelectedItems = selectionManager.getFeaturesWithSelectedItems(layer);
            featuresWithSelectedItems.removeAll(entry.getValue());
            selectionManager.unselectItems(layer, featuresWithSelectedItems);
        }
    }

    public TaskFrame getTaskFrame() {
        return this.taskFrame;
    }

    private void jbInit() {
        this.setLayout(this.borderLayout1);
        this.toolBar.setOrientation(0);
        this.panel.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                if (AttributeTab.this.panel.getComponentCount() == 1) {
                    AttributeTab.this.remove(AttributeTab.this.scrollPane);
                    AttributeTab.this.scrollPane.getViewport().remove(AttributeTab.this.panel);
                    AttributeTab.this.add((Component)AttributeTab.this.panel, "Center");
                } else {
                    AttributeTab.this.remove(AttributeTab.this.panel);
                    AttributeTab.this.scrollPane.getViewport().add((Component)AttributeTab.this.panel, null);
                    AttributeTab.this.add((Component)AttributeTab.this.scrollPane, "Center");
                }
                AttributeTab.this.revalidate();
                AttributeTab.this.repaint();
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
            }
        });
        this.add((Component)this.toolBar, "North");
    }

    private void initScrollPane() {
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(new JTable().getRowHeight());
    }

    private void zoom(AttributePanel.Row row) throws NoninvertibleTransformException {
        this.panel.clearSelection();
        row.getPanel().getTable().getSelectionModel().setSelectionInterval(row.getIndex(), row.getIndex());
        Rectangle r = row.getPanel().getTable().getCellRect(row.getIndex(), 0, true);
        row.getPanel().getTable().scrollRectToVisible(r);
        if (row.isFirstRow()) {
            row.getPanel().scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        }
        this.panel.zoom(Collections.singletonList(row.getFeature()));
    }

    private void copy2Clipboard() throws Exception {
        this.attributesToClipboardPlugIn.execute(null);
    }

    private void export2Excel() throws Exception {
        this.attributesToExcelPlugIn.execute(null);
    }

    private void addRow() {
        if (this.getTables().size() != 1) {
            throw new IllegalStateException("Only one table should exist in the case of an attribute request and therefore only one layer is allowed.");
        }
        final JTable table = this.getTables().iterator().next();
        int rowCountBefore = table.getRowCount();
        final Layer layer = this.getPanel().getModel().getLayers().get(0);
        SimpleFeature newFeature = FeatureUtil.createFeature((SimpleFeatureType)layer.getFeatureType());
        final List<SimpleFeature> newFeatures = Arrays.asList(newFeature);
        layer.getLayerManager().getUndoableEditReceiver().startReceiving();
        UndoableCommand command = new UndoableCommand(this, I18N.get("ui.plugin.LayerTableModel.edit") + " " + layer.getName()){

            @Override
            public void execute() {
                layer.getLayerManager().setFiringEvents(false);
                try {
                    layer.editFeature(newFeatures, 1);
                }
                finally {
                    layer.getLayerManager().setFiringEvents(true);
                    ((LayerTableModel)table.getModel()).addAll(newFeatures);
                }
            }

            @Override
            public void unexecute() {
                layer.getLayerManager().setFiringEvents(false);
                try {
                    layer.editFeature(newFeatures, 3);
                }
                finally {
                    layer.getLayerManager().setFiringEvents(true);
                    ((LayerTableModel)table.getModel()).removeAll(newFeatures);
                }
            }
        };
        command.execute();
        layer.getLayerManager().getUndoableEditReceiver().receive(command.toUndoableEdit());
        layer.getLayerManager().getUndoableEditReceiver().stopReceiving();
        table.setRowSelectionInterval(rowCountBefore, rowCountBefore);
        table.scrollRectToVisible(new Rectangle(table.getCellRect(rowCountBefore, 0, true)));
    }

    public AttributePanel getPanel() {
        return this.panel;
    }

    private static /* synthetic */ String lambda$installToolBarButtons$2(Supplier valid, String errorMessage, JComponent component) {
        return (Boolean)valid.get() != false ? null : I18N.get(errorMessage);
    }
}

