/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.attributes;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.AttributeTablePanel;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.AttributeTablePanelListener;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.InfoModel;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.InfoModelListener;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.LayerTableModel;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManagerProxy;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomToSelectedItemsPlugIn;
import de.riwagis.geotools.feature.util.FeatureUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;

public class AttributePanel
extends JPanel
implements InfoModelListener,
AttributeTablePanelListener,
SelectionManagerProxy {
    private final SelectionManager selectionManager;
    private final GridBagLayout gridBagLayout1 = new GridBagLayout();
    private final Map<Layer, AttributeTablePanel> layerToTablePanelMap = new HashMap<Layer, AttributeTablePanel>();
    private InfoModel model;
    private final JPanel fillerPanel = new JPanel();
    private final WorkbenchContext workbenchContext;
    private final ZoomToSelectedItemsPlugIn zoomToSelectedItemsPlugIn = new ZoomToSelectedItemsPlugIn();
    private final Row nullRow = new Row(){

        @Override
        public boolean isFirstRow() {
            return AttributePanel.this.rowCount() == 0;
        }

        @Override
        public boolean isLastRow() {
            return AttributePanel.this.rowCount() == 0;
        }

        @Override
        public AttributeTablePanel getPanel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Row nextRow() {
            return this.firstRow();
        }

        @Override
        public Row previousRow() {
            return this.firstRow();
        }

        private Row firstRow() {
            return new BasicRow(AttributePanel.this.getTablePanel(AttributePanel.this.getModel().getLayers().get(0)), 0);
        }

        @Override
        public SimpleFeature getFeature() {
            throw new UnsupportedOperationException();
        }
    };
    private final TaskFrame taskFrame;

    protected AttributePanel(InfoModel model, WorkbenchContext workbenchContext, TaskFrame taskFrame) {
        this.selectionManager = new SelectionManager(taskFrame);
        this.selectionManager.setPanelUpdatesEnabled(false);
        this.taskFrame = taskFrame;
        this.workbenchContext = workbenchContext;
        this.setModel(model);
        this.jbInit();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (AttributePanel.this.layerToTablePanelMap.size() == 1) {
                    for (Layer currLayer : AttributePanel.this.layerToTablePanelMap.keySet()) {
                        JTable tbl = AttributePanel.this.getTablePanel(currLayer).getTable();
                        if (!tbl.isEditing()) continue;
                        tbl.getEditorComponent().requestFocusInWindow();
                    }
                }
            }
        });
    }

    public AttributeTablePanel getTablePanel(Layer layer) {
        return this.layerToTablePanelMap.get(layer);
    }

    public InfoModel getModel() {
        return this.model;
    }

    public final void setModel(InfoModel model) {
        this.model = model;
        model.addListener(this);
    }

    @Override
    public void layerAdded(LayerTableModel layerTableModel) {
        this.addTablePanel(layerTableModel);
    }

    @Override
    public void layerRemoved(LayerTableModel layerTableModel) {
        this.removeTablePanel(layerTableModel);
    }

    private void jbInit() {
        this.setLayout(new BorderLayout());
    }

    private void removeTablePanel(LayerTableModel layerTableModel) {
        Assert.isTrue((boolean)this.layerToTablePanelMap.containsKey(layerTableModel.getLayer()));
        this.remove(this.getTablePanel(layerTableModel.getLayer()));
        this.layerToTablePanelMap.remove(layerTableModel.getLayer());
        this.revalidate();
        this.repaint();
        this.updateSelectionManager();
    }

    private void addTablePanel(LayerTableModel layerTableModel) {
        Assert.isTrue((!this.layerToTablePanelMap.containsKey(layerTableModel.getLayer()) ? 1 : 0) != 0);
        boolean showInScrollPane = this.layerToTablePanelMap.isEmpty();
        AttributeTablePanel tablePanel = this.createAttributeTablePanel(layerTableModel, showInScrollPane);
        this.remove(this.fillerPanel);
        if (this.layerToTablePanelMap.size() == 1) {
            Map.Entry<Layer, AttributeTablePanel> firstEntry = this.layerToTablePanelMap.entrySet().iterator().next();
            this.remove(firstEntry.getValue());
            AttributeTablePanel firstTablePanel = firstEntry.getValue();
            firstTablePanel.hideScrollPane();
            this.layerToTablePanelMap.put(firstEntry.getKey(), firstTablePanel);
            this.setLayout(this.gridBagLayout1);
            this.add((Component)firstTablePanel, new GridBagConstraints(0, this.getComponentCount(), 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.layerToTablePanelMap.put(layerTableModel.getLayer(), tablePanel);
        if (showInScrollPane) {
            this.setLayout(new BorderLayout());
            this.add((Component)tablePanel, "Center");
        } else {
            this.add((Component)tablePanel, new GridBagConstraints(0, this.getComponentCount(), 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.fillerPanel, new GridBagConstraints(0, this.getComponentCount(), 1, 1, 0.0, 0.1, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.revalidate();
        this.repaint();
        this.updateSelectionManager();
    }

    public AttributeTablePanel createAttributeTablePanel(final LayerTableModel layerTableModel, boolean showInScrollPane) {
        final AttributeTablePanel tablePanel = new AttributeTablePanel(layerTableModel, this.workbenchContext, showInScrollPane, this.model.isLoadDataFromDatabase());
        tablePanel.addListener(this);
        tablePanel.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                try {
                    int row = tablePanel.getTable().rowAtPoint(e.getPoint());
                    if (row == -1) {
                        return;
                    }
                    ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
                    features.add(layerTableModel.getFeature(tablePanel.getTable().convertRowIndexToModel(row)));
                    if (AttributePanel.this.taskFrame.isVisible()) {
                        AttributePanel.this.zoomToSelectedItemsPlugIn.flash(FeatureUtil.toGeometries(features), AttributePanel.this.taskFrame.getLayerViewPanel());
                    }
                }
                catch (Throwable t) {
                    WorkbenchContext.getErrorHandler().handleThrowable(t);
                }
            }
        });
        tablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    AttributePanel.this.updateSelectionManager();
                }
            }
        });
        return tablePanel;
    }

    private void updateSelectionManager() {
        WorkbenchContext.getFrame().activateFrame(this.taskFrame);
        this.selectionManager.clear();
        for (AttributeTablePanel tablePanel : this.layerToTablePanelMap.values()) {
            this.selectionManager.getFeatureSelection().selectItems(tablePanel.getModel().getLayer(), tablePanel.getSelectedFeatures());
        }
    }

    public int rowCount() {
        int rowCount = 0;
        for (AttributeTablePanel tablePanel : this.layerToTablePanelMap.values()) {
            rowCount += tablePanel.getTable().getRowCount();
        }
        return rowCount;
    }

    public void flashSelectedFeatures() throws NoninvertibleTransformException {
        WorkbenchContext.getFrame().activateFrame(this.taskFrame);
        this.zoomToSelectedItemsPlugIn.flash(FeatureUtil.toGeometries(this.selectedFeatures()), this.taskFrame.getLayerViewPanel());
    }

    public void zoom(Collection<SimpleFeature> features) throws NoninvertibleTransformException {
        WorkbenchContext.getFrame().activateFrame(this.taskFrame);
        this.zoomToSelectedItemsPlugIn.zoom(FeatureUtil.toGeometries(features), this.taskFrame.getLayerViewPanel());
    }

    public Collection<SimpleFeature> selectedFeatures() {
        ArrayList<SimpleFeature> selectedFeatures = new ArrayList<SimpleFeature>();
        for (AttributeTablePanel tablePanel : this.layerToTablePanelMap.values()) {
            int[] selectedRows = tablePanel.getTable().getSelectedRows();
            for (int j = 0; j < selectedRows.length; ++j) {
                selectedFeatures.add(tablePanel.getModel().getFeature(tablePanel.getTable().convertRowIndexToModel(selectedRows[j])));
            }
        }
        return selectedFeatures;
    }

    public Map<Layer, Collection<SimpleFeature>> getSelectedFeaturesForLayers() {
        HashMap<Layer, Collection<SimpleFeature>> map = new HashMap<Layer, Collection<SimpleFeature>>();
        for (Map.Entry<Layer, AttributeTablePanel> entry : this.layerToTablePanelMap.entrySet()) {
            AttributeTablePanel tablePanel = entry.getValue();
            int[] selectedRows = tablePanel.getTable().getSelectedRows();
            if (selectedRows.length <= 0) continue;
            ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
            for (int j = 0; j < selectedRows.length; ++j) {
                features.add(tablePanel.getModel().getFeature(tablePanel.getTable().convertRowIndexToModel(selectedRows[j])));
            }
            map.put(entry.getKey(), features);
        }
        return map;
    }

    public void selectInLayerViewPanel() {
        WorkbenchContext.getFrame().activateFrame(this.taskFrame);
        this.taskFrame.getLayerViewPanel().getSelectionManager().clear();
        for (AttributeTablePanel tablePanel : this.layerToTablePanelMap.values()) {
            ArrayList<SimpleFeature> selectedFeatures = new ArrayList<SimpleFeature>();
            for (int currRow : tablePanel.getTable().getSelectedRows()) {
                selectedFeatures.add(tablePanel.getModel().getFeature(tablePanel.getTable().convertRowIndexToModel(currRow)));
            }
            this.taskFrame.getLayerViewPanel().getSelectionManager().getFeatureSelection().selectItems(tablePanel.getModel().getLayer(), selectedFeatures);
        }
    }

    public Row topSelectedRow() {
        for (AttributeTablePanel panel : this.layerToTablePanelMap.values()) {
            int selectedRow = panel.getTable().getSelectedRow();
            if (selectedRow == -1) continue;
            return new BasicRow(panel, selectedRow);
        }
        return this.nullRow;
    }

    @Override
    public void selectionReplaced(AttributeTablePanel panel) {
        for (AttributeTablePanel tablePanel : this.layerToTablePanelMap.values()) {
            if (tablePanel == panel) continue;
            tablePanel.getTable().clearSelection();
        }
    }

    public void clearSelection() {
        for (AttributeTablePanel tablePanel : this.layerToTablePanelMap.values()) {
            tablePanel.getTable().clearSelection();
        }
    }

    private void setSelection() {
        for (Layer currLayer : this.layerToTablePanelMap.keySet()) {
            this.setSelection(currLayer);
        }
    }

    private void setSelection(Layer currLayer) {
        JTable tbl = this.getTablePanel(currLayer).getTable();
        tbl.clearSelection();
        LayerTableModel currModel = (LayerTableModel)tbl.getModel();
        Collection<SimpleFeature> selectedFeatures = this.workbenchContext.getSelectionManager().getFeaturesWithSelectedItems(currLayer);
        if (selectedFeatures.isEmpty()) {
            return;
        }
        tbl.getSelectionModel().setValueIsAdjusting(true);
        for (SimpleFeature selectedFeature : selectedFeatures) {
            int row = currModel.getRow(selectedFeature.getID());
            if (row == -1) continue;
            tbl.getSelectionModel().addSelectionInterval(row, row);
        }
        tbl.getSelectionModel().setValueIsAdjusting(false);
        if (!tbl.getSelectionModel().isSelectionEmpty()) {
            tbl.scrollRectToVisible(tbl.getCellRect(tbl.getSelectionModel().getLeadSelectionIndex(), -1, true));
        }
    }

    @Override
    public SelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public static interface Row {
        public boolean isFirstRow();

        public boolean isLastRow();

        public AttributeTablePanel getPanel();

        public int getIndex();

        public Row nextRow();

        public Row previousRow();

        public SimpleFeature getFeature();
    }

    private class BasicRow
    implements Row {
        private final AttributeTablePanel panel;
        private final int index;

        BasicRow(AttributeTablePanel panel, int index) {
            this.panel = panel;
            this.index = index;
        }

        @Override
        public boolean isFirstRow() {
            return this.panel.getModel().getLayer() == AttributePanel.this.getModel().getLayers().get(0) && this.index == 0;
        }

        @Override
        public boolean isLastRow() {
            return this.panel.getModel().getLayer() == AttributePanel.this.getModel().getLayers().get(AttributePanel.this.getModel().getLayers().size() - 1) && this.index == this.panel.getTable().getRowCount() - 1;
        }

        @Override
        public AttributeTablePanel getPanel() {
            return this.panel;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public Row previousRow() {
            if (this.isFirstRow()) {
                return this;
            }
            if (this.index > 0) {
                return new BasicRow(this.panel, this.index - 1);
            }
            return new BasicRow(this.previousPanel(), this.previousPanel().getTable().getRowCount() - 1);
        }

        @Override
        public Row nextRow() {
            if (this.isLastRow()) {
                return this;
            }
            if (this.index < this.panel.getTable().getRowCount() - 1) {
                return new BasicRow(this.panel, this.index + 1);
            }
            return new BasicRow(this.nextPanel(), 0);
        }

        private AttributeTablePanel previousPanel() {
            return AttributePanel.this.getTablePanel(this.previousLayer());
        }

        private AttributeTablePanel nextPanel() {
            return AttributePanel.this.getTablePanel(this.nextLayer());
        }

        private Layer previousLayer() {
            return AttributePanel.this.getModel().getLayers().get(AttributePanel.this.getModel().getLayers().indexOf(this.panel.getModel().getLayer()) - 1);
        }

        private Layer nextLayer() {
            return AttributePanel.this.getModel().getLayers().get(AttributePanel.this.getModel().getLayers().indexOf(this.panel.getModel().getLayer()) + 1);
        }

        @Override
        public SimpleFeature getFeature() {
            return this.panel.getModel().getFeature(this.panel.getTable().convertRowIndexToModel(this.index));
        }
    }
}

