/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import de.riwagis.icons.IconLoader;
import de.riwagis.riwajump.model.search.SearchCollectionModel;
import de.riwagis.riwajump.search.gui.MapContextSearchDialog;
import java.awt.Frame;
import java.awt.Point;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.KeyStroke;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class ZoomDataPlugIn
extends AbstractPlugIn {
    private MapContextSearchDialog dlgSearch = null;
    private SearchCollectionModel searchCollection = null;

    @Override
    public void initialize(final PlugInContext context) throws Exception {
        this.registerFindKey(context.getWorkbenchContext());
        GUIUtil.addInternalFrameListener(WorkbenchContext.getFrame().getDesktopPane(), new InternalFrameAdapter(){

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
                JInternalFrame frm;
                if (ZoomDataPlugIn.this.dlgSearch != null && ZoomDataPlugIn.this.dlgSearch.isVisible() && (frm = e.getInternalFrame()) instanceof TaskFrame) {
                    ZoomDataPlugIn.this.getDialog(context);
                }
            }
        });
    }

    private void registerFindKey(WorkbenchContext context) {
        JUMPWorkbench.getFrame().addKeyboardShortcut(70, 128, this, this.createEnableCheck());
    }

    private MapContextSearchDialog getDialog(PlugInContext context) {
        Task task = WorkbenchContext.getTask();
        SearchCollectionModel taskSearches = task.getSearches();
        if (taskSearches == null || taskSearches.isEmpty()) {
            if (this.dlgSearch != null && this.dlgSearch.isVisible()) {
                this.dlgSearch.setVisible(false);
            }
            return null;
        }
        taskSearches.sortList();
        if (this.dlgSearch == null) {
            this.dlgSearch = new MapContextSearchDialog((Frame)WorkbenchContext.getFrame(), task.getLayerManager().getMapContext(), taskSearches, task.getDataStores());
            int x = context.getWorkbenchFrame().getLocationOnScreen().x + 20;
            int y = context.getWorkbenchFrame().getLocationOnScreen().y + 90;
            Point dlgLocation = (Point)PersistentBlackboardPlugIn.get().get("CONTEXT_SEARCH_LOCATION", new Point(x, y));
            this.dlgSearch.setLocation(dlgLocation);
            this.searchCollection = taskSearches;
        } else if (taskSearches == null || taskSearches != this.searchCollection) {
            this.dlgSearch.setSearches(task.getLayerManager().getMapContext(), taskSearches, task.getDataStores());
            this.searchCollection = taskSearches;
        }
        return this.dlgSearch;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        MapContextSearchDialog dlg = this.getDialog(context);
        if (dlg != null) {
            dlg.setVisible(true);
        }
        return true;
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.ZoomDataPlugIn.name");
    }

    @Override
    public KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(70, 128);
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        final MultiEnableCheck chk = new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck());
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                String strCheck = chk.check(component);
                if (strCheck == null) {
                    Task task = WorkbenchContext.getTask();
                    SearchCollectionModel lstSearches = task.getSearches();
                    if (lstSearches == null || lstSearches.size() == 0) {
                        return "no searches found.";
                    }
                    return null;
                }
                return strCheck;
            }
        };
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"common_search.svg");
    }
}

