/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchException;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.EnterWKTDialog;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import de.riwagis.geotools.feature.util.FeatureUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Reader;
import java.io.StringReader;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.operation.valid.IsValidOp;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public abstract class WKTPlugIn
extends AbstractPlugIn {
    protected Layer layer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validate(FeatureCollection<SimpleFeatureType, SimpleFeature> c, PlugInContext context) throws WorkbenchException {
        try (FeatureIterator i = c.features();){
            while (i.hasNext()) {
                IsValidOp op;
                SimpleFeature f = (SimpleFeature)i.next();
                if (f.getDefaultGeometry() == null || (op = new IsValidOp((Geometry)f.getDefaultGeometry())).isValid()) continue;
                if (JUMPWorkbench.getBlackboard().get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false)) {
                    throw new WorkbenchException(op.getValidationError().getMessage());
                }
                context.getWorkbenchFrame().warnUser(op.getValidationError().getMessage());
            }
        }
    }

    protected abstract Layer layer(PlugInContext var1);

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.layer = this.layer(context);
        EnterWKTDialog d = this.createDialog(context);
        d.setVisible(true);
        return d.wasOKPressed();
    }

    protected abstract void apply(FeatureCollection<SimpleFeatureType, SimpleFeature> var1, PlugInContext var2) throws WorkbenchException;

    protected EnterWKTDialog createDialog(final PlugInContext context) {
        final EnterWKTDialog d = new EnterWKTDialog(context.getWorkbenchFrame(), I18N.get("ui.plugin.WKTPlugIn.enter-well-known-text"), true);
        d.setSize(500, 400);
        d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (d.wasOKPressed()) {
                        WKTPlugIn.this.apply(d.getText(), context);
                    }
                    d.setVisible(false);
                }
                catch (Throwable t) {
                    context.getErrorHandler().handleThrowable(t);
                }
            }
        });
        GUIUtil.centreOnWindow(d);
        return d;
    }

    protected void apply(String wkt, PlugInContext context) throws Exception {
        if (wkt.isBlank()) {
            SimpleFeatureCollection c = DataUtilities.collection((SimpleFeature)FeatureUtil.getGeomFeature(null));
            this.validate((FeatureCollection<SimpleFeatureType, SimpleFeature>)c, context);
            this.apply((FeatureCollection<SimpleFeatureType, SimpleFeature>)c, context);
            return;
        }
        try (StringReader stringReader = new StringReader(wkt);){
            FeatureCollection c = FeatureUtil.readWKTFeatureCollection((Reader)stringReader);
            if (c.isEmpty()) {
                c = DataUtilities.collection((SimpleFeature)FeatureUtil.getGeomFeature(null));
            }
            this.validate((FeatureCollection<SimpleFeatureType, SimpleFeature>)c, context);
            this.apply((FeatureCollection<SimpleFeatureType, SimpleFeature>)c, context);
        }
    }
}

