/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.io.FUTURE_JTS_WKTWriter;
import com.vividsolutions.jump.util.Fmt;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.plugin.WKTDisplayHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.algorithm.PointLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKTWriter;

public class VerticesInFencePlugIn
extends AbstractPlugIn {
    private final FUTURE_JTS_WKTWriter wktWriter = new FUTURE_JTS_WKTWriter();
    private final GeometryFactory factory = new GeometryFactory();
    private final WKTDisplayHelper helper = new WKTDisplayHelper();

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        return true;
    }

    public static Collection<Coordinate> verticesInFence(Collection<Geometry> geometries, Geometry fence, boolean skipClosingVertex) {
        ArrayList<Coordinate> verticesInFence = new ArrayList<Coordinate>();
        for (Geometry geometry : geometries) {
            verticesInFence.addAll(VerticesInFencePlugIn.verticesInFence(geometry, fence, skipClosingVertex).getCoordinates());
        }
        return verticesInFence;
    }

    public static VerticesInFence verticesInFence(Geometry geometry, Geometry fence, boolean skipClosingVertex) {
        final ArrayList coordinates = new ArrayList();
        final ArrayList indices = new ArrayList();
        PointLocator pointLocator = new PointLocator();
        IntWrapper index = new IntWrapper(-1);
        geometry.apply(geometry1 -> {
            if (geometry1 instanceof GeometryCollection || geometry1 instanceof Polygon) {
                return;
            }
            Coordinate[] component = geometry1.getCoordinates();
            for (int j = 0; j < component.length; ++j) {
                ++index.value;
                if (skipClosingVertex && component.length > 1 && j == component.length - 1 && component[j].equals((Object)component[0]) || pointLocator.locate(component[j], fence) == 2) continue;
                coordinates.add(component[j]);
                indices.add(index.value);
            }
        });
        return new VerticesInFence(){

            @Override
            public List<Coordinate> getCoordinates() {
                return coordinates;
            }

            @Override
            public int getIndex(int i) {
                return (Integer)indices.get(i);
            }
        };
    }

    private String description(VerticesInFence verticesInFence, Geometry geometry) {
        StringBuilder description = new StringBuilder();
        description.append("<pre>");
        for (int i = 0; i < verticesInFence.getCoordinates().size(); ++i) {
            description.append(GUIUtil.escapeHTML("[" + Fmt.fmt(this.helper.annotation(geometry, verticesInFence.getCoordinates().get(i)), 10) + "] " + this.wktWriter.write((Geometry)this.factory.createPoint(verticesInFence.getCoordinates().get(i))) + "\n", false, false));
        }
        description.append("</pre>");
        return description.toString();
    }

    public static void main(String[] args) {
        new WKTWriter();
        new Object().toString();
    }

    public static interface VerticesInFence {
        public List<Coordinate> getCoordinates();

        public int getIndex(int var1);
    }

    private static class IntWrapper {
        public int value;

        public IntWrapper(int value) {
            this.value = value;
        }
    }
}

