/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingListener;
import de.riwagis.icons.IconLoader;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class StopRenderingPlugIn
extends AbstractPlugIn {
    private AbstractButton butStop = null;

    @Override
    public String getName() {
        return I18N.get("ui.plugin.StopRenderingPlugIn.name");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        if (this.isAvailable()) {
            GUIUtil.addInternalFrameListener(WorkbenchContext.getFrame().getDesktopPane(), new InternalFrameAdapter(){

                @Override
                public void internalFrameActivated(InternalFrameEvent e) {
                    JInternalFrame frm = e.getInternalFrame();
                    if (frm instanceof TaskFrame) {
                        StopRenderingPlugIn.this.installListenerOnCurrentPanel((TaskFrame)frm);
                    }
                }
            });
        }
    }

    private RenderingListener installListenerOnCurrentPanel(TaskFrame tFrame) {
        String RENDERING_LISTENERS_INSTALLED_KEY = Integer.toHexString(this.hashCode()) + " - RENDERING LISTENERS INSTALLED";
        LayerViewPanel lvp = tFrame.getLayerViewPanel();
        if (lvp == null) {
            return null;
        }
        if (lvp.getBlackboard().get(RENDERING_LISTENERS_INSTALLED_KEY) != null) {
            return null;
        }
        RenderingListener rlist = new RenderingListener(){

            @Override
            public void renderingStarted(LayerViewPanel panel) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (StopRenderingPlugIn.this.butStop != null) {
                            StopRenderingPlugIn.this.butStop.setEnabled(true);
                        }
                    }
                });
            }

            @Override
            public void renderingStopped(LayerViewPanel panel) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (StopRenderingPlugIn.this.butStop != null) {
                            StopRenderingPlugIn.this.butStop.setEnabled(false);
                        }
                    }
                });
            }
        };
        lvp.getRenderingManager().addRenderingListener(rlist);
        lvp.getBlackboard().put(RENDERING_LISTENERS_INSTALLED_KEY, new Object());
        return rlist;
    }

    public void setButton(AbstractButton _butStop) {
        this.butStop = _butStop;
        this.butStop.setEnabled(false);
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"common_stop.svg");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        if (context.getLayerViewPanel() == null) {
            return true;
        }
        context.getLayerViewPanel().getRenderingManager().stopAll();
        return true;
    }

    @Override
    public EnableCheck createEnableCheck() {
        return null;
    }
}

