/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.ShowCoordinateDialog;
import com.vividsolutions.jump.workbench.ui.snap.SnapManager;
import de.riwagis.crs.CRSDefinition;
import java.awt.Frame;
import org.locationtech.jts.geom.Coordinate;

public class ShowCoordinatePlugIn
extends AbstractPlugIn {
    private final SnapManager snapManager = new SnapManager();
    private ShowCoordinateDialog dlg;

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        this.snapManager.addPolicies(AbstractCursorTool.createStandardSnappingPolicies(PersistentBlackboardPlugIn.get()));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Coordinate c = this.snap(context, context.getLayerViewPanel().getViewport().toModelCoordinate(context.getLayerViewPanel().getLastClickedPoint()));
        CRSDefinition crsdef = context.getTask().getCRSDefinition();
        if (this.dlg == null) {
            this.dlg = new ShowCoordinateDialog((Frame)JUMPWorkbench.getFrame(), true);
            this.dlg.setTitle(I18N.get("ui.plugin.ShowCoordinatePlugIn.title"));
            this.dlg.setResizable(false);
            GUIUtil.centreOnWindow(this.dlg);
        }
        this.dlg.setCRSDefinition(crsdef);
        this.dlg.setCoordinate(c);
        this.dlg.fillContent();
        this.dlg.pack();
        this.dlg.setVisible(true);
        return true;
    }

    private Coordinate snap(PlugInContext context, Coordinate modelCoordinate) {
        return this.snapManager.snap(context.getLayerViewPanel(), modelCoordinate);
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.ShowCoordinatePlugIn.name");
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck());
    }
}

