/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.DummyClipboardOwner;
import de.riwagis.browser.util.BrowserSupport;
import de.riwagis.crs.CRSDefFactory;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.crs.Transformer;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Coordinate;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class ShowCoordinateDialog
extends JDialog {
    private final DecimalFormat df = new DecimalFormat();
    private final JPopupMenu mnuCurrentCRS = new JPopupMenu();
    private final JPopupMenu mnuTransformedCRS = new JPopupMenu();
    private CRSDefinition crsDefinition;
    private Coordinate coord;
    private JComboBox<CRSDefinition> cmbTransformCRS;
    private Box.Filler filler2;
    private JLabel lblAddFormats;
    private JLabel lblArrow;
    private JLabel lblCurrentCRS_X;
    private JLabel lblCurrentCRS_Y;
    private JLabel lblInfoMessage;
    private JLabel lblInfoSymbol;
    private JLabel lblLink;
    private JLabel lblTitleCurrentCRS;
    private JList<String> lstAddFormatsCurrentCRS;
    private JList<String> lstAddFormatsTranformedCRS;
    private JPanel pnlContent;
    private JScrollPane scpAddFormatsCurrentCRS;
    private JScrollPane scpAddFormatsTransformedCRS;
    private JTextField tfiConverted_X;
    private JTextField tfiConverted_Y;
    private JFormattedTextField tfiCurrentCRS_X;
    private JFormattedTextField tfiCurrentCRS_Y;

    public ShowCoordinateDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.init();
    }

    private void initComponents() {
        this.pnlContent = new JPanel();
        this.lblTitleCurrentCRS = new JLabel();
        this.lblCurrentCRS_Y = new JLabel();
        this.lblCurrentCRS_X = new JLabel();
        this.lblArrow = new JLabel();
        this.tfiConverted_Y = new JTextField();
        this.tfiConverted_X = new JTextField();
        this.cmbTransformCRS = new JComboBox();
        this.scpAddFormatsCurrentCRS = new JScrollPane();
        this.lstAddFormatsCurrentCRS = new JList();
        this.lblAddFormats = new JLabel();
        this.scpAddFormatsTransformedCRS = new JScrollPane();
        this.lstAddFormatsTranformedCRS = new JList();
        this.lblLink = new JLabel();
        this.tfiCurrentCRS_X = new JFormattedTextField();
        this.tfiCurrentCRS_Y = new JFormattedTextField();
        this.lblInfoMessage = new JLabel();
        this.lblInfoSymbol = new JLabel();
        this.filler2 = new Box.Filler(new Dimension(10, 10), new Dimension(10, 10), new Dimension(10, 10));
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.pnlContent.setLayout(new GridBagLayout());
        this.lblTitleCurrentCRS.setFont(this.lblTitleCurrentCRS.getFont().deriveFont(this.lblTitleCurrentCRS.getFont().getStyle() | 1, this.lblTitleCurrentCRS.getFont().getSize() + 3));
        this.lblTitleCurrentCRS.setText("Current CRS");
        this.lblTitleCurrentCRS.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.pnlContent.add((Component)this.lblTitleCurrentCRS, gridBagConstraints);
        this.lblCurrentCRS_Y.setLabelFor(this.tfiCurrentCRS_Y);
        ResourceBundle bundle = ResourceBundle.getBundle("language/jump");
        this.lblCurrentCRS_Y.setText(bundle.getString("ui.plugin.ShowCoordinateDialog.northing"));
        this.lblCurrentCRS_Y.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.pnlContent.add((Component)this.lblCurrentCRS_Y, gridBagConstraints);
        this.lblCurrentCRS_X.setLabelFor(this.tfiCurrentCRS_X);
        this.lblCurrentCRS_X.setText(bundle.getString("ui.plugin.ShowCoordinateDialog.easting"));
        this.lblCurrentCRS_X.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.pnlContent.add((Component)this.lblCurrentCRS_X, gridBagConstraints);
        this.lblArrow.setText("<html><font size=+1>&#8594;</html>");
        this.lblArrow.setFocusable(false);
        this.lblArrow.setMinimumSize(new Dimension(20, 22));
        this.lblArrow.setPreferredSize(new Dimension(20, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 20, 0, 20);
        this.pnlContent.add((Component)this.lblArrow, gridBagConstraints);
        this.tfiConverted_Y.setEditable(false);
        this.tfiConverted_Y.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlContent.add((Component)this.tfiConverted_Y, gridBagConstraints);
        this.tfiConverted_X.setEditable(false);
        this.tfiConverted_X.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlContent.add((Component)this.tfiConverted_X, gridBagConstraints);
        this.cmbTransformCRS.setMinimumSize(new Dimension(250, 22));
        this.cmbTransformCRS.setNextFocusableComponent(this.tfiCurrentCRS_X);
        this.cmbTransformCRS.setPreferredSize(new Dimension(250, 22));
        this.cmbTransformCRS.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ShowCoordinateDialog.this.cmbTransformCRSItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.pnlContent.add(this.cmbTransformCRS, gridBagConstraints);
        this.scpAddFormatsCurrentCRS.setMinimumSize(new Dimension(200, 80));
        this.scpAddFormatsCurrentCRS.setPreferredSize(new Dimension(200, 80));
        this.lstAddFormatsCurrentCRS.setSelectionMode(0);
        this.lstAddFormatsCurrentCRS.setNextFocusableComponent(this.lstAddFormatsTranformedCRS);
        this.lstAddFormatsCurrentCRS.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ShowCoordinateDialog.this.lstAddFormatsCurrentCRSMousePressed(evt);
            }
        });
        this.scpAddFormatsCurrentCRS.setViewportView(this.lstAddFormatsCurrentCRS);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        this.pnlContent.add((Component)this.scpAddFormatsCurrentCRS, gridBagConstraints);
        this.lblAddFormats.setFont(this.lblAddFormats.getFont().deriveFont(this.lblAddFormats.getFont().getStyle() | 1, this.lblAddFormats.getFont().getSize() + 3));
        this.lblAddFormats.setText(bundle.getString("ui.plugin.ShowCoordinateDialog.additional-formats"));
        this.lblAddFormats.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.pnlContent.add((Component)this.lblAddFormats, gridBagConstraints);
        this.scpAddFormatsTransformedCRS.setMinimumSize(new Dimension(200, 80));
        this.scpAddFormatsTransformedCRS.setPreferredSize(new Dimension(200, 80));
        this.lstAddFormatsTranformedCRS.setSelectionMode(0);
        this.lstAddFormatsTranformedCRS.setName("");
        this.lstAddFormatsTranformedCRS.setNextFocusableComponent(this.cmbTransformCRS);
        this.lstAddFormatsTranformedCRS.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ShowCoordinateDialog.this.lstAddFormatsTranformedCRSMousePressed(evt);
            }
        });
        this.scpAddFormatsTransformedCRS.setViewportView(this.lstAddFormatsTranformedCRS);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        this.pnlContent.add((Component)this.scpAddFormatsTransformedCRS, gridBagConstraints);
        this.lblLink.setText("Google Maps-Link");
        this.lblLink.setToolTipText("");
        this.lblLink.setCursor(new Cursor(12));
        this.lblLink.setNextFocusableComponent(this.lstAddFormatsCurrentCRS);
        this.lblLink.setOpaque(true);
        this.lblLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ShowCoordinateDialog.this.lblLinkMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                ShowCoordinateDialog.this.lblLinkMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ShowCoordinateDialog.this.lblLinkMouseExited(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.pnlContent.add((Component)this.lblLink, gridBagConstraints);
        this.tfiCurrentCRS_X.setColumns(8);
        this.tfiCurrentCRS_X.setNextFocusableComponent(this.tfiCurrentCRS_Y);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlContent.add((Component)this.tfiCurrentCRS_X, gridBagConstraints);
        this.tfiCurrentCRS_Y.setColumns(8);
        this.tfiCurrentCRS_Y.setNextFocusableComponent(this.lblLink);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlContent.add((Component)this.tfiCurrentCRS_Y, gridBagConstraints);
        this.lblInfoMessage.setText(bundle.getString("common.transform-information"));
        this.lblInfoMessage.setToolTipText("");
        this.lblInfoMessage.setVerticalAlignment(1);
        this.lblInfoMessage.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.pnlContent.add((Component)this.lblInfoMessage, gridBagConstraints);
        this.lblInfoSymbol.setText("<html><font size=+0>&#9432;</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.pnlContent.add((Component)this.lblInfoSymbol, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.pnlContent.add((Component)this.filler2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.pnlContent, gridBagConstraints);
    }

    private void init() {
        ItemListener[] itemListeners;
        for (ItemListener listener : itemListeners = this.cmbTransformCRS.getItemListeners()) {
            this.cmbTransformCRS.removeItemListener(listener);
        }
        ArrayList lstCRS = new ArrayList(CRSDefFactory.getCRSDefinitionList());
        Collections.sort(lstCRS);
        HashSet<String> keyExcpetions = new HashSet<String>(){
            {
                this.add("xy");
                this.add("99999001");
                this.add("99999002");
            }
        };
        for (CRSDefinition crsDef : lstCRS) {
            String key = crsDef.getKey();
            if (keyExcpetions.contains(key)) continue;
            this.cmbTransformCRS.addItem(crsDef);
        }
        this.cmbTransformCRS.setSelectedItem(CRSDefFactory.getCRSDefinition((String)"4326"));
        for (ItemListener listener : itemListeners) {
            this.cmbTransformCRS.addItemListener(listener);
        }
        this.lstAddFormatsTranformedCRS.setModel(new DefaultListModel());
        GUISupport.addCopyInsertPopup((JTextComponent)this.tfiCurrentCRS_X);
        GUISupport.addCopyInsertPopup((JTextComponent)this.tfiCurrentCRS_Y);
        GUISupport.addCopyPopup((JTextComponent)this.tfiConverted_X);
        GUISupport.addCopyPopup((JTextComponent)this.tfiConverted_Y);
        JMenuItem itemCurrentCopy = new JMenuItem(I18N.get("common.copy"));
        itemCurrentCopy.addActionListener(new CopyAction(this, this.lstAddFormatsCurrentCRS));
        this.mnuCurrentCRS.add(itemCurrentCopy);
        JMenuItem itemTransformedCopy = new JMenuItem(I18N.get("common.copy"));
        itemTransformedCopy.addActionListener(new CopyAction(this, this.lstAddFormatsTranformedCRS));
        this.mnuTransformedCRS.add(itemTransformedCopy);
        this.tfiCurrentCRS_X.setDocument(new DecimalSizeDocument(15));
        this.tfiCurrentCRS_Y.setDocument(new DecimalSizeDocument(15));
        this.tfiCurrentCRS_X.getDocument().addDocumentListener(new CoordinateDocumentListener());
        this.tfiCurrentCRS_Y.getDocument().addDocumentListener(new CoordinateDocumentListener());
        this.pack();
    }

    public void setCRSDefinition(CRSDefinition crsDef) {
        this.crsDefinition = crsDef;
    }

    public void setCoordinate(Coordinate c) {
        this.coord = c;
    }

    public void fillContent() throws Exception {
        this.lblTitleCurrentCRS.setText(this.crsDefinition.getName());
        this.df.setGroupingUsed(false);
        this.df.setMaximumFractionDigits(3);
        String strX = this.df.format(this.coord.x);
        String strY = this.df.format(this.coord.y);
        this.tfiCurrentCRS_X.setText(strX);
        this.tfiCurrentCRS_Y.setText(strY);
        if (this.crsDefinition.getCode() == null) {
            this.handleDynamicComponents(false);
            this.tfiConverted_X.setText("");
            this.tfiConverted_Y.setText("");
            this.lstAddFormatsTranformedCRS.setListData((String[])new String[0]);
            this.lblInfoSymbol.setVisible(false);
            this.lblInfoMessage.setVisible(false);
        } else {
            this.handleDynamicComponents(true);
        }
        this.lstAddFormatsCurrentCRS.setListData((String[])this.generateAdditionalFormats(strX, strY));
    }

    private String[] generateAdditionalFormats(String X, String Y) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(X.concat(";").concat(Y));
        if (X.contains(",")) {
            values.add(X.replaceAll(",", ".").concat(";").concat(Y.replaceAll(",", ".")));
        }
        values.add(X.concat("|").concat(Y));
        if (X.contains(",")) {
            values.add(X.replaceAll(",", ".").concat("|").concat(Y.replaceAll(",", ".")));
        }
        return values.toArray(new String[0]);
    }

    private void lblLinkMouseClicked(MouseEvent evt) {
        if (this.crsDefinition.getCode() != null) {
            try {
                Transformer trans = new Transformer(this.crsDefinition.getCode(), "EPSG:4326");
                Coordinate wgs84coord = (Coordinate)this.coord.clone();
                trans.transform2d(wgs84coord);
                this.df.setMaximumFractionDigits(7);
                String strWgsX = this.df.format(wgs84coord.x).replaceAll(",", ".");
                String strWgsY = this.df.format(wgs84coord.y).replaceAll(",", ".");
                BrowserSupport.openBrowser((String)String.format("http://www.google.com/maps/place/%s,%s", strWgsY, strWgsX));
            }
            catch (Exception ex) {
                ExceptionDialog.handleGuiException((Component)this, (Exception)ex, this.getClass());
            }
        }
    }

    private void lstAddFormatsCurrentCRSMousePressed(MouseEvent evt) {
        if (SwingUtilities.isRightMouseButton(evt)) {
            this.lstAddFormatsCurrentCRS.setSelectedIndex(this.lstAddFormatsCurrentCRS.locationToIndex(evt.getPoint()));
            this.mnuCurrentCRS.show(this.lstAddFormatsCurrentCRS, evt.getPoint().x, evt.getPoint().y);
        }
    }

    private void lstAddFormatsTranformedCRSMousePressed(MouseEvent evt) {
        if (SwingUtilities.isRightMouseButton(evt)) {
            this.lstAddFormatsTranformedCRS.setSelectedIndex(this.lstAddFormatsTranformedCRS.locationToIndex(evt.getPoint()));
            this.mnuTransformedCRS.show(this.lstAddFormatsTranformedCRS, evt.getPoint().x, evt.getPoint().y);
        }
    }

    private void lblLinkMouseEntered(MouseEvent evt) {
        this.lblLink.setForeground(Color.BLUE);
    }

    private void lblLinkMouseExited(MouseEvent evt) {
        this.lblLink.setForeground(UIManager.getColor("Label.foreground"));
    }

    private void cmbTransformCRSItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            CRSDefinition crsDef = (CRSDefinition)evt.getItem();
            this.transformCoordinates(crsDef);
        }
    }

    private void transformCoordinates(CRSDefinition crsDef) {
        if (this.crsDefinition.getCode() != null) {
            String xValue = this.tfiCurrentCRS_X.getText();
            String yValue = this.tfiCurrentCRS_Y.getText();
            if (xValue.length() > 0 && yValue.length() > 0) {
                if (this.crsDefinition.getCode().equals(crsDef.getCode())) {
                    this.tfiConverted_X.setText(xValue);
                    this.tfiConverted_Y.setText(yValue);
                    this.lblInfoSymbol.setVisible(false);
                    this.lblInfoMessage.setVisible(false);
                    this.lstAddFormatsTranformedCRS.setListData((String[])this.generateAdditionalFormats(xValue, yValue));
                } else {
                    this.coord = new Coordinate(Double.parseDouble(xValue.replaceAll(",", ".")), Double.parseDouble(yValue.replaceAll(",", ".")));
                    try {
                        Coordinate c = new Coordinate(this.coord);
                        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)CRSDefFactory.createCRS((String)this.crsDefinition.getCode()), (CoordinateReferenceSystem)CRSDefFactory.createCRS((String)crsDef.getCode()), (boolean)true);
                        c = JTS.transform((Coordinate)c, null, (MathTransform)transform);
                        this.df.setMaximumFractionDigits(7);
                        String strX = this.df.format(c.x);
                        String strY = this.df.format(c.y);
                        this.tfiConverted_X.setText(strX);
                        this.tfiConverted_Y.setText(strY);
                        this.lblInfoSymbol.setVisible(true);
                        this.lblInfoMessage.setVisible(true);
                        this.lstAddFormatsTranformedCRS.setListData((String[])this.generateAdditionalFormats(strX, strY));
                    }
                    catch (Exception ex) {
                        ExceptionDialog.handleGuiException((Component)this, (Exception)ex, this.getClass());
                    }
                }
            }
        }
    }

    private void handleDynamicComponents(boolean value) {
        this.cmbTransformCRS.setEnabled(value);
        this.lblLink.setEnabled(value);
        this.lstAddFormatsTranformedCRS.setEnabled(value);
    }

    private class CopyAction
    implements ActionListener {
        private final JList<String> list;

        public CopyAction(ShowCoordinateDialog showCoordinateDialog, JList<String> lst) {
            this.list = lst;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.list.getSelectedValue()), new DummyClipboardOwner());
        }
    }

    private class DecimalSizeDocument
    extends PlainDocument {
        DecimalFormat format = (DecimalFormat)NumberFormat.getInstance();
        DecimalFormatSymbols symbols = this.format.getDecimalFormatSymbols();
        final String decSep = String.valueOf(this.symbols.getDecimalSeparator());
        private final int maxTextLength;

        public DecimalSizeDocument(int maxTextLength) {
            this.maxTextLength = maxTextLength;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null || str.length() == 0) {
                return;
            }
            if (this.getLength() + str.length() <= this.maxTextLength) {
                if (!str.contains(this.decSep)) {
                    try {
                        Double.parseDouble(str);
                    }
                    catch (NumberFormatException ex) {
                        return;
                    }
                } else if (this.getText(0, offs).contains(this.decSep)) {
                    return;
                }
                super.insertString(offs, str, a);
            }
        }
    }

    private class CoordinateDocumentListener
    implements DocumentListener {
        private CoordinateDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ShowCoordinateDialog.this.transformCoordinates((CRSDefinition)ShowCoordinateDialog.this.cmbTransformCRS.getSelectedItem());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ShowCoordinateDialog.this.transformCoordinates((CRSDefinition)ShowCoordinateDialog.this.cmbTransformCRS.getSelectedItem());
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }
}

