/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.plugin.ExportImagePlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.gce.image.WorldImageFormat;
import org.geotools.gce.image.WorldImageWriter;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.parameter.Parameter;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveImageAsPlugIn
extends ExportImagePlugIn {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SaveImageAsPlugIn.class);
    private final List<MyFileFilter> myFileFilters = Arrays.asList(this.createFileFilter("PNG - Portable Network Graphics", "png", 2), this.createFileFilter("JPEG - Joint Photographic Experts Group", "jpg", 1), this.createFileFilter("TIFF - Tagged Image File Format", "tif", 1), this.createFileFilter("GIF - Graphics Interchange Format", "gif", 1));
    private JFileChooser fileChooser = null;
    private static final String FORMAT_KEY = "FORMAT";
    private static final String LAST_FILENAME_KEY = "LAST FILENAME";

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new GUIUtil.FileChooserWithOverwritePrompting(){

                @Override
                protected File selectedFile() {
                    return new File(SaveImageAsPlugIn.this.addExtension(super.selectedFile().getPath(), ((MyFileFilter)this.getFileFilter()).getFormat()));
                }
            };
            this.fileChooser.setDialogTitle(I18N.get("ui.plugin.SaveImageAsPlugIn.save-image"));
            GUIUtil.removeChoosableFileFilters(this.fileChooser);
            HashMap<String, MyFileFilter> formatToFileFilterMap = new HashMap<String, MyFileFilter>();
            for (MyFileFilter fileFilter : this.myFileFilters) {
                this.fileChooser.addChoosableFileFilter(fileFilter);
                formatToFileFilterMap.put(fileFilter.getFormat(), fileFilter);
            }
            String lastFilename = (String)PersistentBlackboardPlugIn.get().get(LAST_FILENAME_KEY);
            if (lastFilename != null) {
                this.fileChooser.setSelectedFile(new File(FilenameUtils.removeExtension((String)lastFilename)));
            }
            this.fileChooser.setFileFilter((FileFilter)formatToFileFilterMap.get(PersistentBlackboardPlugIn.get().get(FORMAT_KEY, "png")));
        }
        return this.fileChooser;
    }

    private MyFileFilter createFileFilter(String description, String format, int bufferedmageType) {
        return new MyFileFilter(description, format);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        if (0 != this.getFileChooser().showSaveDialog(context.getWorkbenchFrame())) {
            return false;
        }
        MyFileFilter fileFilter = (MyFileFilter)this.getFileChooser().getFileFilter();
        BufferedImage image = this.image(context.getLayerViewPanel());
        ReferencedEnvelope envelope = new ReferencedEnvelope(context.getLayerViewPanel().getViewport().getEnvelopeInModelCoordinates(), context.getTask().getCRSDefinition().getCRS());
        String file = this.addExtension(this.getFileChooser().getSelectedFile().getPath(), fileFilter.getFormat());
        this.save(image, envelope, new File(file), fileFilter.getFormat());
        PersistentBlackboardPlugIn.get().put(FORMAT_KEY, fileFilter.getFormat());
        PersistentBlackboardPlugIn.get().put(LAST_FILENAME_KEY, file);
        return true;
    }

    private void save(RenderedImage image, ReferencedEnvelope envelope, File file, String format) throws IOException {
        WorldImageWriter writer = new WorldImageWriter((Object)file);
        GridCoverageFactory factory = new GridCoverageFactory();
        GridCoverage2D coverage = factory.create((CharSequence)"GridCoverage", image, (Envelope)envelope);
        writer.write((GridCoverage)coverage, new GeneralParameterValue[]{new Parameter(WorldImageFormat.FORMAT, (Object)format)});
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck();
    }

    private String addExtension(String path, String extension) {
        if (path.toUpperCase().endsWith(extension.toUpperCase())) {
            return path;
        }
        if (path.endsWith(".")) {
            return path + extension;
        }
        return path + "." + extension;
    }

    private static class MyFileFilter
    extends FileFilter {
        private final FileFilter fileFilter;
        private final String format;

        public MyFileFilter(String description, String format) {
            this.fileFilter = GUIUtil.createFileFilter(description, new String[]{format});
            this.format = format;
        }

        @Override
        public boolean accept(File f) {
            return this.fileFilter.accept(f);
        }

        @Override
        public String getDescription() {
            return this.fileFilter.getDescription();
        }

        public String getFormat() {
            return this.format;
        }
    }
}

