/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.LabelLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RemoveSelectedLayersPlugIn
extends AbstractPlugIn {
    @Override
    public boolean execute(PlugInContext context) throws Exception {
        context.getLayerManager().getUndoableEditReceiver().reportIrreversibleChange();
        Collection<Layerable> selectedNodes = context.getLayerNamePanel().selectedNodes(Layerable.class);
        boolean modifiedLayerFound = false;
        boolean labelLayerFound = false;
        for (Layerable selectedLayer : selectedNodes) {
            LabelLayer labelLayer;
            if (!(selectedLayer instanceof Layer)) continue;
            if (((Layer)selectedLayer).isEditable() && ((Layer)selectedLayer).hasEditedFeatures() || selectedLayer instanceof RedlineLayer && ((RedlineLayer)selectedLayer).isMetaDataModified()) {
                modifiedLayerFound = true;
            }
            if ((labelLayer = ((Layer)selectedLayer).getLabelLayer()) == null) continue;
            labelLayerFound = true;
        }
        if (modifiedLayerFound || labelLayerFound) {
            StringBuilder sbMessage = new StringBuilder();
            if (modifiedLayerFound) {
                sbMessage.append(I18N.get("com.vividsolutions.jump.workbench.ui.plugin.RemoveSelectedLayersPlugIn.remove-edited-layer"));
                sbMessage.append("\n");
            }
            if (labelLayerFound) {
                sbMessage.append(I18N.get("com.vividsolutions.jump.workbench.ui.plugin.RemoveSelectedLayersPlugIn.remove-label-layer"));
                sbMessage.append("\n");
            }
            sbMessage.append("\n");
            sbMessage.append(I18N.get("com.vividsolutions.jump.workbench.ui.plugin.RemoveSelectedLayersPlugIn.continue"));
            boolean ret = GUISupport.yesnobox((Component)WorkbenchContext.getFrame(), (String)sbMessage.toString(), (String)this.getName());
            if (!ret) {
                return true;
            }
        }
        RemoveSelectedLayersPlugIn.remove(new ArrayList<Layerable>(selectedNodes));
        return false;
    }

    public static void remove(List<Layerable> selectedLayers) {
        for (Layerable selectedLayer : selectedLayers) {
            if (selectedLayer.isBuildIn() && !(selectedLayer instanceof RedlineLayer)) continue;
            LabelLayer.removeReferenceFromParentLayer(selectedLayer);
            Layer.removeDependentLayer(selectedLayer);
            LayerManager.dispose(selectedLayer);
        }
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        MultiEnableCheck checkLayerable = new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLocalLayerablesMustBeSelectedCheck(1, Layerable.class));
        return component -> {
            String strReturn = checkLayerable.check(component);
            if (strReturn != null) {
                Layer[] ly;
                LayerNamePanel lpnl = WorkbenchContext.getInstance().getLayerNamePanel();
                if (lpnl == null) {
                    return "No map active";
                }
                for (Layer ly1 : ly = lpnl.getSelectedLayers(true)) {
                    if (!(ly1 instanceof RedlineLayer)) continue;
                    return null;
                }
                return strReturn;
            }
            return null;
        };
    }
}

