/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.LabelLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;

public class RemoveSelectedCategoriesPlugIn
extends AbstractPlugIn {
    @Override
    public boolean execute(PlugInContext context) throws Exception {
        context.getLayerManager().getUndoableEditReceiver().reportIrreversibleChange();
        Collection<Category> col = context.getLayerNamePanel().getSelectedCategories(false);
        boolean modifiedLayerFound = false;
        boolean labelLayerFound = false;
        for (Category cat : col) {
            for (Layerable selectedLayer : cat.getAllLayerables()) {
                LabelLayer labelLayer;
                if (!(selectedLayer instanceof Layer)) continue;
                if (((Layer)selectedLayer).isEditable() && ((Layer)selectedLayer).hasEditedFeatures() || selectedLayer instanceof RedlineLayer && ((RedlineLayer)selectedLayer).isMetaDataModified()) {
                    modifiedLayerFound = true;
                }
                if ((labelLayer = ((Layer)selectedLayer).getLabelLayer()) == null) continue;
                labelLayerFound = true;
            }
        }
        if (modifiedLayerFound || labelLayerFound) {
            StringBuilder sbMessage = new StringBuilder();
            if (modifiedLayerFound) {
                sbMessage.append(I18N.get("com.vividsolutions.jump.workbench.ui.plugin.RemoveSelectedLayersPlugIn.remove-edited-layer"));
                sbMessage.append("\n");
            }
            if (labelLayerFound) {
                sbMessage.append(I18N.get("com.vividsolutions.jump.workbench.ui.plugin.RemoveSelectedLayersPlugIn.remove-label-layer"));
                sbMessage.append("\n");
            }
            sbMessage.append("\n");
            sbMessage.append(I18N.get("com.vividsolutions.jump.workbench.ui.plugin.RemoveSelectedLayersPlugIn.continue"));
            boolean ret = GUISupport.yesnobox((Component)WorkbenchContext.getFrame(), (String)sbMessage.toString(), (String)this.getName());
            if (!ret) {
                return true;
            }
        }
        for (Category cat : col) {
            if (cat.isBuildIn()) continue;
            this.removeCategory(cat);
        }
        return true;
    }

    private void removeCategory(Category cat) {
        for (Category sub : cat.getSubcategories()) {
            this.removeCategory(sub);
        }
        ArrayList<Layerable> copiedLayerables = new ArrayList<Layerable>(cat.getLayerables());
        for (Layerable layerable : copiedLayerables) {
            LabelLayer.removeReferenceFromParentLayer(layerable);
            Layer.removeDependentLayer(layerable);
            LayerManager.dispose(layerable);
        }
        cat.setParentCategory(null);
    }

    @Override
    public MultiEnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLocalCategoriesMustBeSelectedCheck(1));
    }
}

