/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelProxy;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.SwingUtilities;

public class ProgressPlugIn
extends AbstractPlugIn {
    private static WorkbenchFrame wframe;
    private static final int progressValue = 0;
    private static long lastRenderingTime;
    private static final List<Object> lstObjTimerStarted;
    private static final Lock startStopLock;

    @Override
    public void initialize(PlugInContext context) throws Exception {
        wframe = context.getWorkbenchFrame();
        GUIUtil.addInternalFrameListener(wframe.getDesktopPane(), GUIUtil.toInternalFrameListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenderingListener rList = ProgressPlugIn.this.installListenerOnCurrentPanel();
                ProgressPlugIn.checkProgressBar(rList);
            }
        }));
    }

    public static void stopProgressBar(Object objStopped) {
        startStopLock.lock();
        try {
            if (objStopped == null || wframe == null) {
                return;
            }
            lstObjTimerStarted.remove(objStopped);
            if (lstObjTimerStarted.isEmpty()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        wframe.deactivateProgressBar();
                    }
                });
                if (lastRenderingTime == -1L) {
                    return;
                }
                lastRenderingTime = -1L;
            }
        }
        finally {
            startStopLock.unlock();
        }
    }

    public static synchronized void startProgressBar(Object objStarted) {
        startStopLock.lock();
        try {
            if (objStarted == null || wframe == null) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    wframe.activateProgressBar();
                }
            });
            if (lastRenderingTime == -1L) {
                lastRenderingTime = System.currentTimeMillis();
            }
            lstObjTimerStarted.add(objStarted);
        }
        finally {
            startStopLock.unlock();
        }
    }

    private static void checkProgressBar(Object objStarted) {
        LayerViewPanel lvp = ProgressPlugIn.layerViewPanel();
        if (lvp == null) {
            return;
        }
        if (lvp.getRenderingManager().isRendering()) {
            ProgressPlugIn.startProgressBar(objStarted);
        } else {
            ProgressPlugIn.stopProgressBar(objStarted);
        }
    }

    private RenderingListener installListenerOnCurrentPanel() {
        String RENDERING_LISTENERS_INSTALLED_KEY = Integer.toHexString(this.hashCode()) + " - RENDERING LISTENERS INSTALLED";
        if (ProgressPlugIn.viewBlackboard().get(RENDERING_LISTENERS_INSTALLED_KEY) != null) {
            return null;
        }
        final LayerViewPanel lvp = ProgressPlugIn.layerViewPanel();
        if (lvp == null) {
            return null;
        }
        RenderingListener rlist = new RenderingListener(){

            @Override
            public void renderingStarted(LayerViewPanel panel) {
                if (panel.equals(lvp)) {
                    ProgressPlugIn.startProgressBar(lvp);
                }
            }

            @Override
            public void renderingStopped(LayerViewPanel panel) {
                if (panel.equals(lvp)) {
                    ProgressPlugIn.stopProgressBar(lvp);
                }
            }
        };
        lvp.getRenderingManager().addRenderingListener(rlist);
        ProgressPlugIn.viewBlackboard().put(RENDERING_LISTENERS_INSTALLED_KEY, rlist);
        return rlist;
    }

    private static Blackboard viewBlackboard() {
        LayerViewPanel lvp = ProgressPlugIn.layerViewPanel();
        return lvp != null ? lvp.getBlackboard() : new Blackboard();
    }

    private static LayerViewPanel layerViewPanel() {
        if (!(wframe.getActiveInternalFrame() instanceof LayerViewPanelProxy)) {
            return null;
        }
        return ((LayerViewPanelProxy)((Object)wframe.getActiveInternalFrame())).getLayerViewPanel();
    }

    static {
        lastRenderingTime = System.currentTimeMillis();
        lstObjTimerStarted = new ArrayList<Object>();
        startStopLock = new ReentrantLock();
    }
}

