/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.security.ArrayTypePermission;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.NullPermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.MaxEntriesMap;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.visibility.model.ModelVisibilityEntity;
import com.vividsolutions.jump.workbench.ui.visibility.model.ModelVisibilityThemingEntity;
import de.riwagis.service.directory.DirectoryService;
import de.riwagis.service.directory.ProjectType;
import de.riwagis.util.xstream.AWTDimensionConverter;
import de.riwagis.util.xstream.AWTPointConverter;
import de.riwagis.util.xstream.GenericFileConverter;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentBlackboardPlugIn
extends AbstractPlugIn {
    private static final Logger LOG = LoggerFactory.getLogger(PersistentBlackboardPlugIn.class);
    private static final String FILENAME = "workbench-state";
    private static final int VERSION_CURRENT = 3;
    private static boolean STATE_RESTORED = false;
    private static final String BLACKBOARD_KEY = PersistentBlackboardPlugIn.class.getName() + " - BLACKBOARD";

    public static synchronized Blackboard get() {
        if (!STATE_RESTORED) {
            PersistentBlackboardPlugIn.restoreState();
            STATE_RESTORED = true;
        }
        return PersistentBlackboardPlugIn.get(WorkbenchContext.getBlackboard());
    }

    private static Blackboard get(Blackboard blackboard) {
        if (blackboard.get(BLACKBOARD_KEY) == null) {
            blackboard.put(BLACKBOARD_KEY, new Blackboard());
        }
        return (Blackboard)blackboard.get(BLACKBOARD_KEY);
    }

    private static File getConfigurationFileForVersion(int version) {
        File jumpDir = new File(DirectoryService.getInstance().getApplicationDataDirectory(), ProjectType.JUMP.getDirectoryName());
        if (version == 0) {
            return new File(jumpDir, "workbench-state.xml");
        }
        return new File(jumpDir, "workbench-state-v" + version + ".xml");
    }

    private static File getTemporaryConfigurationFileForVersion(int version2open) {
        File jumpDir = new File(DirectoryService.getInstance().getApplicationDataDirectory(), ProjectType.JUMP.getDirectoryName());
        if (version2open == 0) {
            return new File(jumpDir, "workbench-state.xml.tmp");
        }
        return new File(jumpDir, "workbench-state-v" + version2open + ".xml.tmp");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        context.getWorkbenchFrame().addComponentListener(new ComponentAdapter(this){

            @Override
            public void componentHidden(ComponentEvent e) {
                PersistentBlackboardPlugIn.saveState();
            }
        });
    }

    private static void restoreState() {
        File configFile = null;
        try {
            Pair<File, Integer> configFileAndVersion = PersistentBlackboardPlugIn.getConfigurationFileAndVersion();
            if (configFileAndVersion == null) {
                LOG.info("There is no configuration file");
                return;
            }
            configFile = (File)configFileAndVersion.getKey();
            Integer configVersion = (Integer)configFileAndVersion.getValue();
            try (FileInputStream in = new FileInputStream(configFile);
                 InputStreamReader fileReader = new InputStreamReader((InputStream)in, PersistentBlackboardPlugIn.getCharsetForVersion(configVersion));
                 BufferedReader bufferedReader = new BufferedReader(fileReader);){
                XStream xstream = PersistentBlackboardPlugIn.createSecuredXStream();
                PersistentBlackboardPlugIn.get(WorkbenchContext.getBlackboard()).putAll(((Blackboard)xstream.fromXML((Reader)bufferedReader)).getProperties());
            }
        }
        catch (Exception e) {
            File backupConfigFile = PersistentBlackboardPlugIn.backupConfigurationFile(configFile);
            StringBuilder sb = new StringBuilder();
            sb.append("Error reading user settings.");
            if (backupConfigFile != null) {
                sb.append(" ");
                sb.append("Backup of configuration file created: ");
                sb.append(backupConfigFile.getName());
            }
            LOG.error(sb.toString(), (Throwable)e);
        }
    }

    private static File backupConfigurationFile(File configFile) {
        if (configFile == null || configFile.isDirectory()) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String configFileAbsolutePath = configFile.getAbsolutePath();
        String configFileName = FilenameUtils.getBaseName((String)configFileAbsolutePath);
        String configFileExtension = FilenameUtils.getExtension((String)configFileAbsolutePath);
        String backupFileName = dateFormat.format(new Date()) + "-" + configFileName + "." + configFileExtension;
        File backupFile = new File(FilenameUtils.getFullPath((String)configFileAbsolutePath), backupFileName);
        try {
            FileUtils.copyFile((File)configFile, (File)backupFile);
        }
        catch (IOException ex) {
            LOG.error("Error creating backup of configuration file.", (Throwable)ex);
            return null;
        }
        return backupFile;
    }

    private static XStream createSecuredXStream() {
        XStream xstream = new XStream();
        xstream.addPermission(NoTypePermission.NONE);
        xstream.addPermission(NullPermission.NULL);
        xstream.addPermission(PrimitiveTypePermission.PRIMITIVES);
        xstream.addPermission(ArrayTypePermission.ARRAYS);
        xstream.allowTypeHierarchy(Collection.class);
        xstream.allowTypeHierarchy(Map.class);
        xstream.allowTypeHierarchy(File.class);
        xstream.allowTypes(new Class[]{Object.class, String.class, Blackboard.class, Dimension.class, Point.class, MaxEntriesMap.class, ModelVisibilityEntity.class, ModelVisibilityThemingEntity.class});
        xstream.registerConverter((Converter)new AWTPointConverter());
        xstream.registerConverter((Converter)new AWTDimensionConverter());
        xstream.registerConverter((SingleValueConverter)new GenericFileConverter());
        xstream.processAnnotations(ModelVisibilityEntity.class);
        xstream.processAnnotations(ModelVisibilityThemingEntity.class);
        return xstream;
    }

    public static File getConfigurationFile() {
        Pair<File, Integer> configurationFileAndVersion = PersistentBlackboardPlugIn.getConfigurationFileAndVersion();
        if (configurationFileAndVersion == null) {
            return null;
        }
        return (File)configurationFileAndVersion.getKey();
    }

    private static Pair<File, Integer> getConfigurationFileAndVersion() {
        for (int version = 3; version >= 0; --version) {
            File filePath = PersistentBlackboardPlugIn.getConfigurationFileForVersion(version);
            if (!filePath.exists()) continue;
            return Pair.of((Object)filePath, (Object)version);
        }
        return null;
    }

    private static Charset getCharsetForVersion(int version) {
        if (version == 0) {
            return StandardCharsets.ISO_8859_1;
        }
        return StandardCharsets.UTF_8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveState() {
        try {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.APP_SUDDEN_TERMINATION)) {
                Desktop.getDesktop().disableSuddenTermination();
            }
            File tempFile = PersistentBlackboardPlugIn.getTemporaryConfigurationFileForVersion(3);
            try (FileOutputStream out = new FileOutputStream(tempFile, false);
                 OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
                 BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
                XStream xstream = PersistentBlackboardPlugIn.createSecuredXStream();
                xstream.marshal((Object)PersistentBlackboardPlugIn.get(), (HierarchicalStreamWriter)new CompactWriter((Writer)bufferedWriter));
                bufferedWriter.flush();
                fileWriter.flush();
            }
            File blackboardFile = PersistentBlackboardPlugIn.getConfigurationFileForVersion(3);
            Files.deleteIfExists(blackboardFile.toPath());
            tempFile.renameTo(blackboardFile);
            for (int i = 1; i >= 0; --i) {
                Files.deleteIfExists(PersistentBlackboardPlugIn.getConfigurationFileForVersion(i).toPath());
            }
        }
        catch (Exception e) {
            LOG.error("Error writing user settings.", (Throwable)e);
        }
        finally {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.APP_SUDDEN_TERMINATION)) {
                Desktop.getDesktop().enableSuddenTermination();
            }
        }
    }
}

