/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.workbench.ui.components.menutree.AnimatedWidthTree;
import com.vividsolutions.jump.workbench.ui.components.menutree.JMenuBarTreeModel;
import com.vividsolutions.jump.workbench.ui.components.menutree.MenuElementTreeCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ModulePanel
extends JPanel {
    private static ModulePanel modulePanel = null;
    private final JMenuBar menuBar = new JMenuBar();
    private AnimatedWidthTree menuTree = null;
    private TreeModel menuTreeModel = new JMenuBarTreeModel(new JMenuBar());
    private int lastSelected;
    private JScrollPane sp = null;

    private ModulePanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.menuTree = new AnimatedWidthTree(this, false, null, null, 5);
        this.menuTree.setOpaque(false);
        this.menuTree.setRootVisible(false);
        this.menuTree.setShowsRootHandles(false);
        this.menuTree.setCellRenderer(new MenuElementTreeCellRenderer());
        this.menuTree.addTreeExpansionListener(new TreeExpansionListener(){
            boolean blockEvents = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                if (this.blockEvents) {
                    return;
                }
                this.blockEvents = true;
                try {
                    TreePath pp = event.getPath().getParentPath();
                    Object node = pp.getLastPathComponent();
                    int n = ModulePanel.this.menuTree.getModel().getChildCount(node);
                    for (int index = 0; index < n; ++index) {
                        Object child = ModulePanel.this.menuTree.getModel().getChild(node, index);
                        if (ModulePanel.this.menuTree.getModel().isLeaf(child)) continue;
                        TreePath cp = pp.pathByAddingChild(child);
                        ModulePanel.this.menuTree.collapsePath(cp);
                    }
                    ModulePanel.this.menuTree.expandPath(event.getPath());
                }
                finally {
                    this.blockEvents = false;
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this.menuTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                ModulePanel.this.menuTree.clearSelection();
                ModulePanel.this.lastSelected = -1;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ModulePanel.this.selectByMouseEvent(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath tp = ModulePanel.this.menuTree.getSelectionPath();
                if (tp != null && tp.getLastPathComponent() != null && tp.getLastPathComponent() instanceof JMenuItem) {
                    ActionListener[] arrMenuListeners;
                    ActionEvent ae = new ActionEvent(this, 1, "Menu clicked");
                    for (ActionListener al : arrMenuListeners = ((JMenuItem)tp.getLastPathComponent()).getActionListeners()) {
                        al.actionPerformed(ae);
                    }
                }
            }
        });
        this.menuTree.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                ModulePanel.this.selectByMouseEvent(e);
            }
        });
        this.sp = new JScrollPane(this.menuTree);
        this.sp.setBackground(this.getBackground());
        this.sp.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.add(this.sp);
    }

    private void selectByMouseEvent(MouseEvent e) {
        int selRow = this.menuTree.getRowForLocation(e.getX(), e.getY());
        if (selRow == -1) {
            this.menuTree.clearSelection();
            this.lastSelected = -1;
        } else if (selRow != this.lastSelected) {
            this.menuTree.setSelectionRow(selRow);
            this.lastSelected = selRow;
        }
    }

    public static ModulePanel instanceOf() {
        if (modulePanel == null) {
            modulePanel = new ModulePanel();
        }
        return modulePanel;
    }

    @Override
    public void removeAll() {
        this.menuBar.removeAll();
    }

    private void addMenuComponent(Component menu) {
        this.menuBar.add(menu);
    }

    public void addMenuComponents(Component[] components) {
        for (Component currMenuComp : components) {
            this.addMenuComponent(currMenuComp);
            currMenuComp.addPropertyChangeListener("icon", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ModulePanel.this.menuTree.validate();
                    ModulePanel.this.menuTree.repaint();
                }
            });
        }
    }

    public void addSeparator() {
        JSeparator sep = new JSeparator();
        this.menuBar.add(sep);
    }

    public int getMenuCount() {
        return this.menuBar.getMenuCount();
    }

    public JMenu getMenu(int k) {
        return this.menuBar.getMenu(k);
    }

    public void activate() {
        this.menuTreeModel = new JMenuBarTreeModel(this.menuBar);
        this.menuTree.setModel(this.menuTreeModel);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }
}

