/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.CollectionMap;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.plugin.MeasureFeaturesDialog;
import de.riwagis.icons.IconLoader;
import java.util.Collection;
import javax.swing.ImageIcon;
import org.opengis.feature.simple.SimpleFeature;

public class MeasureSelectedFeaturesPlugIn
extends AbstractPlugIn {
    MeasureFeaturesDialog dlg = null;

    @Override
    public String getName() {
        return I18N.get("ui.plugin.MeasureSelectedFeaturesPlugIn.name");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"common_measure_object.svg");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        if (this.dlg == null) {
            this.dlg = new MeasureFeaturesDialog(context.getWorkbenchFrame());
        }
        this.dlg.setDrawingUnit(context.getTask().getDrawingUnit());
        this.dlg.displayHints(context.getTask().isProjectionReductionActive());
        this.dlg.setVisible(false);
        Collection<Layer> colLy = context.getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems();
        CollectionMap<Layer, SimpleFeature> mapLyFeat = new CollectionMap<Layer, SimpleFeature>();
        for (Layer ly : colLy) {
            mapLyFeat.addItems(ly, context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(ly));
        }
        this.dlg.setLayerFeatureMap(mapLyFeat);
        GUIUtil.centreOnScreen(this.dlg);
        this.dlg.setVisible(true);
        return true;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createAtLeastNFeaturesMustHaveSelectedItemsCheck(1));
    }
}

