/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.CollectionMap;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerableComparator;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.label.DrawLabelTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.label.EditLabelPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.label.EditLabelPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import de.riwagis.gis.context.map.MapContext;
import de.riwagis.riwajump.reduction.ProjectionReduction;
import de.riwagis.unit.DrawingUnit;
import de.riwagis.unit.UnitFactory;
import de.riwagis.util.gui.treetable.TreeTable;
import de.riwagis.util.gui.treetable.TreeTableNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;

public class MeasureFeaturesDialog
extends JDialog {
    private static final String KEY_UNIT = "MeasureFeaturesDialog_Unit";
    private static final String KEY_DECIMAL_PLACES = "MeasureFeaturesDialog_DecPlaces";
    private final TreeTable ttLF = new TreeTable(false);
    private CollectionMap<Layer, SimpleFeature> mapLyFeat = null;
    private static final String POINT = I18N.get("common.point");
    private static final String LINE = I18N.get("common.line");
    private static final String POLYGON = I18N.get("common.polygon");
    private static final String GEOMETRY = I18N.get("common.geometry");
    private final DecimalFormat dfArea = new DecimalFormat();
    private final DecimalFormat dfLength = new DecimalFormat();
    private DrawingUnit dUnit = null;
    private double dblAreaSum = 0.0;
    private double dblLengthSum = 0.0;
    private double dblLyAreaSum = 0.0;
    private double dblLyLengthSum = 0.0;
    private boolean bolBlockEvent = false;
    private JButton butClose;
    private JComboBox<Integer> cmbDeci;
    private JComboBox<DrawingUnit> cmbUnit;
    private JLabel lblDeci;
    private JLabel lblHints;
    private JLabel lblInfo;
    private JLabel lblUnit;
    private JPanel pnlClose;
    private JPanel pnlTreeTable;
    private JPanel pnlUnit;

    public MeasureFeaturesDialog(Frame parent) {
        super(parent, false);
        this.initComponents();
        this.init();
        this.i18n();
        this.setFocusableWindowState(true);
    }

    private void i18n() {
        this.setTitle(I18N.get("ui.plugin.MeasureFeaturesDialog.title"));
        this.ttLF.addHeader(I18N.get("ui.plugin.MeasureFeaturesDialog.sum-layer-feature"), 200);
        this.ttLF.addHeader(I18N.get("ui.plugin.MeasureFeaturesDialog.geom-type"), 60);
        this.ttLF.addHeader(I18N.get("ui.plugin.MeasureFeaturesDialog.area"), 60);
        this.ttLF.addHeader(I18N.get("ui.plugin.MeasureFeaturesDialog.length"), 80);
        this.lblUnit.setText(I18N.get("ui.plugin.MeasureFeaturesDialog.unit"));
        this.lblDeci.setText(I18N.get("ui.plugin.MeasureFeaturesDialog.decimal-places"));
        this.lblInfo.setText(I18N.get("ui.plugin.MeasureFeaturesDialog.info"));
        this.lblHints.setText(I18N.get("ui.plugin.MeasureFeaturesDialog.hints"));
        this.butClose.setText(I18N.get("common.close"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        this.bolBlockEvent = true;
        try {
            int i;
            DrawingUnit unit2;
            this.setSize(400, 400);
            this.pnlTreeTable.add((Component)this.ttLF, "Center");
            this.ttLF.setRowHeight(this.ttLF.getTable().getRowHeight());
            int intDecPlaces = PersistentBlackboardPlugIn.get().get(KEY_DECIMAL_PLACES, 2);
            this.dfArea.setMaximumFractionDigits(intDecPlaces);
            this.dfArea.setGroupingUsed(false);
            this.dfLength.setMaximumFractionDigits(intDecPlaces);
            this.dfLength.setGroupingUsed(false);
            List lstUnit = UnitFactory.getUnitList();
            for (DrawingUnit unit2 : lstUnit) {
                this.cmbUnit.addItem(unit2);
            }
            String strUnit = PersistentBlackboardPlugIn.get().get(KEY_UNIT, "meter");
            unit2 = UnitFactory.getUnit((String)strUnit);
            this.cmbUnit.setSelectedItem(unit2);
            for (i = 0; i < 8; ++i) {
                this.cmbDeci.addItem(i);
            }
            for (i = 0; i < 8; ++i) {
                Integer intCandidate = this.cmbDeci.getItemAt(i);
                if (intCandidate != intDecPlaces) continue;
                this.cmbDeci.setSelectedIndex(i);
                break;
            }
            this.ttLF.addTableMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() == 3) {
                        java.awt.Point p = e.getPoint();
                        JTable table = MeasureFeaturesDialog.this.ttLF.getTable();
                        int row = table.rowAtPoint(p);
                        int col = table.columnAtPoint(p);
                        table.changeSelection(row, col, false, false);
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    TreeTableNode selNode = MeasureFeaturesDialog.this.ttLF.getSelectedNode();
                    Object obj = selNode.getUserData();
                    if (obj == null) {
                        return;
                    }
                    if (obj instanceof Object[]) {
                        Layer ly = (Layer)((Object[])obj)[0];
                        SimpleFeature feat = (SimpleFeature)((Object[])obj)[1];
                        MapContext mCtxt = ly.getLayerManager().getMapContext();
                        Geometry geom = (Geometry)feat.getDefaultGeometry();
                        TaskFrame frmTask = JUMPWorkbench.getFrame().getTaskFrameByTask(ly.getLayerManager().getTask());
                        frmTask.getLayerViewPanel().flash(geom.getFactory().createGeometryCollection(new Geometry[]{geom}));
                        Runnable doSelect = () -> {
                            frmTask.getLayerViewPanel().getSelectionManager().clear();
                            frmTask.getLayerViewPanel().getSelectionManager().getFeatureSelection().selectItems(ly, feat);
                        };
                        if (e.getClickCount() > 1) {
                            Envelope env = geom.getEnvelopeInternal();
                            try {
                                mCtxt.zoomEnvelope(env, 500.0, doSelect);
                            }
                            catch (Exception ex) {
                                Assert.shouldNeverReachHere();
                            }
                        }
                    }
                }
            });
            JMenuItem menuItem = new JMenuItem(I18N.get("ui.plugin.MeasureSelectedFeaturesPlugIn.copy-all"));
            menuItem.addActionListener(e -> {
                StringBuilder sbClipboard = new StringBuilder();
                try {
                    int intColCount = this.ttLF.getTable().getColumnCount();
                    int intRowCount = this.ttLF.getTable().getRowCount();
                    for (int i = 0; i < intColCount; ++i) {
                        if (i != 0) {
                            sbClipboard.append("\t");
                        }
                        sbClipboard.append(this.ttLF.getTable().getColumnName(i));
                    }
                    for (int j = 0; j < intRowCount; ++j) {
                        sbClipboard.append("\n");
                        for (int i = 0; i < intColCount; ++i) {
                            if (i != 0) {
                                sbClipboard.append("\t");
                            }
                            sbClipboard.append(StringUtils.normalizeSpace((String)this.ttLF.getTable().getValueAt(j, i).toString()));
                        }
                    }
                    StringSelection stringSelection = new StringSelection(sbClipboard.toString());
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(stringSelection, (aClipboard, aContents) -> {});
                }
                catch (Exception e2) {
                    return;
                }
            });
            this.ttLF.addPopupMenuItem(menuItem);
            this.ttLF.addPopupMenuSeparator();
            menuItem = new JMenuItem(I18N.get("ui.plugin.MeasureSelectedFeaturesPlugIn.insert-text"));
            menuItem.addActionListener(e -> {
                Object objValue = null;
                DrawingUnit unit1 = (DrawingUnit)this.cmbUnit.getSelectedItem();
                int intCol = this.ttLF.getTable().getSelectedColumn();
                try {
                    objValue = this.ttLF.getTable().getValueAt(this.ttLF.getTable().getSelectedRow(), intCol);
                }
                catch (Exception esel) {
                    return;
                }
                if (objValue != null) {
                    Object strText = objValue.toString();
                    if (intCol == 2) {
                        strText = (String)strText + unit1.getUnitAbbreviation() + "\u00b2";
                    }
                    if (intCol == 3) {
                        strText = (String)strText + unit1.getUnitAbbreviation();
                    }
                    EditLabelPanel.instanceOf().setText((String)strText);
                    WorkbenchContext.getFrame().getDesktopPanel().setRightTabsVisible(true);
                    if (DrawLabelTool.createEnableCheck().check((JComponent)this.ttLF) == null) {
                        try {
                            JUMPWorkbench.getBuiltInPlugIn(EditLabelPlugIn.class).execute(WorkbenchContext.getInstance().createPlugInContext());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            this.ttLF.addPopupMenuItem(menuItem);
        }
        finally {
            this.bolBlockEvent = false;
        }
    }

    public void setDrawingUnit(DrawingUnit _dUnit) {
        this.dUnit = _dUnit;
    }

    public synchronized void setLayerFeatureMap(CollectionMap<Layer, SimpleFeature> _mapLyFeat) {
        this.mapLyFeat = _mapLyFeat;
        if (this.mapLyFeat == null) {
            TreeTableNode nRoot = new TreeTableNode(I18N.get("common.sum"));
            this.setEmptyCols(nRoot);
            this.ttLF.setRootNode(nRoot);
            return;
        }
        TreeTableNode nRoot = new TreeTableNode(I18N.get("common.sum"));
        nRoot.addColumn((Object)"");
        ArrayList<Layer> lstLy = new ArrayList<Layer>();
        Iterator<Layer> iLy = this.mapLyFeat.keySet().iterator();
        while (iLy.hasNext()) {
            lstLy.add(iLy.next());
        }
        Layer[] arrLy = lstLy.toArray(new Layer[0]);
        LayerableComparator lyComp = new LayerableComparator();
        Arrays.sort(arrLy, lyComp);
        this.dblAreaSum = 0.0;
        this.dblLengthSum = 0.0;
        for (Layer ly : arrLy) {
            this.addLayer(nRoot, ly);
        }
        nRoot.addColumn((Object)this.dfArea.format(this.dblAreaSum));
        nRoot.addColumn((Object)this.dfArea.format(this.dblLengthSum));
        this.ttLF.setRootVisible(true);
        this.ttLF.setRootNode(nRoot);
        this.ttLF.expandAll(true);
    }

    private void setEmptyCols(TreeTableNode n) {
        for (int i = 0; i < this.ttLF.getColumnCount() - 1; ++i) {
            n.addColumn((Object)"");
        }
    }

    private void addLayer(TreeTableNode n, Layer ly) {
        TreeTableNode nLy = new TreeTableNode(ly.getName(), (Object)ly);
        nLy.addColumn((Object)"");
        n.addChild(nLy);
        n.recalcChildren();
        Iterator<SimpleFeature> iFeat = this.mapLyFeat.getItems(ly).iterator();
        this.dblLyAreaSum = 0.0;
        this.dblLyLengthSum = 0.0;
        while (iFeat.hasNext()) {
            this.addFeature(nLy, ly, iFeat.next());
        }
        nLy.addColumn((Object)this.dfArea.format(this.dblLyAreaSum));
        nLy.addColumn((Object)this.dfArea.format(this.dblLyLengthSum));
    }

    private void addFeature(TreeTableNode n, Layer ly, SimpleFeature feat) {
        if (feat.getDefaultGeometry() == null || ((Geometry)feat.getDefaultGeometry()).isEmpty()) {
            return;
        }
        TreeTableNode nFeat = new TreeTableNode(feat.getID(), (Object)new Object[]{ly, feat});
        nFeat.addColumn((Object)this.getGeomTypeText((Geometry)feat.getDefaultGeometry()));
        double dblLengthFactor = 1.0;
        double dblAreaFactor = 1.0;
        if (this.dUnit != null && this.cmbUnit.getItemCount() > 0) {
            DrawingUnit dlgUnit = (DrawingUnit)this.cmbUnit.getSelectedItem();
            dblLengthFactor = this.dUnit.getUnitInMeter() / dlgUnit.getUnitInMeter();
            dblAreaFactor = dblLengthFactor * dblLengthFactor;
        }
        Geometry geom = (Geometry)feat.getDefaultGeometry();
        ProjectionReduction projectionReduction = ProjectionReduction.getInstance();
        double tmpArea = projectionReduction.calculateRealWorldArea(geom);
        double tmpLength = projectionReduction.calculateRealWorldLength(geom);
        double dblArea = tmpArea * dblAreaFactor;
        double dblLength = tmpLength * dblLengthFactor;
        this.dblAreaSum += dblArea;
        this.dblLengthSum += dblLength;
        this.dblLyAreaSum += dblArea;
        this.dblLyLengthSum += dblLength;
        nFeat.addColumn((Object)this.dfArea.format(dblArea));
        nFeat.addColumn((Object)this.dfLength.format(dblLength));
        n.addChild(nFeat);
        n.recalcChildren();
    }

    private String getGeomTypeText(Geometry geom) {
        if (geom instanceof Point || geom instanceof MultiPoint) {
            return POINT;
        }
        if (geom instanceof LineString || geom instanceof MultiLineString) {
            return LINE;
        }
        if (geom instanceof Polygon || geom instanceof MultiPolygon) {
            return POLYGON;
        }
        return GEOMETRY;
    }

    private void initComponents() {
        this.pnlTreeTable = new JPanel();
        this.pnlClose = new JPanel();
        this.butClose = new JButton();
        this.pnlUnit = new JPanel();
        this.lblUnit = new JLabel();
        this.cmbUnit = new JComboBox();
        this.lblDeci = new JLabel();
        this.cmbDeci = new JComboBox();
        this.lblHints = new JLabel();
        this.lblInfo = new JLabel();
        this.setMinimumSize(new Dimension(249, 108));
        this.setPreferredSize(new Dimension(300, 108));
        this.getContentPane().setLayout(new GridBagLayout());
        this.pnlTreeTable.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.pnlTreeTable, gridBagConstraints);
        this.butClose.setText("schlie\u00dfen");
        this.butClose.setPreferredSize(new Dimension(100, 23));
        this.butClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MeasureFeaturesDialog.this.butClose_onActionPerformed(evt);
            }
        });
        this.pnlClose.add(this.butClose);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.pnlClose, gridBagConstraints);
        this.pnlUnit.setLayout(new GridBagLayout());
        this.lblUnit.setText("Einheit:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(9, 9, 9, 3);
        this.pnlUnit.add((Component)this.lblUnit, gridBagConstraints);
        this.cmbUnit.setPreferredSize(new Dimension(80, 22));
        this.cmbUnit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MeasureFeaturesDialog.this.cmbUnit_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(9, 3, 9, 3);
        this.pnlUnit.add(this.cmbUnit, gridBagConstraints);
        this.lblDeci.setText("Dezimalstellen:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(9, 9, 9, 3);
        this.pnlUnit.add((Component)this.lblDeci, gridBagConstraints);
        this.cmbDeci.setMinimumSize(new Dimension(70, 20));
        this.cmbDeci.setPreferredSize(new Dimension(70, 22));
        this.cmbDeci.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MeasureFeaturesDialog.this.cmbDeci_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(9, 3, 9, 3);
        this.pnlUnit.add(this.cmbDeci, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.pnlUnit, gridBagConstraints);
        this.lblHints.setText("Wichtige Hinweise");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.getContentPane().add((Component)this.lblHints, gridBagConstraints);
        this.lblInfo.setText("<html><font size=\"4\">&#9432; </font>Information</html>");
        this.lblInfo.setToolTipText("");
        this.lblInfo.setMaximumSize(null);
        this.lblInfo.setMinimumSize(null);
        this.lblInfo.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.getContentPane().add((Component)this.lblInfo, gridBagConstraints);
        this.lblInfo.getAccessibleContext().setAccessibleName("Information");
        this.lblInfo.getAccessibleContext().setAccessibleParent(this);
        this.pack();
    }

    private void cmbUnit_onActionPerformed(ActionEvent evt) {
        if (this.bolBlockEvent) {
            return;
        }
        DrawingUnit unit = (DrawingUnit)this.cmbUnit.getSelectedItem();
        PersistentBlackboardPlugIn.get().put(KEY_UNIT, UnitFactory.getKey((DrawingUnit)unit));
        this.setLayerFeatureMap(this.mapLyFeat);
    }

    private void cmbDeci_onActionPerformed(ActionEvent evt) {
        if (this.bolBlockEvent) {
            return;
        }
        int intDecPlaces = (Integer)this.cmbDeci.getSelectedItem();
        this.dfLength.setMaximumFractionDigits(intDecPlaces);
        this.dfArea.setMaximumFractionDigits(intDecPlaces);
        PersistentBlackboardPlugIn.get().put(KEY_DECIMAL_PLACES, intDecPlaces);
        this.setLayerFeatureMap(this.mapLyFeat);
    }

    private void butClose_onActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    protected void displayHints(boolean value) {
        this.lblHints.setVisible(value);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(() -> new MeasureFeaturesDialog(new JFrame()).setVisible(true));
    }
}

