/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class KeyIndicatorPlugIn
extends AbstractPlugIn {
    private static final ReadWriteLock rwlock = new ReentrantReadWriteLock();
    private static final Set<Integer> KEYS_DOWN = new HashSet<Integer>();

    public static boolean isKeyDown(int keyCode) {
        rwlock.readLock().lock();
        try {
            boolean bl = KEYS_DOWN.contains(keyCode);
            return bl;
        }
        finally {
            rwlock.readLock().unlock();
        }
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        WorkbenchFrame wbFrm = context.getWorkbenchFrame();
        wbFrm.addEasyKeyListener(new KeyListener(this){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                int keycode = e.getKeyCode();
                rwlock.writeLock().lock();
                try {
                    KEYS_DOWN.add(keycode);
                }
                finally {
                    rwlock.writeLock().unlock();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                int keycode = e.getKeyCode();
                rwlock.writeLock().lock();
                try {
                    KEYS_DOWN.remove(keycode);
                }
                finally {
                    rwlock.writeLock().unlock();
                }
            }
        });
    }
}

