/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.io.FUTURE_JTS_WKTWriter;
import com.vividsolutions.jump.util.Fmt;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.AbstractFeatureTextWriter;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;

public class InstallStandardFeatureTextWritersPlugIn
extends AbstractPlugIn {
    private static final AbstractFeatureTextWriter COORDINATE_WRITER = new AbstractFeatureTextWriter(false, "CL", "Coordinate List"){

        @Override
        public String write(SimpleFeature feature) {
            StringBuilder s = new StringBuilder();
            String className = StringUtil.classNameWithoutQualifiers(feature.getDefaultGeometry().getClass().getName());
            s.append(className).append("\n");
            Coordinate[] coordinates = ((Geometry)feature.getDefaultGeometry()).getCoordinates();
            for (int i = 0; i < coordinates.length; ++i) {
                s.append("[").append(Fmt.fmt(i, 10)).append("] ");
                s.append(coordinates[i].x).append(", ").append(coordinates[i].y).append("\n");
            }
            return s.toString().trim();
        }
    };
    private static final AbstractFeatureTextWriter WKT_WRITER = new AbstractFeatureTextWriter(true, "WKT", "Well-Known Text"){
        private final FUTURE_JTS_WKTWriter wktWriter = new FUTURE_JTS_WKTWriter();

        @Override
        public String write(SimpleFeature feature) {
            return this.wktWriter.write((Geometry)feature.getDefaultGeometry()).trim();
        }
    };

    @Override
    public void initialize(PlugInContext context) throws Exception {
        context.getWorkbenchContext().getFeatureTextWriterRegistry().register(WKT_WRITER);
        context.getWorkbenchContext().getFeatureTextWriterRegistry().register(COORDINATE_WRITER);
    }
}

