/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.plugin.ModulePanel;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.workbench.ShowDigiTabsPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.workbench.ShowNavigationTabsPlugIn;
import com.vividsolutions.jump.workbench.ui.visibility.VisibilityPanel;
import com.vividsolutions.jump.workbench.ui.zoom.NavigationPanel;
import com.vividsolutions.jump.workbench.ui.zoom.OverviewPanel;
import javax.swing.JInternalFrame;
import javax.swing.JTabbedPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class InitDesktopPanelPlugIn
extends AbstractPlugIn {
    @Override
    public void initialize(PlugInContext context) throws Exception {
        JTabbedPane tabbedPane = context.getWorkbenchFrame().getDesktopPanel().getLeftTabbedPane();
        if (JUMPWorkbench.GIS_CONTEXT != null) {
            tabbedPane.add(I18N.get("ui.DesktopPanel.modules"), ModulePanel.instanceOf());
        }
        tabbedPane.add(I18N.get("ui.zoom.ZoomTool.NavigationPanel.title"), new NavigationPanel());
        tabbedPane.add(I18N.get("ui.zoom.VisibilityPanel.title"), VisibilityPanel.instanceOf());
        tabbedPane = context.getWorkbenchFrame().getDesktopPanel().getRightTabbedPane();
        tabbedPane.add(I18N.get("ui.cursortool.editing.EditingPanel.title"), EditingPanel.instanceOf());
        final OverviewPanel pnlOverview = context.getWorkbenchFrame().getDesktopPanel().getOverviewPanel();
        GUIUtil.addInternalFrameListener(WorkbenchContext.getFrame().getDesktopPane(), new InternalFrameAdapter(this){

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
                JInternalFrame frm = e.getInternalFrame();
                if (frm instanceof TaskFrame) {
                    try {
                        TaskFrame frmTask = (TaskFrame)frm;
                        pnlOverview.initWithTaskFrame(frmTask);
                        pnlOverview.reloadOverview();
                    }
                    catch (Exception exp) {
                        pnlOverview.hideOverview();
                    }
                }
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent e) {
                TaskFrame frmTask;
                JInternalFrame frm = e.getInternalFrame();
                if (frm instanceof TaskFrame && (frmTask = (TaskFrame)frm).getTask() == pnlOverview.getTask()) {
                    pnlOverview.hideOverview();
                }
            }
        });
        Blackboard pBB = PersistentBlackboardPlugIn.get();
        boolean bolShowDigi = pBB.get(ShowDigiTabsPlugIn.BB_KEY, true);
        boolean bolShowNav = pBB.get(ShowNavigationTabsPlugIn.BB_KEY, true);
        context.getWorkbenchFrame().getDesktopPanel().setLeftTabsVisible(bolShowNav);
        context.getWorkbenchFrame().getDesktopPanel().setRightTabsVisible(bolShowDigi);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        return true;
    }
}

