/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.HtmlBuilder;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.components.HTMLDialog;
import com.vividsolutions.jump.workbench.ui.components.HTMLPanel;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.Window;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class GenerateLogPlugIn
extends AbstractPlugIn {
    public static final int MAX_LOG_ENTRIES = 2000;
    private final LogPluginAppender wapp = new LogPluginAppender();
    private static final PatternLayout LogPluginLayout = PatternLayout.newBuilder().withPattern("<li title='Klasse: %c'><b>%-5p - %d{ISO8601}:&nbsp;</b>%m</li>").build();
    private HTMLDialog htmlDialog;

    @Override
    public String getName() {
        return I18N.get("ui.plugin.GenerateLogPlugIn.log");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        LoggerContext loggerContext = LoggerContext.getContext((boolean)false);
        Configuration config = loggerContext.getConfiguration();
        this.wapp.start();
        config.addAppender((Appender)this.wapp);
        Level level = Level.INFO;
        Filter filter = null;
        for (LoggerConfig loggerConfig : config.getLoggers().values()) {
            loggerConfig.addAppender((Appender)this.wapp, level, filter);
        }
        config.getRootLogger().addAppender((Appender)this.wapp, level, filter);
        this.wapp.clear();
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Runnable run = () -> {
            if (this.htmlDialog == null) {
                this.htmlDialog = new HTMLDialog();
                this.htmlDialog.setRecordNavigationControlVisible(false);
            } else {
                this.htmlDialog.removeAllDocuments();
            }
            HtmlBuilder documentEntry = new HtmlBuilder("");
            documentEntry.addHeader(1, I18N.get("ui.plugin.GenerateLogPlugIn.jump-workbench-log"));
            documentEntry.addHeader(2, I18N.get("ui.plugin.GenerateLogPlugIn.generated") + " " + DateFormatUtils.format((Date)new Date(), (String)"dd.MM.yyyy hh:mm:ss"));
            if (this.wapp != null) {
                String eventMessages = this.wapp.getEventTexts().stream().filter(StringUtils::isNotBlank).collect(Collectors.joining("\n"));
                documentEntry.addBlockElement("p", HTMLPanel.NO_ATTRIBUTES, I18N.getMessage("ui.plugin.GenerateLogPlugIn.amountOfLogEvents", this.wapp.getEventTexts().size()));
                documentEntry.append("<ul style='max-width:95%%; font-family:monospace;'>");
                documentEntry.append(eventMessages);
                documentEntry.append("</ul>");
            }
            this.htmlDialog.addDocument(new HTMLPanel.Record(documentEntry.build(), null));
            this.htmlDialog.setVisible(true);
        };
        WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)context.getWorkbenchFrame(), (String)I18N.get("common.wait"));
        dlgWait.addWorkToDo(run);
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            throw dlgWait.getError();
        }
        return true;
    }

    private static class LogPluginAppender
    extends AbstractAppender {
        private final List<String> eventTexts = new LinkedList<String>();
        private final Date clearTimestamp = new Date();

        public LogPluginAppender() {
            super("LogPluginAppender", null, (Layout)LogPluginLayout);
        }

        public void append(LogEvent event) {
            this.eventTexts.add(Objects.toString(LogPluginLayout.toSerializable(event)));
            while (this.eventTexts.size() > 2000) {
                this.eventTexts.remove(0);
            }
        }

        public Collection<String> getEventTexts() {
            return this.eventTexts;
        }

        public void clear() {
            this.clearTimestamp.setTime(System.currentTimeMillis());
            this.eventTexts.clear();
        }

        public Date getClearTimestamp() {
            return new Date(this.clearTimestamp.getTime());
        }
    }
}

