/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.plugin.MenuItemShownListener;
import com.vividsolutions.jump.workbench.ui.task.TaskMonitorManager;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.locationtech.jts.util.Assert;

public class FeatureInstaller {
    private final WorkbenchContext workbenchContext;
    private final TaskMonitorManager taskMonitorManager = new TaskMonitorManager();
    private final EnableCheckFactory checkFactory;

    public FeatureInstaller(WorkbenchContext workbenchContext) {
        this.workbenchContext = workbenchContext;
        this.checkFactory = new EnableCheckFactory(workbenchContext);
    }

    public void addMenuSeparator(String menu) {
        this.addMenuSeparator(new String[]{menu});
    }

    public void addMenuSeparator(String[] menuPath) {
        JMenu mainMenu = this.menuBarMenu(menuPath[0]);
        this.addMenuSeparator(this.createMenusIfNecessary(mainMenu, this.behead(menuPath)));
    }

    public void addMenuSeparator(JMenu menu) {
        Component separator = null;
        Component exitMenu = null;
        if (menu.getText().equals(MenuNames.FILE)) {
            separator = menu.getMenuComponent(menu.getMenuComponentCount() - 2);
            exitMenu = menu.getMenuComponent(menu.getMenuComponentCount() - 1);
            menu.remove(separator);
            menu.remove(exitMenu);
        }
        menu.addSeparator();
        if (menu.getText().equals(MenuNames.FILE)) {
            menu.add(separator);
            menu.add(exitMenu);
        }
    }

    private void associate(JMenuItem menuItem, PlugIn plugIn) {
        menuItem.addActionListener(AbstractPlugIn.toActionListener(plugIn, this.workbenchContext, this.taskMonitorManager));
    }

    public String[] behead(String[] a1) {
        String[] a2 = new String[a1.length - 1];
        System.arraycopy(a1, 1, a2, 0, a2.length);
        return a2;
    }

    public JMenuItem addMainMenuItem(PlugIn executable, String menuName, String menuItemName, Icon icon, EnableCheck enableCheck) {
        return this.addMainMenuItem(executable, new String[]{menuName}, menuItemName, false, icon, enableCheck);
    }

    public void addLayerViewMenuItem(PlugIn executable, String menuName, String menuItemName) {
        this.addLayerViewMenuItem(executable, new String[]{menuName}, menuItemName);
    }

    public void addLayerNameViewMenuItem(PlugIn executable, String menuName, String menuItemName) {
        this.addLayerNameViewMenuItem(executable, new String[]{menuName}, menuItemName);
    }

    public void addLayerViewMenuItem(PlugIn executable, String[] menuPath, String menuItemName) {
        this.addMainMenuItem(executable, menuPath, menuItemName, false, null, this.checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck());
    }

    public void addLayerNameViewMenuItem(PlugIn executable, String[] menuPath, String menuItemName) {
        this.addMainMenuItem(executable, menuPath, menuItemName, false, null, new MultiEnableCheck().add(this.checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(this.checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()));
    }

    public JMenuItem addMainMenuItem(PlugIn executable, String[] menuPath, String menuItemName, boolean checkBox, Icon icon, EnableCheck enableCheck) {
        if (!executable.isAvailable()) {
            return null;
        }
        Map properties = this.extractProperties(menuItemName);
        menuItemName = FeatureInstaller.removeProperties(menuItemName);
        JMenu menu = this.menuBarMenu(menuPath[0]);
        if (menu == null) {
            menu = (JMenu)FeatureInstaller.installMnemonic(new JMenu(menuPath[0]), this.menuBar());
            this.addToMenuBar(menu);
        }
        JMenu parent = this.createMenusIfNecessary(menu, this.behead(menuPath));
        JMenuItem menuItemTmp = null;
        menuItemTmp = checkBox ? new JCheckBoxMenuItem(menuItemName) : new JMenuItem(menuItemName);
        JMenuItem menuItem = FeatureInstaller.installMnemonic(menuItemTmp, parent);
        menuItem.setIcon(icon);
        if (executable.getKeyStroke() != null) {
            menuItem.setAccelerator(executable.getKeyStroke());
        }
        this.associate(menuItem, executable);
        this.insert(menuItem, this.createMenu(parent), properties);
        if (enableCheck != null) {
            this.addMenuItemShownListener(menuItem, this.toMenuItemShownListener(enableCheck));
        }
        return menuItem;
    }

    private Menu createMenu(final JMenu menu) {
        return new Menu(){

            @Override
            public void insert(JMenuItem menuItem, int i) {
                menu.insert(menuItem, i);
            }

            @Override
            public String getText() {
                return menu.getText();
            }

            @Override
            public int getItemCount() {
                return menu.getItemCount();
            }

            @Override
            public void add(JMenuItem menuItem) {
                menu.add(menuItem);
            }
        };
    }

    private void insert(JMenuItem menuItem, Menu parent, Map properties) {
        if (properties.get("pos") != null) {
            parent.insert(menuItem, Integer.parseInt((String)properties.get("pos")));
        } else if (parent.getText().equals(MenuNames.FILE)) {
            parent.insert(menuItem, parent.getItemCount() - 2);
        } else {
            parent.add(menuItem);
        }
    }

    private Map extractProperties(String menuItemName) {
        if (menuItemName.indexOf(123) == -1) {
            return new HashMap();
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        String s = menuItemName.substring(menuItemName.indexOf(123) + 1, menuItemName.indexOf(125));
        for (String property : StringUtil.fromCommaDelimitedString(s)) {
            properties.put(property.substring(0, property.indexOf(58)).trim(), property.substring(property.indexOf(58) + 1, property.length()).trim());
        }
        return properties;
    }

    public static String removeProperties(String menuItemName) {
        return menuItemName.indexOf(123) > -1 ? menuItemName.substring(0, menuItemName.indexOf(123)) : menuItemName;
    }

    public static JMenuItem installMnemonic(JMenuItem menuItem, MenuElement parent) {
        String text = menuItem.getText();
        StringUtil.replaceAll(text, "&&", "##");
        int ampersandPosition = text.indexOf(38);
        if (-1 < ampersandPosition && ampersandPosition + 1 < text.length()) {
            menuItem.setMnemonic(text.charAt(ampersandPosition + 1));
            text = StringUtil.replace(text, "&", "", false);
        } else {
            FeatureInstaller.installDefaultMnemonic(menuItem, parent);
        }
        StringUtil.replaceAll(text, "##", "&");
        menuItem.setText(text);
        return menuItem;
    }

    private static void installDefaultMnemonic(JMenuItem menuItem, MenuElement parent) {
        block0: for (int i = 0; i < menuItem.getText().length(); ++i) {
            char candidate = Character.toUpperCase(menuItem.getText().charAt(i));
            if (!Character.isLetter(candidate)) continue;
            for (JMenuItem other : FeatureInstaller.menuItems(parent)) {
                if (other.getMnemonic() != candidate) continue;
                continue block0;
            }
            menuItem.setMnemonic(candidate);
            return;
        }
        menuItem.setMnemonic(menuItem.getText().charAt(0));
    }

    private static Collection menuItems(MenuElement element) {
        ArrayList<MenuElement> menuItems = new ArrayList<MenuElement>();
        if (element instanceof JMenuBar) {
            for (int i = 0; i < ((JMenuBar)element).getMenuCount(); ++i) {
                CollectionUtil.addIfNotNull(((JMenuBar)element).getMenu(i), menuItems);
            }
        } else if (element instanceof JMenu) {
            for (int i = 0; i < ((JMenu)element).getItemCount(); ++i) {
                CollectionUtil.addIfNotNull(((JMenu)element).getItem(i), menuItems);
            }
        } else if (element instanceof JPopupMenu) {
            MenuElement[] children;
            for (MenuElement children1 : children = ((JPopupMenu)element).getSubElements()) {
                if (!(children1 instanceof JMenuItem)) continue;
                menuItems.add(children1);
            }
        } else {
            Assert.shouldNeverReachHere((String)element.getClass().getName());
        }
        return menuItems;
    }

    private MenuItemShownListener toMenuItemShownListener(final EnableCheck enableCheck) {
        return new MenuItemShownListener(){

            @Override
            public void menuItemShown(JMenuItem menuItem) {
                String errorMessage = null;
                try {
                    errorMessage = enableCheck.check(menuItem);
                }
                catch (Exception e) {
                    JUMPWorkbench.getFrame().log(menuItem.getText());
                    JUMPWorkbench.getFrame().handleThrowable(e);
                }
                if (errorMessage != null) {
                    menuItem.setEnabled(false);
                    menuItem.setToolTipText(errorMessage);
                    return;
                }
                menuItem.setEnabled(true);
                menuItem.setToolTipText(null);
            }
        };
    }

    public JMenu createMenusIfNecessary(JMenu parent, String[] menuPath) {
        if (menuPath.length == 0) {
            return parent;
        }
        JMenu child = (JMenu)FeatureInstaller.childMenuItem(menuPath[0], parent);
        if (child == null) {
            child = (JMenu)FeatureInstaller.installMnemonic(new JMenu(menuPath[0]), parent);
            parent.add(child);
        }
        return this.createMenusIfNecessary(child, this.behead(menuPath));
    }

    public void addMenuItemShownListener(final JMenuItem menuItem, final MenuItemShownListener menuItemShownListener) {
        JMenu menu = (JMenu)((JPopupMenu)menuItem.getParent()).getInvoker();
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                menuItemShownListener.menuItemShown(menuItem);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
    }

    public void addJMenuItem(JMenu menu, PlugIn executable, String menuItemName, boolean checkBox, Icon icon, EnableCheck enableCheck) {
        Map properties = this.extractProperties(menuItemName);
        menuItemName = FeatureInstaller.removeProperties(menuItemName);
        JMenuItem menuItem = FeatureInstaller.installMnemonic(checkBox ? new JCheckBoxMenuItem(menuItemName) : new JMenuItem(menuItemName), menu);
        menuItem.setIcon(icon);
        this.addJMenuItem(menu, executable, menuItem, properties, enableCheck);
    }

    private void addJMenuItem(JMenu menu, PlugIn executable, final JMenuItem menuItem, Map properties, final EnableCheck enableCheck) {
        if (!executable.isAvailable()) {
            return;
        }
        this.associate(menuItem, executable);
        this.insert(menuItem, this.createMenu(menu), properties);
        if (enableCheck != null) {
            menu.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent e) {
                    FeatureInstaller.this.toMenuItemShownListener(enableCheck).menuItemShown(menuItem);
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                }

                @Override
                public void menuCanceled(MenuEvent e) {
                }
            });
        }
    }

    public void addPopupMenuItem(JPopupMenu popupMenu, PlugIn executable, String menuItemName, boolean checkBox, Icon icon, EnableCheck enableCheck) {
        Map properties = this.extractProperties(menuItemName);
        menuItemName = FeatureInstaller.removeProperties(menuItemName);
        JMenuItem menuItem = FeatureInstaller.installMnemonic(checkBox ? new JCheckBoxMenuItem(menuItemName) : new JMenuItem(menuItemName), popupMenu);
        menuItem.setIcon(icon);
        this.addPopupMenuItem(popupMenu, executable, menuItem, properties, enableCheck);
    }

    private void addPopupMenuItem(JPopupMenu popupMenu, PlugIn executable, final JMenuItem menuItem, Map properties, final EnableCheck enableCheck) {
        if (!executable.isAvailable()) {
            return;
        }
        this.associate(menuItem, executable);
        this.insert(menuItem, this.createMenu(popupMenu), properties);
        if (enableCheck != null) {
            popupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    FeatureInstaller.this.toMenuItemShownListener(enableCheck).menuItemShown(menuItem);
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
    }

    public FeatureInstaller addPopupMenuItem(JPopupMenu popupMenu, PlugIn plugIn) {
        this.addPopupMenuItem(popupMenu, plugIn, plugIn.getNameWithMnemonic(), false, plugIn.getIcon(), plugIn.createEnableCheck());
        return this;
    }

    private Menu createMenu(final JPopupMenu popupMenu) {
        return new Menu(){

            @Override
            public void insert(JMenuItem menuItem, int i) {
                popupMenu.insert(menuItem, i);
            }

            @Override
            public String getText() {
                return "";
            }

            @Override
            public int getItemCount() {
                return popupMenu.getComponentCount();
            }

            @Override
            public void add(JMenuItem menuItem) {
                popupMenu.add(menuItem);
            }
        };
    }

    public JMenuBar menuBar() {
        return JUMPWorkbench.getFrame().getJMenuBar();
    }

    public JMenu menuBarMenu(String childName) {
        MenuElement[] subElements;
        for (MenuElement subElement : subElements = this.menuBar().getSubElements()) {
            JMenuItem menuItem;
            if (!(subElement instanceof JMenuItem) || !(menuItem = (JMenuItem)subElement).getText().equals(childName)) continue;
            return (JMenu)menuItem;
        }
        return null;
    }

    public void addToMenuBar(JMenu menu) {
        this.menuBar().add(menu);
        JMenu windowMenu = this.menuBarMenu(MenuNames.WINDOW);
        JMenu helpMenu = this.menuBarMenu(MenuNames.HELP);
        if (windowMenu != null) {
            this.menuBar().remove(windowMenu);
        }
        if (helpMenu != null) {
            this.menuBar().remove(helpMenu);
        }
        if (windowMenu != null) {
            this.menuBar().add(windowMenu);
        }
        if (helpMenu != null) {
            this.menuBar().add(helpMenu);
        }
    }

    public static JMenuItem childMenuItem(String childName, MenuElement menu) {
        MenuElement[] childMenuItems;
        if (menu instanceof JMenu) {
            return FeatureInstaller.childMenuItem(childName, ((JMenu)menu).getPopupMenu());
        }
        for (MenuElement childMenuItem : childMenuItems = menu.getSubElements()) {
            if (!(childMenuItem instanceof JMenuItem) || !((JMenuItem)childMenuItem).getText().equals(childName)) continue;
            return (JMenuItem)childMenuItem;
        }
        return null;
    }

    private ActionListener abstractPlugInActionListener(ActionListener[] actionListeners) {
        for (ActionListener actionListener : actionListeners) {
            if (actionListener.getClass().getName().indexOf(AbstractPlugIn.class.getName()) <= -1) continue;
            return actionListener;
        }
        Assert.shouldNeverReachHere();
        return null;
    }

    private static interface Menu {
        public void insert(JMenuItem var1, int var2);

        public String getText();

        public int getItemCount();

        public void add(JMenuItem var1);
    }
}

