/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.io.FUTURE_JTS_WKTWriter;
import com.vividsolutions.jump.workbench.WorkbenchException;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.EnterWKTDialog;
import com.vividsolutions.jump.workbench.ui.plugin.WKTDisplayHelper;
import com.vividsolutions.jump.workbench.ui.plugin.WKTPlugIn;
import de.riwagis.geotools.feature.util.FeatureUtil;
import java.util.Arrays;
import org.geotools.feature.FeatureCollection;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class EditSelectedFeaturePlugIn
extends WKTPlugIn {
    private SimpleFeature feature;
    private final WKTDisplayHelper helper = new WKTDisplayHelper();

    @Override
    protected Layer layer(PlugInContext context) {
        return context.getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems().iterator().next();
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.EditSelectedFeaturePlugIn.view-edit-selected-feature");
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createExactlyNFeaturesMustHaveSelectedItemsCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        return this.execute(context, context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems().iterator().next(), true);
    }

    public boolean execute(PlugInContext context, SimpleFeature feature, boolean editable) throws Exception {
        this.feature = FeatureUtil.cloneFeature((SimpleFeature)feature, (boolean)false);
        return super.execute(context);
    }

    @Override
    protected void apply(String wkt, PlugInContext context) throws Exception {
        if (!this.layer(context).isEditable()) {
            return;
        }
        super.apply(wkt, context);
    }

    @Override
    protected void apply(FeatureCollection<SimpleFeatureType, SimpleFeature> c, PlugInContext context) throws WorkbenchException {
        if (c.size() != 1) {
            throw new WorkbenchException(I18N.get("ui.plugin.EditSelectedFeaturePlugIn.expected-1-feature-but-found") + " " + c.size());
        }
        EditTransaction transaction = new EditTransaction(Arrays.asList(this.feature), this.getName(), this.layer, this.isRollingBackInvalidEdits(context), false, context.getWorkbenchFrame());
        transaction.setGeometry(0, (Geometry)((SimpleFeature)c.features().next()).getDefaultGeometry());
        transaction.commit();
    }

    @Override
    protected EnterWKTDialog createDialog(PlugInContext context) {
        EnterWKTDialog d = super.createDialog(context);
        d.setTitle((String)(this.layer(context).isEditable() ? I18N.get("ui.plugin.EditSelectedFeaturePlugIn.edit") + " " : "") + I18N.get("ui.plugin.EditSelectedFeaturePlugIn.feature") + " " + this.feature.getID() + " " + I18N.get("ui.plugin.EditSelectedFeaturePlugIn.in") + " " + String.valueOf(this.layer) + (String)(this.layer(context).isEditable() ? "" : " (" + I18N.get("ui.plugin.EditSelectedFeaturePlugIn.layer-is-uneditable") + ")"));
        d.setEditable(this.layer(context).isEditable());
        d.setText(this.helper.format(new FUTURE_JTS_WKTWriter().write((Geometry)this.feature.getDefaultGeometry())));
        return d;
    }
}

