/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GeometryEditor;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManagerProxy;
import de.riwagis.icons.IconLoader;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.locationtech.jts.geom.Geometry;

public class DeleteSelectedItemsPlugIn
extends AbstractPlugIn {
    private final GeometryEditor geometryEditor = new GeometryEditor();

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"common_delete.svg");
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.DeleteSelectedItemsPlugIn.name");
    }

    @Override
    public KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(127, 0);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)WorkbenchContext.getFrame(), (String)I18N.get("common.wait"));
        dlgWait.addWorkToDo(() -> {
            try {
                ArrayList<EditTransaction> transactions = new ArrayList<EditTransaction>();
                List<Layer> lstAllowedLayers = EditingPanel.instanceOf().getDeleteLayers();
                for (Layer layerWithSelectedItems : ((SelectionManagerProxy)((Object)context.getActiveInternalFrame())).getSelectionManager().getLayersWithSelectedItems()) {
                    if (!lstAllowedLayers.contains(layerWithSelectedItems)) continue;
                    if (dlgWait.isCanceled()) {
                        return;
                    }
                    FeaturestoreMetadata fmd = layerWithSelectedItems.getFMD();
                    transactions.add(EditTransaction.createTransactionOnSelection((geometryWithSelectedItems, selectedItems) -> {
                        Geometry g = geometryWithSelectedItems;
                        for (Geometry selectedItem : selectedItems) {
                            g = this.geometryEditor.remove(g, selectedItem);
                        }
                        return g;
                    }, (SelectionManagerProxy)((Object)context.getActiveInternalFrame()), context.getWorkbenchFrame(), this.getName(), layerWithSelectedItems, this.isRollingBackInvalidEdits(context), fmd.isDeleteAllowed()));
                }
                if (dlgWait.isCanceled()) {
                    return;
                }
                EditTransaction.commit(transactions);
            }
            catch (Exception e) {
                dlgWait.setError(e);
            }
        });
        dlgWait.setVisible(100L);
        if (dlgWait.getError() != null) {
            WorkbenchContext.getErrorHandler().handleThrowable(dlgWait.getError());
        }
        return true;
    }

    @Override
    public EnableCheck createEnableCheck() {
        return EditingPanel.instanceOf().getDeleteSelectionEnableCheck();
    }
}

