/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.COpt;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.CategoryEventType;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.CategoryNamePanel;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.util.Arrays;
import java.util.Optional;
import javax.swing.JTabbedPane;

public class ChangeCategoryPlugIn
extends AbstractPlugIn {
    private MultiInputDialog currentDialog = null;
    private CategoryNamePanel categoryNamePanel = null;

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayerablesMustBeSelectedCheck(0, Layerable.class)).add(checkFactory.createExactlyNLocalCategoriesMustBeSelectedCheck(1)).add(checkFactory.createExactlyNCategoriesMustBeSelectedCheck(1));
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.ChangeCategoryPlugIn.name") + "...";
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Optional<Category> first = context.getLayerNamePanel().getSelectedCategories().stream().findFirst();
        if (COpt.VIEWER || first.isEmpty() || first.orElseThrow().isBuildIn()) {
            return false;
        }
        Category category = first.orElseThrow();
        if (this.currentDialog != null && this.currentDialog.isVisible()) {
            GUISupport.msgbox((Component)context.getWorkbenchFrame(), (String)I18N.getMessage("ui.style.SelectChangeStylesPlugIn.please-finish-current-dialog", this.currentDialog.getTitle()), (String)I18N.get("common.message"));
            return true;
        }
        if (this.categoryNamePanel == null) {
            this.categoryNamePanel = new CategoryNamePanel(category);
        } else {
            this.categoryNamePanel.setCategory(category);
        }
        if (this.currentDialog == null) {
            this.currentDialog = this.generateDialog(context, false);
        }
        this.currentDialog.removeAllOKApplyCancelListener();
        this.addDialogListener(context, category);
        this.currentDialog.setVisible(true);
        return true;
    }

    protected final MultiInputDialog generateDialog(PlugInContext context, boolean bolModal) {
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), I18N.get("ui.plugin.ChangeCategoryPlugIn.name"), bolModal);
        dialog.setInset(0);
        dialog.setApplyVisible(!bolModal);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add((Component)this.categoryNamePanel, this.categoryNamePanel.getTitle());
        dialog.addEnableChecks(this.categoryNamePanel.getTitle(), Arrays.asList(component -> this.categoryNamePanel.validateInput()));
        dialog.addRow(tabbedPane);
        dialog.setResizable(false);
        GUIUtil.centreOnScreen(dialog);
        return dialog;
    }

    private void addDialogListener(PlugInContext context, final Category category) {
        this.currentDialog.addOkApplyCancelListener(e -> {
            if (this.currentDialog.wasApplyPressed() || this.currentDialog.wasOKPressed()) {
                final UndoableCommand undo = this.categoryNamePanel.updateCategory();
                AbstractPlugIn.execute(new UndoableCommand(this, I18N.get("ui.plugin.AbstractChangeStylePlugIn.edit-layerable")){

                    @Override
                    public void execute() {
                        boolean isFiringEvents = category.getLayerManager().isFiringEvents();
                        category.getLayerManager().setFiringEvents(false);
                        try {
                            undo.execute();
                        }
                        finally {
                            category.getLayerManager().setFiringEvents(isFiringEvents);
                            category.fireCategoryChanged(CategoryEventType.METADATA_CHANGED);
                        }
                    }

                    @Override
                    public void unexecute() {
                        boolean isFiringEvents = category.getLayerManager().isFiringEvents();
                        category.getLayerManager().setFiringEvents(false);
                        try {
                            undo.unexecute();
                        }
                        finally {
                            category.getLayerManager().setFiringEvents(isFiringEvents);
                            category.fireCategoryChanged(CategoryEventType.METADATA_CHANGED);
                        }
                    }
                }, (LayerManagerProxy)context);
                this.categoryNamePanel.setCategory(category);
            }
        });
    }
}

