/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.locationtech.jts.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryNamePanel
extends JPanel {
    private static final Logger LOG = LoggerFactory.getLogger(CategoryNamePanel.class);
    private final JScrollPane scrollPane1 = new JScrollPane();
    private final JLabel lblDesc = new JLabel();
    private final JLabel lblName = new JLabel();
    private final JTextArea txtDesc = new JTextArea();
    private final JTextField txtName = new JTextField();
    private LayerManager lyMngr = null;
    private Category category = null;

    public CategoryNamePanel(Category _category) {
        this.initComponents();
        this.setCategory(_category);
    }

    public final void setCategory(Category _category) {
        this.category = _category;
        this.updateComponents();
    }

    public void setLayerManager(LayerManager _lyMngr) {
        this.lyMngr = _lyMngr;
    }

    public String validateInput() {
        return null;
    }

    public String getTitle() {
        return I18N.get("ui.plugin.CategoryNamePanel.title");
    }

    public UndoableCommand updateCategory() {
        try {
            return new CategoryNameUndoableCommand(this.category, this.txtName.getText(), this.txtDesc.getText());
        }
        catch (Exception e) {
            Assert.shouldNeverReachHere((String)e.getMessage());
            return new UndoableCommand(this, "LayerNamePanel"){

                @Override
                public void execute() {
                }

                @Override
                public void unexecute() {
                }
            };
        }
    }

    private void updateComponents() {
        this.txtName.setText(this.category.getName());
        this.txtDesc.setText(this.category.getDescription());
    }

    private void initComponents() {
        this.lblName.setText(I18N.get("ui.plugin.CategoryNamePanel.categoryname"));
        this.lblDesc.setText(I18N.get("ui.plugin.CategoryNamePanel.categorydesc"));
        this.txtDesc.setColumns(45);
        this.txtDesc.setLineWrap(true);
        this.txtDesc.setRows(2);
        this.txtDesc.setFont(this.txtName.getFont());
        this.scrollPane1.setViewportView(this.txtDesc);
        GridBagLayout gbLayout = new GridBagLayout();
        this.setLayout(gbLayout);
        JPanel layerPanel = new JPanel();
        GUIUtil.addGridBagComponent(this, layerPanel, gbLayout, 0, 0, 1, 1, 17, 0, new Insets(2, 10, 2, 2));
        GridBagConstraints gbcFiller = new GridBagConstraints();
        gbcFiller.weightx = 5.0;
        gbcFiller.weighty = 5.0;
        GUIUtil.addGridBagComponent(this, new JPanel(), gbLayout, gbcFiller, 0, 2, 0, 0, 10, 1, new Insets(0, 0, 0, 0));
        GridBagLayout gbLayout2 = new GridBagLayout();
        layerPanel.setLayout(gbLayout2);
        GUIUtil.addGridBagComponent(layerPanel, this.lblName, gbLayout2, 0, 0, 1, 1, 13, 0, new Insets(5, 5, 0, 0));
        this.txtName.setPreferredSize(new Dimension(200, 20));
        GUIUtil.addGridBagComponent(layerPanel, this.txtName, gbLayout2, 1, 0, 1, 1, 17, 0, new Insets(5, 5, 0, 0));
        GUIUtil.addGridBagComponent(layerPanel, this.lblDesc, gbLayout2, 0, 1, 1, 1, 12, 0, new Insets(5, 5, 0, 0));
        GUIUtil.addGridBagComponent(layerPanel, this.scrollPane1, gbLayout2, 1, 1, 3, 1, 17, 0, new Insets(5, 5, 0, 5));
        this.scrollPane1.setPreferredSize(new Dimension(350, 50));
    }

    private static class CategoryNameUndoableCommand
    extends UndoableCommand {
        private Category cat = null;
        private String strOldName = "";
        private String strNewName = "";
        private String strOldDesc = "";
        private String strNewDesc = "";

        protected CategoryNameUndoableCommand(Category cat, String strName, String strDesc) throws Exception {
            super("CategoryNamePanel");
            this.cat = cat;
            this.getOldProperties();
            this.strNewName = strName;
            this.strNewDesc = strDesc;
        }

        @Override
        public void execute() {
            try {
                this.cat.setName(this.strNewName);
                this.cat.setDescription(this.strNewDesc);
            }
            catch (Exception e) {
                LOG.error("Error executing change of LayerNamePanel.", (Throwable)e);
            }
        }

        @Override
        public void unexecute() {
            try {
                this.cat.setName(this.strOldName);
                this.cat.setDescription(this.strOldDesc);
            }
            catch (Exception e) {
                LOG.error("Error unexecuting change of LayerNamePanel.", (Throwable)e);
            }
        }

        private void getOldProperties() {
            this.strOldName = this.cat.getName();
            this.strOldDesc = this.cat.getDescription();
        }
    }
}

