/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.CategoryEventType;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import java.util.Collection;

public class AddNewSubcategoryPlugIn
extends AbstractPlugIn {
    private static final String NEW_CATEGORY_NAME = I18N.get("ui.plugin.AbstractNewCategoryPlugIn.new-category");

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        String categoryName = this.findNewCategoryName(context.getLayerManager());
        Collection<Category> selectedCategories = context.getLayerNamePanel().getSelectedCategories();
        LayerManager lyMngr = context.getLayerManager();
        lyMngr.setFiringEvents(false);
        Category newCat = lyMngr.addCategory(categoryName);
        newCat.setParentCategory((Category)selectedCategories.toArray()[0]);
        lyMngr.setFiringEvents(true);
        lyMngr.fireCategoryChanged(newCat, CategoryEventType.ADDED);
        return true;
    }

    private String findNewCategoryName(LayerManager layerManager) {
        String newName;
        if (layerManager.getCategory(NEW_CATEGORY_NAME) == null) {
            return NEW_CATEGORY_NAME;
        }
        int i = 2;
        do {
            newName = NEW_CATEGORY_NAME + " (" + i + ")";
            ++i;
        } while (layerManager.getCategory(newName) != null);
        return newName;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        MultiEnableCheck chk = new MultiEnableCheck();
        chk.add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck());
        chk.add(checkFactory.createExactlyNLocalCategoriesMustBeSelectedCheck(1));
        return chk;
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.AddNewSubcategoryPlugIn.name");
    }
}

