/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.EnterWKTDialog;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.plugin.WKTPlugIn;
import de.riwagis.geotools.feature.util.FeatureUtil;
import java.util.ArrayList;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddNewFeaturesPlugIn
extends WKTPlugIn {
    private static final Logger LOG = LoggerFactory.getLogger(AddNewFeaturesPlugIn.class);

    @Override
    protected Layer layer(PlugInContext context) {
        return EditingPanel.instanceOf().getCurrentLayer();
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        return super.execute(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void apply(FeatureCollection<SimpleFeatureType, SimpleFeature> c, PlugInContext context) {
        try {
            final ArrayList<SimpleFeature> lstFeatures = new ArrayList<SimpleFeature>();
            try (FeatureIterator i = c.features();){
                while (i.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)i.next();
                    SimpleFeature newfeature = FeatureUtil.createFeature((SimpleFeatureType)this.layer.getFeatureType(), (Geometry)((Geometry)feature.getDefaultGeometry()));
                    lstFeatures.add(newfeature);
                }
            }
            this.execute(new UndoableCommand(this.getName()){

                @Override
                public void execute() {
                    AddNewFeaturesPlugIn.this.layer.editFeature(lstFeatures, 1);
                }

                @Override
                public void unexecute() {
                    AddNewFeaturesPlugIn.this.layer.editFeature(lstFeatures, 3);
                }
            }, context);
        }
        catch (Exception e) {
            LOG.warn(String.format("error: %s", e.getMessage()), (Throwable)e);
            Assert.shouldNeverReachHere();
        }
    }

    @Override
    protected EnterWKTDialog createDialog(PlugInContext context) {
        EnterWKTDialog d = super.createDialog(context);
        d.setTitle(String.format("%s %s", I18N.get("ui.plugin.AddNewFeaturesPlugIn.add-features-to"), this.layer));
        d.setDescription(String.format("<HTML>%s</HTML>", I18N.get("ui.plugin.AddNewFeaturesPlugIn.enter-well-known-text-for-one-or-more-geometries")));
        return d;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustBeEditableCheck(1));
    }
}

