/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.util.Assert;

public class AddNewCategoryPlugIn
extends AbstractPlugIn {
    private static final String NEW_CATEGORY_NAME = I18N.get("ui.plugin.AbstractNewCategoryPlugIn.new-category");

    @Override
    public boolean execute(final PlugInContext context) throws Exception {
        final String categoryName = this.findNewCategoryName(context.getLayerManager());
        this.execute(new UndoableCommand(this, this.getName()){

            @Override
            public void execute() {
                context.getLayerManager().addCategory(categoryName);
            }

            @Override
            public void unexecute() {
                Assert.isTrue((boolean)context.getLayerManager().getCategory(categoryName).isEmpty(), (String)I18N.get("ui.plugin.AbstractNewCategoryPlugIn.this-can-happen-when-a-plug-in-calls"));
                context.getLayerManager().removeIfEmpty(context.getLayerManager().getCategory(categoryName));
            }
        }, context);
        return true;
    }

    private String findNewCategoryName(LayerManager layerManager) {
        String newName;
        if (layerManager.getCategory(NEW_CATEGORY_NAME) == null) {
            return NEW_CATEGORY_NAME;
        }
        int i = 2;
        do {
            newName = NEW_CATEGORY_NAME + " (" + i + ")";
            ++i;
        } while (layerManager.getCategory(newName) != null);
        return newName;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck());
    }
}

