/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.layertree.sublayervalues;

import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.ui.layertree.sublayervalues.SubLayerValue;
import com.vividsolutions.jump.workbench.ui.plugin.wms.WMSStyleRenderer;
import de.riwagis.riwajump.model.style.WMSStyleModel;
import java.io.IOException;
import java.util.Objects;
import javax.swing.tree.TreePath;
import org.locationtech.jts.util.Assert;

public class WMSLayerValue
implements SubLayerValue {
    private final String strWmsLayer;
    private final WMSLayer ly;
    private final WMSStyleModel wmsStyle;

    public WMSLayerValue(String strWmsLayer, WMSLayer ly, WMSStyleModel wmsStyle) {
        Assert.isTrue((strWmsLayer != null ? 1 : 0) != 0);
        this.strWmsLayer = strWmsLayer;
        this.ly = ly;
        this.wmsStyle = wmsStyle;
    }

    public String toString() {
        WMSStyleRenderer wmsRenderer = (WMSStyleRenderer)this.wmsStyle.getIntelligence();
        try {
            if (!wmsRenderer.doesWMServiceNeedInitialisation()) {
                return wmsRenderer.getWMService().getLayerTitle(this.strWmsLayer);
            }
            return this.strWmsLayer;
        }
        catch (IOException e) {
            return "Error retrieving WMS Layertitle";
        }
    }

    public boolean equals(Object other) {
        return other instanceof WMSLayerValue && Objects.equals(this.strWmsLayer, ((WMSLayerValue)other).strWmsLayer) && this.wmsStyle == ((WMSLayerValue)other).wmsStyle;
    }

    @Override
    public WMSLayer getLayer() {
        return this.ly;
    }

    public WMSStyleModel getStyle() {
        return this.wmsStyle;
    }

    @Override
    public boolean isVisible() {
        return !this.wmsStyle.getLstLayerInvisible().contains(this.strWmsLayer);
    }

    @Override
    public TreePath getTreePath() {
        TreePath lyPath = this.ly.getTreePath();
        Object[] arrLyPath = lyPath.getPath();
        Object[] arrPath = new Object[arrLyPath.length + 1];
        System.arraycopy(arrLyPath, 0, arrPath, 0, arrLyPath.length);
        arrPath[arrLyPath.length] = this;
        return new TreePath(arrPath);
    }

    @Override
    public boolean setVisible(boolean bolVisible) {
        if (!this.wmsStyle.getLstLayerNames().contains(this.strWmsLayer)) {
            return false;
        }
        if (bolVisible) {
            this.wmsStyle.removeLayerInvisiblility(this.strWmsLayer);
        } else {
            this.wmsStyle.addLayerInvisiblility(this.strWmsLayer);
        }
        this.ly.fireLayerChanged(LayerEventType.VISIBILITY_CHANGED);
        return true;
    }

    @Override
    public int compareTo(Object o) {
        String strObj = Objects.toString(o, "");
        return this.toString().compareTo(strObj);
    }
}

