/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.layertree.sublayervalues;

import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.ui.layertree.sublayervalues.SubLayerValue;
import de.riwagis.riwajump.model.style.CadStyleModel;
import java.util.Objects;
import javax.swing.tree.TreePath;
import org.locationtech.jts.util.Assert;

public class CadLayerValue
implements SubLayerValue {
    private final String drawingLayer;
    private final Layer ly;
    private final CadStyleModel cadStyle;

    public CadLayerValue(String drawingLayer, Layer ly, CadStyleModel cadStyle) {
        Assert.isTrue((drawingLayer != null ? 1 : 0) != 0);
        this.drawingLayer = drawingLayer;
        this.ly = ly;
        this.cadStyle = cadStyle;
    }

    public String toString() {
        return this.drawingLayer;
    }

    public boolean equals(Object other) {
        return other instanceof CadLayerValue && Objects.equals(this.drawingLayer, ((CadLayerValue)other).getDrawingLayer()) && this.cadStyle == ((CadLayerValue)other).getStyle();
    }

    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + Objects.hashCode(this.drawingLayer);
        hash = 41 * hash + Objects.hashCode(this.cadStyle);
        return hash;
    }

    @Override
    public Layer getLayer() {
        return this.ly;
    }

    public CadStyleModel getStyle() {
        return this.cadStyle;
    }

    public String getDrawingLayer() {
        return this.drawingLayer;
    }

    @Override
    public boolean isVisible() {
        return this.cadStyle.getMapLayerVisi().containsKey(this.drawingLayer);
    }

    @Override
    public TreePath getTreePath() {
        TreePath lyPath = this.ly.getTreePath();
        Object[] arrLyPath = lyPath.getPath();
        Object[] arrPath = new Object[arrLyPath.length + 1];
        System.arraycopy(arrLyPath, 0, arrPath, 0, arrLyPath.length);
        arrPath[arrLyPath.length] = this;
        return new TreePath(arrPath);
    }

    @Override
    public boolean setVisible(boolean bolVisible) {
        if (!this.cadStyle.getMapLayerID().containsKey(this.drawingLayer)) {
            return false;
        }
        if (bolVisible) {
            this.cadStyle.addMapLayerVisi(this.drawingLayer);
        } else {
            this.cadStyle.removeMapLayerVisi(this.drawingLayer);
        }
        this.ly.fireLayerChanged(LayerEventType.VISIBILITY_CHANGED);
        return true;
    }

    @Override
    public int compareTo(Object o) {
        String strObj = Objects.toString(o, "");
        return this.toString().compareTo(strObj);
    }
}

