/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.layertree;

import com.vividsolutions.jump.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import java.util.function.Function;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.locationtech.jts.util.Assert;

public class TreeUtil {
    public static TreeCellRenderer createSimpleTreeCellRenderer(ImageIcon icon) {
        return TreeUtil.createSimpleTreeCellRenderer(null, icon, new JTree().getFont());
    }

    public static TreeCellRenderer createSimpleTreeCellRenderer(final String text, final ImageIcon icon, final Font font) {
        return new DefaultTreeCellRenderer(){
            private static final long serialVersionUID = 3201372677843053433L;
            {
                this.setOpenIcon(icon);
                this.setClosedIcon(icon);
                this.setLeafIcon(icon);
                this.setBackgroundNonSelectionColor(new Color(0, 0, 0, 0));
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component component = super.getTreeCellRendererComponent(tree, text == null ? value : text, sel, expanded, leaf, row, hasFocus);
                component.setFont(font);
                return component;
            }
        };
    }

    public static void visit(TreeModel model, Visitor<Object> visitor) {
        Stack<Object> path = new Stack<Object>();
        path.push(model.getRoot());
        TreeUtil.visit(model, path, visitor);
    }

    public static void visit(TreeModel model, TreePath path, Visitor<Object> visitor) {
        Stack<Object> stack = new Stack<Object>();
        stack.addAll(Arrays.asList(path.getPath()));
        TreeUtil.visit(model, stack, visitor);
    }

    private static void visit(TreeModel model, Stack<Object> path, Visitor<Object> visitor) {
        visitor.visit(path);
        for (int i = 0; i < model.getChildCount(path.peek()); ++i) {
            path.push(model.getChild(path.peek(), i));
            TreeUtil.visit(model, path, visitor);
            path.pop();
        }
    }

    public static TreeModelEvent createTreeModelEvent(Object source, Object node, TreeModel model) {
        TreePath path = TreeUtil.findTreePath(node, model);
        Assert.isTrue((path != null ? 1 : 0) != 0, (String)("Cannot find node in TreeModel: " + String.valueOf(node) + "\n" + TreeUtil.dump(model)));
        TreePath parentPath = path.getParentPath();
        return new TreeModelEvent(source, parentPath, new int[]{model.getIndexOfChild(parentPath.getLastPathComponent(), node)}, new Object[]{node});
    }

    public static String dump(TreeModel model) {
        StringBuffer result = new StringBuffer();
        TreeUtil.visit(model, path -> result.append(StringUtil.repeat(' ', path.size() * 2)).append(path.lastElement()).append("\n"));
        return result.toString();
    }

    public static TreePath findTreePath(Object node, TreeModel model) {
        TreePath[] treePath = new TreePath[]{null};
        TreeUtil.visit(model, path -> {
            if (path.peek() != node) {
                return;
            }
            treePath[0] = new TreePath(path.toArray());
        });
        return treePath[0];
    }

    public static boolean contains(TreeModel model, Object node) {
        boolean[] result = new boolean[]{false};
        TreeUtil.visit(model, path -> {
            if (path.peek() == node) {
                result[0] = true;
            }
        });
        return result[0];
    }

    public static List<Object> lastPathComponents(TreePath[] paths) {
        ArrayList<Object> lastPathComponents = new ArrayList<Object>();
        for (TreePath path : paths) {
            lastPathComponents.add(path.getLastPathComponent());
        }
        return lastPathComponents;
    }

    public static void expandAll(JTree tree, TreePath path) {
        TreeUtil.expand(tree, path, node -> Boolean.TRUE);
    }

    public static void expand(JTree tree, TreePath path, Function<Object, Boolean> expandNodeCondition) {
        TreeUtil.visit(tree.getModel(), path, (Stack<Object> path1) -> {
            if (!((Boolean)expandNodeCondition.apply(path1.peek())).booleanValue()) {
                return;
            }
            tree.expandPath(TreeUtil.findTreePath(path1.peek(), tree.getModel()));
        });
    }

    public static Collection<Object> nodes(TreePath path, TreeModel model) {
        ArrayList<Object> nodes = new ArrayList<Object>();
        TreeUtil.visit(model, path, (Stack<Object> path1) -> nodes.add(path1.peek()));
        return nodes;
    }

    private TreeUtil() {
    }

    public static interface Visitor<T> {
        public void visit(Stack<T> var1);
    }
}

