/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.layertree;

import com.formdev.flatlaf.icons.FlatSearchIcon;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.ui.layertree.AsyncTreeLayerNamePanelAction;
import com.vividsolutions.jump.workbench.ui.layertree.TreeLayerSearchResultListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import lombok.Generated;
import org.jdesktop.swingx.JXBusyLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeLayerSearchPanel
extends JPanel
implements AsyncTreeLayerNamePanelAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TreeLayerSearchPanel.class);
    private static final int DIMENSION_BORDER = 2;
    private static final int DIMENSION_BUSYLABEL = 16;
    private final LayerManager lyrMang;
    private JTextField textField;
    private JXBusyLabel busyLabel;
    private final List<TreeLayerSearchResultListener> listeners = new ArrayList<TreeLayerSearchResultListener>();

    protected TreeLayerSearchPanel(LayerManager lyrMang) {
        this.lyrMang = lyrMang;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setOpaque(false);
        this.initTextField();
        this.initBusyLabel();
    }

    protected void putSearchComponentIntoInitMode(boolean initModeActive) {
        if (!initModeActive) {
            this.textField.addActionListener(e -> this.listeners.forEach(listener -> listener.treeLayerSearchPerformed()));
            this.textField.putClientProperty("JTextField.placeholderText", I18N.get("TreeLayerNamePanel.layerableSearchField.placeholder"));
            this.textField.putClientProperty("JTextField.showClearButton", true);
            this.textField.putClientProperty("JTextField.trailingComponent", null);
        } else {
            Arrays.asList(this.textField.getActionListeners()).forEach(listener -> this.textField.removeActionListener((ActionListener)listener));
            this.textField.putClientProperty("JTextField.placeholderText", I18N.get("TreeLayerNamePanel.layerableSearchField.init"));
            this.textField.putClientProperty("JTextField.showClearButton", false);
            this.textField.putClientProperty("JTextField.trailingComponent", this.busyLabel);
        }
    }

    protected String getText() {
        return this.textField.getText();
    }

    protected void addTreeLayerSearchResultListener(TreeLayerSearchResultListener listener) {
        this.listeners.add(listener);
    }

    private void initTextField() {
        this.textField = new JTextField();
        this.textField.putClientProperty("JTextField.placeholderText", I18N.get("TreeLayerNamePanel.layerableSearchField.placeholder"));
        this.textField.addActionListener(e -> this.listeners.forEach(listener -> listener.treeLayerSearchPerformed()));
        this.textField.putClientProperty("JTextField.leadingIcon", new FlatSearchIcon());
        this.textField.putClientProperty("JTextField.showClearButton", true);
        this.textField.putClientProperty("JTextField.clearCallback", tf -> tf.setText(""));
        this.textField.setColumns(20);
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.checkIfEmpty();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.checkIfEmpty();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            private void checkIfEmpty() {
                if (TreeLayerSearchPanel.this.textField.getText().isBlank()) {
                    TreeLayerSearchPanel.this.textField.setText("");
                    TreeLayerSearchPanel.this.listeners.forEach(listener -> listener.treeLayerSearchPerformed());
                }
            }
        });
        this.add((Component)this.textField, "Center");
    }

    private void initBusyLabel() {
        this.busyLabel = new JXBusyLabel(new Dimension(18, 16));
        this.busyLabel.setBusy(true);
    }

    @Override
    public Collection<Runnable> getAsyncComputations() {
        this.putSearchComponentIntoInitMode(true);
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        for (Layerable lay : this.lyrMang.getLayerables()) {
            if (lay.isLayerInitialized()) continue;
            result.add(() -> {
                try {
                    lay.executeForInitialization();
                }
                catch (Exception ex) {
                    throw new RuntimeException("Could not lazy load layer " + lay.getKey(), ex);
                }
            });
        }
        return result;
    }

    @Override
    public void onExecutionFinished() {
        SwingUtilities.invokeLater(() -> this.putSearchComponentIntoInitMode(false));
    }
}

