/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.layertree;

import com.vividsolutions.jump.workbench.ui.layertree.AsyncTreeLayerNamePanelAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeLayerNamePanelAsyncActionWorker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TreeLayerNamePanelAsyncActionWorker.class);
    private static final int MINIMUM_THREADS = 2;
    private final ExecutorService executorService;
    private CompletableFuture<?> asyncComputations;
    private final List<AsyncTreeLayerNamePanelAction> listeners = new ArrayList<AsyncTreeLayerNamePanelAction>();

    protected TreeLayerNamePanelAsyncActionWorker() {
        BasicThreadFactory factory = new BasicThreadFactory.Builder().namingPattern("layertree-init-%d").build();
        int nThreads = Math.max(Runtime.getRuntime().availableProcessors(), 2);
        this.executorService = Executors.newFixedThreadPool(nThreads, (ThreadFactory)factory);
        this.asyncComputations = null;
    }

    protected void addListener(AsyncTreeLayerNamePanelAction listener) {
        this.listeners.add(listener);
    }

    public void execute() {
        if (this.asyncComputations != null) {
            throw new IllegalStateException("Async layer actions can only be initialized once.");
        }
        List futures = this.listeners.stream().map(AsyncTreeLayerNamePanelAction::getAsyncComputations).flatMap(Collection::stream).map(action -> CompletableFuture.runAsync(action, this.executorService).orTimeout(15L, TimeUnit.SECONDS)).collect(Collectors.toList());
        this.asyncComputations = CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).orTimeout(10L, TimeUnit.MINUTES).whenComplete((aVoid, throwable) -> {
            if (throwable != null) {
                log.warn("An error occured during initialisation of application", throwable);
            }
            this.listeners.forEach(listener -> listener.onExecutionFinished());
            this.executorService.shutdownNow();
        });
    }

    public void dispose() {
        if (this.asyncComputations != null) {
            this.asyncComputations.cancel(true);
        }
        this.executorService.shutdownNow();
    }
}

