/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.layertree;

import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelListener;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.PopupNodeProxy;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.layertree.LayerTree;
import com.vividsolutions.jump.workbench.ui.layertree.LayerTreeModel;
import com.vividsolutions.jump.workbench.ui.layertree.LayerTreeTransferHandler;
import com.vividsolutions.jump.workbench.ui.layertree.SearchableLayerTreeModelFilter;
import com.vividsolutions.jump.workbench.ui.layertree.TreeLayerExpandedPathCache;
import com.vividsolutions.jump.workbench.ui.layertree.TreeLayerNamePanelAsyncActionWorker;
import com.vividsolutions.jump.workbench.ui.layertree.TreeLayerSearchPanel;
import com.vividsolutions.jump.workbench.ui.layertree.TreeLayerSearchResultListener;
import com.vividsolutions.jump.workbench.ui.layertree.TreeUtil;
import com.vividsolutions.jump.workbench.ui.layertree.sublayervalues.CadLayerValue;
import com.vividsolutions.jump.workbench.ui.layertree.sublayervalues.ColorThemingValue;
import com.vividsolutions.jump.workbench.ui.plugin.ChangeCategoryPlugIn;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingManager;
import com.vividsolutions.jump.workbench.ui.style.SelectChangeStylesPlugIn;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeLayerNamePanel
extends JPanel
implements LayerNamePanel,
LayerNamePanelProxy,
PopupNodeProxy,
TreeLayerSearchResultListener {
    private static final Logger LOG = LoggerFactory.getLogger(TreeLayerNamePanel.class);
    private static final int MAXIMUM_PATHS_TO_EXPAND = 16;
    private final Map<Class<?>, JPopupMenu> nodeClassToPopupMenuMap = new HashMap();
    private final Map<Class<?>, JPopupMenu> nodeClassToPopupMenuMapBuildIn = new HashMap();
    private final BorderLayout borderLayout1 = new BorderLayout();
    private final JScrollPane scrollPane = new JScrollPane();
    private final LayerTree tree;
    private final TreeLayerExpandedPathCache expandedPathCache;
    private Object popupNode;
    private final List<LayerNamePanelListener> listeners = new ArrayList<LayerNamePanelListener>();
    private final LayerManagerProxy layerManagerProxy;
    private final SelectChangeStylesPlugIn selectChangeStylePlugIn;
    private final ChangeCategoryPlugIn changeCategoryPlugIn;
    private ActionListener digiLayerChangedListener;
    private TreeLayerSearchPanel searchComponent;
    private TreeLayerNamePanelAsyncActionWorker initializationWorker;

    public TreeLayerNamePanel(final WorkbenchContext workbenchContext, LayerManagerProxy layerManagerProxy, TreeModel treeModel, RenderingManager renderingManager) {
        this.layerManagerProxy = layerManagerProxy;
        this.selectChangeStylePlugIn = JUMPWorkbench.getBuiltInPlugIn(SelectChangeStylesPlugIn.class);
        this.changeCategoryPlugIn = JUMPWorkbench.getBuiltInPlugIn(ChangeCategoryPlugIn.class);
        this.tree = new LayerTree(this.scrollPane, layerManagerProxy, treeModel, true, true, true){

            @Override
            protected boolean editTreePath(TreePath tp2Edit) {
                if (tp2Edit == null) {
                    return false;
                }
                if (tp2Edit.getLastPathComponent() instanceof Layerable) {
                    try {
                        Layerable lyr = (Layerable)tp2Edit.getLastPathComponent();
                        return TreeLayerNamePanel.this.selectChangeStylePlugIn.showChangeStyleDialog(workbenchContext.createPlugInContext(), lyr);
                    }
                    catch (Exception ex) {
                        LOG.error("Exception when showing ChangeStyleDialog on doubleclick.", (Throwable)ex);
                        throw new RuntimeException("Exception when showing ChangeStyleDialog on doubleclick.", ex);
                    }
                }
                if (tp2Edit.getLastPathComponent() instanceof Category) {
                    try {
                        return TreeLayerNamePanel.this.changeCategoryPlugIn.execute(workbenchContext.createPlugInContext());
                    }
                    catch (Exception ex) {
                        LOG.error("Exception when showing ChangeCategoryDialog on doubleclick.", (Throwable)ex);
                        throw new RuntimeException("Exception when showing ChangeCategoryDialog on doubleclick.", ex);
                    }
                }
                return false;
            }
        };
        this.digiLayerChangedListener = e -> {
            if (this.tree != null) {
                this.tree.revalidate();
                this.tree.repaint();
            }
        };
        EditingPanel.instanceOf().addDigiLayerChangedListener(this.digiLayerChangedListener);
        this.tree.setBackground(this.getBackground());
        this.tree.setEditable(true);
        this.tree.setDragEnabled(true);
        this.tree.setDropMode(DropMode.USE_SELECTION);
        this.tree.setTransferHandler(new LayerTreeTransferHandler());
        layerManagerProxy.getLayerManager().addLayerListener(this.tree);
        renderingManager.getPanel().getViewport().addListener(this.tree);
        this.expandedPathCache = new TreeLayerExpandedPathCache(this.tree);
        this.tree.addTreeSelectionListener(e -> this.fireLayerSelectionChanged());
        this.tree.getModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                for (Object children : e.getChildren()) {
                    TreeUtil.visit(TreeLayerNamePanel.this.tree.getModel(), e.getTreePath().pathByAddingChild(children), path -> {
                        if (path.peek() instanceof ColorThemingValue || path.peek() instanceof CadLayerValue) {
                            return;
                        }
                        TreeLayerNamePanel.this.tree.makeVisible(new TreePath(path.toArray()));
                    });
                }
            }

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                TreeLayerNamePanel.this.tree_mouseReleased(e);
            }
        });
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LOG.warn("Error in jbInit()", (Throwable)ex);
        }
    }

    public void addPopupMenu(Class<?> nodeClass, JPopupMenu popupMenu, boolean bolBuildIn) {
        if (bolBuildIn) {
            this.nodeClassToPopupMenuMapBuildIn.put(nodeClass, popupMenu);
        } else {
            this.nodeClassToPopupMenuMap.put(nodeClass, popupMenu);
        }
    }

    private void jbInit() throws Exception {
        this.setBackground(Color.WHITE);
        this.setLayout(this.borderLayout1);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.getViewport().add(this.tree);
        this.add((Component)this.scrollPane, "Center");
        this.searchComponent = new TreeLayerSearchPanel(this.layerManagerProxy.getLayerManager());
        this.searchComponent.addTreeLayerSearchResultListener(this);
        this.add((Component)this.searchComponent, "North");
        this.initializationWorker = new TreeLayerNamePanelAsyncActionWorker();
        this.initializationWorker.addListener(this.searchComponent);
    }

    @Override
    public void startSearch() {
        this.initializationWorker.execute();
    }

    void tree_mouseReleased(MouseEvent e) {
        if (!SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        TreePath popupPath = this.tree.getPathForLocation(e.getX(), e.getY());
        if (popupPath == null) {
            return;
        }
        this.popupNode = popupPath.getLastPathComponent();
        if (!(e.isControlDown() || e.isShiftDown() || this.selectedNodes(Object.class).contains(this.popupNode))) {
            this.tree.getSelectionModel().clearSelection();
        }
        this.tree.getSelectionModel().addSelectionPath(popupPath);
        if (this.getPopupMenu(this.popupNode) != null) {
            this.getPopupMenu(this.popupNode).show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private JPopupMenu getPopupMenu(Object obj) {
        if (obj instanceof Category || obj instanceof Layerable) {
            if (this.getLayerManager().isBuildIn(obj)) {
                return (JPopupMenu)CollectionUtil.get(obj.getClass(), this.nodeClassToPopupMenuMapBuildIn);
            }
            return (JPopupMenu)CollectionUtil.get(obj.getClass(), this.nodeClassToPopupMenuMap);
        }
        return null;
    }

    @Override
    public Layer[] getSelectedLayers() {
        return TreeLayerNamePanel.selectedLayers(this);
    }

    @Override
    public Layer[] getSelectedLayers(boolean bolBuildIn) {
        Layer[] arrLy = TreeLayerNamePanel.selectedLayers(this);
        ArrayList<Layer> selectedNodes = new ArrayList<Layer>();
        for (Layer arrLy1 : arrLy) {
            if (arrLy1.isBuildIn() != bolBuildIn) continue;
            selectedNodes.add(arrLy1);
        }
        return selectedNodes.toArray(new Layer[0]);
    }

    public static Layer[] selectedLayers(LayerNamePanel layerNamePanel) {
        return layerNamePanel.selectedNodes(Layer.class).toArray(new Layer[0]);
    }

    @Override
    public Collection<Category> getSelectedCategories() {
        return this.selectedNodes(Category.class);
    }

    @Override
    public Collection<Category> getSelectedCategories(boolean bolBuildIn) {
        Iterator<Category> iNodes = this.selectedNodes(Category.class).iterator();
        ArrayList<Category> selectedNodes = new ArrayList<Category>();
        while (iNodes.hasNext()) {
            Category cat = iNodes.next();
            if (cat.isBuildIn() != bolBuildIn) continue;
            selectedNodes.add(cat);
        }
        return selectedNodes;
    }

    private void setSelectedLayers(Layerable[] layers) {
        this.tree.getSelectionModel().clearSelection();
        for (Layerable currLayer : layers) {
            this.addLayerable2Selection(currLayer, false);
        }
    }

    @Override
    public void dispose() {
        this.layerManagerProxy.getLayerManager().removeLayerListener(this.tree);
        EditingPanel.instanceOf().removeDigiLayerChangedListener(this.digiLayerChangedListener);
        this.initializationWorker.dispose();
        this.tree.dispose();
    }

    public JTree getTree() {
        return this.tree;
    }

    @Override
    public void addListener(LayerNamePanelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(LayerNamePanelListener listener) {
        this.listeners.remove(listener);
    }

    public void fireLayerSelectionChanged() {
        for (LayerNamePanelListener l : this.listeners) {
            l.layerSelectionChanged();
        }
    }

    @Override
    public LayerManager getLayerManager() {
        return this.layerManagerProxy.getLayerManager();
    }

    @Override
    public LayerNamePanel getLayerNamePanel() {
        return this;
    }

    @Override
    public Object getPopupNode() {
        return this.popupNode;
    }

    @Override
    public void clearSelection() {
        this.tree.getSelectionModel().clearSelection();
    }

    @Override
    public void addLayerable2Selection(Layerable layer, boolean bolCollapse) {
        this.tree.addSelectionPath(layer.getTreePath());
        if (bolCollapse) {
            this.tree.collapsePath(layer.getTreePath());
            this.tree.scrollPathToVisible(layer.getTreePath());
        }
    }

    public void treeLayerChanged(Layerable layer) {
        if (layer == null || layer.getCategory() == null) {
            return;
        }
        LayerEvent event = this.createLayerEvent(layer);
        this.tree.layerChanged(event);
    }

    public void collapseTree() {
        LayerManager lyMngr = (LayerManager)this.tree.getModel().getRoot();
        for (Category cat : lyMngr.getAllSubcategories()) {
            this.tree.collapsePath(cat.getTreePath());
        }
    }

    @Override
    public <T> Collection<T> selectedNodes(Class<T> c) {
        return this.tree.selectedNodes(c);
    }

    @Override
    public void treeLayerSearchPerformed() {
        List<TreePath> newPaths = this.expandedPathCache.updateCache();
        String searchValue = this.searchComponent.getText();
        if (searchValue == null || searchValue.isEmpty()) {
            this.expandedPathCache.clearCache();
            this.setDefaultEmptyTreeModel();
        } else {
            this.setFilteringTreeModel(searchValue);
        }
        newPaths.forEach(path -> this.tree.expandPath((TreePath)path));
    }

    private void setFilteringTreeModel(String searchValue) {
        SearchableLayerTreeModelFilter filter = new SearchableLayerTreeModelFilter(this.layerManagerProxy.getLayerManager(), searchValue);
        LayerTreeModel model = new LayerTreeModel(this.layerManagerProxy);
        model.addListFilter(filter);
        this.tree.setModel(model);
        if (filter.getLayersToDisplay().size() <= 16) {
            filter.getLayersToDisplay().forEach(layer -> this.tree.expandPath(layer.getCategory().getTreePath()));
        }
    }

    private void setDefaultEmptyTreeModel() {
        this.tree.setModel(new LayerTreeModel(this.layerManagerProxy));
    }

    private LayerEvent createLayerEvent(Layerable layer) {
        Category cat = layer.getCategory();
        return new LayerEvent(layer, LayerEventType.METADATA_CHANGED, cat, cat.treeIndexOf(layer));
    }
}

