/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.layertree;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import lombok.Generated;

public class TreeLayerExpandedPathCache {
    private List<TreePath> expandedPathCache = new ArrayList<TreePath>();
    private final JTree tree;

    protected void clearCache() {
        this.expandedPathCache = new ArrayList<TreePath>();
    }

    protected List<TreePath> updateCache() {
        this.iterateAndUpdateCacheByPath(new TreePath(this.tree.getModel().getRoot()));
        return this.expandedPathCache;
    }

    private void iterateAndUpdateCacheByPath(TreePath path) {
        if (!this.tree.isExpanded(path) && this.expandedPathCache.contains(path)) {
            this.expandedPathCache.remove(path);
        }
        if (this.tree.isVisible(path) && this.tree.isExpanded(path) && !this.expandedPathCache.contains(path)) {
            this.expandedPathCache.add(path);
        }
        TreeModel model = this.tree.getModel();
        Object node = path.getLastPathComponent();
        try {
            for (int i = 0; i < model.getChildCount(node); ++i) {
                TreePath pathChild = path.pathByAddingChild(model.getChild(node, i));
                this.iterateAndUpdateCacheByPath(pathChild);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Generated
    public TreeLayerExpandedPathCache(JTree tree) {
        this.tree = tree;
    }
}

