/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.layertree;

import com.vividsolutions.jump.workbench.ui.layertree.ClickableTreeCellRenderer;
import com.vividsolutions.jump.workbench.ui.layertree.sublayervalues.SubLayerValue;
import com.vividsolutions.jump.workbench.ui.renderer.style.AbstractCadRenderer;
import de.riwagis.icons.IconLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubLayerValueRenderer
extends JPanel
implements ListCellRenderer<SubLayerValue>,
ClickableTreeCellRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(SubLayerValueRenderer.class);
    private static final ImageIcon ICO_SUB_LAYER = IconLoader.svgIconSmall((String)"layer_geometry.svg");
    private static final Color TREE_SELECTION_FOREGROUND = UIManager.getColor("Tree.selectionForeground");
    private static final Color TREE_SELECTION_BACKGROUND = UIManager.getColor("Tree.selectionBackground");
    protected final JCheckBox checkBox = new JCheckBox();
    private final JLabel ll = new JLabel(ICO_SUB_LAYER);
    private final GridBagLayout gridBagLayout = new GridBagLayout();
    protected final JLabel label = new JLabel();
    private final transient ListCellRenderer<Object> defaultListCellRenderer = new DefaultListCellRenderer();
    private Font labelFont = new JLabel().getFont();

    public SubLayerValueRenderer() {
        try {
            this.labelFont = this.labelFont.deriveFont(2, this.labelFont.getSize());
            this.checkBox.setBorder(new EmptyBorder(1, 1, 1, 1));
            this.jbInit();
        }
        catch (Exception ex) {
            LOG.error(String.format("Error creating SubLayerValueRenderer: %s", ex.getMessage()), (Throwable)ex);
        }
    }

    public JLabel getLabel() {
        return this.label;
    }

    @Override
    public Rectangle getCheckBoxBounds() {
        int i = this.gridBagLayout.getConstraints((Component)this.checkBox).gridx;
        int x = 0;
        for (int j = 0; j < i; ++j) {
            x += this.getColumnWidth(j);
        }
        return new Rectangle(x, 0, this.getColumnWidth(i), 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getColumnWidth(int i) {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.validateTree();
        }
        return this.gridBagLayout.getLayoutDimensions()[0][i];
    }

    public void setCheckBoxVisible(boolean checkBoxVisible) {
        this.checkBox.setVisible(checkBoxVisible);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.validate();
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends SubLayerValue> list, SubLayerValue value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value == null) {
            return this.defaultListCellRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
        SubLayerValue slv = value;
        this.label.setText(slv.toString());
        this.setToolTipText(slv.toString());
        if (isSelected) {
            this.setOpaque(true);
            this.label.setForeground(list.getSelectionForeground());
            this.label.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
            this.setBackground(list.getSelectionBackground());
        } else {
            this.setOpaque(false);
            this.label.setForeground(list.getForeground());
            this.label.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.checkBox.setSelected(slv.isVisible());
        this.label.setFont(this.labelFont);
        return this;
    }

    private JList<SubLayerValue> list(JTree tree) {
        JList<SubLayerValue> list = new JList<SubLayerValue>();
        list.setForeground(tree.getForeground());
        list.setBackground(tree.getBackground());
        list.setSelectionForeground(TREE_SELECTION_FOREGROUND);
        list.setSelectionBackground(TREE_SELECTION_BACKGROUND);
        return list;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        SubLayerValue clv = (SubLayerValue)value;
        this.getListCellRendererComponent(this.list(tree), clv, -1, selected, hasFocus);
        if (this.label.getText().isEmpty()) {
            this.label.setText(AbstractCadRenderer.NO_LAYER);
        }
        if (selected) {
            this.setOpaque(true);
            this.label.setForeground(TREE_SELECTION_FOREGROUND);
            this.label.setBackground(TREE_SELECTION_BACKGROUND);
            this.setForeground(TREE_SELECTION_FOREGROUND);
            this.setBackground(TREE_SELECTION_BACKGROUND);
        } else {
            this.setOpaque(false);
            this.label.setForeground(tree.getForeground());
            this.label.setBackground(tree.getBackground());
            this.setForeground(tree.getForeground());
        }
        return this;
    }

    final void jbInit() throws Exception {
        this.checkBox.setVisible(false);
        this.setLayout(this.gridBagLayout);
        this.label.setOpaque(false);
        this.checkBox.setOpaque(false);
        this.add((Component)this.ll, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 2), 0, 0));
        this.add((Component)this.checkBox, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.add((Component)this.label, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
    }
}

