/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.layertree;

import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.ui.layertree.LayerTreeModelFilter;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

class SearchableLayerTreeModelFilter
implements LayerTreeModelFilter {
    private final LayerManager layerManager;
    private final String searchValue;
    private final Comparator<Layerable> nameComparator = Comparator.comparing(Layerable::getKey);
    private final Set<Layerable> layersToDisplay = new TreeSet<Layerable>(this.nameComparator);
    private final Set<Category> categoriesToDisplay = new HashSet<Category>();

    protected SearchableLayerTreeModelFilter(LayerManager layerManager, String searchValue) {
        this.layerManager = layerManager;
        this.searchValue = searchValue;
        this.initCategoryTree();
    }

    protected Set<Layerable> getLayersToDisplay() {
        return this.layersToDisplay;
    }

    private void initCategoryTree() {
        this.layerManager.getLayerables().forEach(lay -> {
            if (this.layerableContainsThemeWithResult((Layerable)lay)) {
                this.layersToDisplay.add((Layerable)lay);
            }
        });
        this.layerManager.getAllSubcategories().forEach(cat -> {
            if (this.categoryContainsResult((Category)cat)) {
                this.categoriesToDisplay.add((Category)cat);
                cat.getAllLayerables().forEach(lay -> this.layersToDisplay.add((Layerable)lay));
            }
        });
        this.layerManager.getAllSubcategories().forEach(cat -> {
            if (this.catContainsLayerableWithResult((Category)cat)) {
                this.categoriesToDisplay.add((Category)cat);
            }
        });
    }

    @Override
    public boolean doDisplay(Object element) {
        if (element instanceof Category) {
            Category category = (Category)element;
            return this.categoriesToDisplay.contains(category);
        }
        if (element instanceof Layerable) {
            Layerable layerable = (Layerable)element;
            return this.layersToDisplay.contains(layerable);
        }
        return true;
    }

    private boolean catContainsLayerableWithResult(Category cat) {
        for (Layerable layerable : cat.getAllLayerables()) {
            if (!this.layersToDisplay.contains(layerable)) continue;
            return true;
        }
        for (Category subCat : cat.getAllSubcategories()) {
            if (!this.categoryContainsResult(cat) && !this.catContainsLayerableWithResult(subCat)) continue;
            return true;
        }
        return false;
    }

    private boolean layerableContainsThemeWithResult(Layerable lay) {
        return lay.displayedTreeNodeContains(this.searchValue);
    }

    private boolean categoryContainsResult(Category cat) {
        return StringUtils.containsIgnoreCase((CharSequence)cat.getName(), (CharSequence)this.searchValue);
    }
}

