/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.layertree;

import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.WithScale;

public class RendererUtil {
    public static boolean isValidForScale(Layerable layerable, WithScale withScale) {
        return withScale == null && layerable.withinVisibleScaleRange() || withScale != null && layerable.getStyleCollectionByScale(withScale.getScale()) != null;
    }

    public static LayerStyleCollection getValidStyleCollection(Layer layer, WithScale withScale) {
        if (!RendererUtil.isValidForScale(layer, withScale)) {
            return null;
        }
        if (withScale == null) {
            return layer.getValidLayerStyleCollection();
        }
        return (LayerStyleCollection)layer.getStyleCollectionByScale(withScale.getScale());
    }

    public static boolean isVisibleOnScreen(Layerable layerable, WithScale withScale) {
        if (layerable.getCategory() == null) {
            return false;
        }
        if (!layerable.isVisible()) {
            return false;
        }
        if (!RendererUtil.isValidForScale(layerable, withScale)) {
            return false;
        }
        return layerable.getCategory().isVisibleOnScreen();
    }

    private RendererUtil() {
    }
}

