/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.layertree;

import com.vividsolutions.jump.workbench.model.CadLayer;
import com.vividsolutions.jump.workbench.model.DimLayer;
import com.vividsolutions.jump.workbench.model.LabelLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.WithScale;
import com.vividsolutions.jump.workbench.ui.layertree.RendererUtil;
import com.vividsolutions.jump.workbench.ui.renderer.style.DefaultLegendLabelRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.LegendLabelRenderer;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.function.BiFunction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class LegendLabelPanel
extends JLabel {
    private static final BiFunction<Layerable, WithScale, Icon> DEFAULT_IMAGE_PROVIDER = (layer, scale) -> DefaultLegendLabelRenderer.RASTER_LABEL;
    private static final Map<Class<?>, BiFunction<Layerable, WithScale, Icon>> imageForLayerType = Map.ofEntries(Map.entry(DimLayer.class, (ly, scale) -> DefaultLegendLabelRenderer.DIMENSION_LABEL), Map.entry(RedlineLayer.class, (ly, scale) -> DefaultLegendLabelRenderer.REDLINE_LABEL), Map.entry(CadLayer.class, (ly, scale) -> DefaultLegendLabelRenderer.CAD_LABEL), Map.entry(Layer.class, (ly, scale) -> LegendLabelPanel.selectLayerIcon(ly, scale)), Map.entry(LabelLayer.class, (ly, scale) -> LegendLabelPanel.selectLayerIcon(ly, scale)));
    private WithScale withScale = null;

    public LegendLabelPanel() {
        this.setIconImage(DefaultLegendLabelRenderer.RASTER_LABEL);
    }

    public void setWithScale(WithScale withScale) {
        this.withScale = withScale;
    }

    public void setImageForLayerable(Layerable ly) {
        Icon icon = imageForLayerType.getOrDefault(ly.getClass(), DEFAULT_IMAGE_PROVIDER).apply(ly, this.withScale);
        this.setIconImage(icon);
    }

    @Deprecated
    public void setImage(BufferedImage image) {
        ImageIcon icon = new ImageIcon(image);
        this.setIconImage(icon);
    }

    public void setIconImage(Icon icon) {
        this.setIcon(icon);
        this.setSizeFromImage(icon.getIconWidth(), icon.getIconHeight());
    }

    private void setSizeFromImage(int width, int height) {
        Dimension size = new Dimension(width, height);
        this.setMaximumSize(size);
        this.setMinimumSize(size);
        this.setPreferredSize(size);
        this.setSize(size);
    }

    private static Icon selectLayerIcon(Layerable ly, WithScale scale) {
        if (!RendererUtil.isValidForScale(ly, scale)) {
            return DefaultLegendLabelRenderer.getEmptyIcon();
        }
        Layer layer = (Layer)ly;
        LayerStyleCollection styleCollection = RendererUtil.getValidStyleCollection(layer, scale);
        BasicStyleModel styleModel = styleCollection.getBasicStyle();
        if (!styleModel.isEnabled()) {
            return DefaultLegendLabelRenderer.THEMING_LABEL;
        }
        LegendLabelRenderer renderer = (LegendLabelRenderer)styleModel.getIntelligence();
        return renderer.getLegendLabel(styleCollection);
    }
}

