/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.layertree;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.HasVisibility;
import com.vividsolutions.jump.workbench.model.LabelLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.ui.layertree.LayerTree;
import com.vividsolutions.jump.workbench.ui.layertree.LayerTreeTransferable;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.LoadRedlineLayerPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.RedlineLayerUtils;
import com.vividsolutions.jump.workbench.ui.plugin.shapefile.ShapefileUtils;
import de.riwagis.util.gui.ErrorBox;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.Component;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;

public class LayerTreeTransferHandler
extends TransferHandler {
    private static final double ROOTCAT_DROPLOCATION_WIDTH = 15.0;

    LayerTreeTransferHandler() {
    }

    public static final List<HasVisibility> createTransferData(JTree lyTree) {
        TreePath[] arrTreeSelection;
        ArrayList<HasVisibility> lstEntries = new ArrayList<HasVisibility>();
        for (TreePath path : arrTreeSelection = lyTree.getSelectionPaths()) {
            Object obj = path.getLastPathComponent();
            if (!(obj instanceof Category) && !(obj instanceof Layerable)) continue;
            lstEntries.add((HasVisibility)obj);
        }
        return lstEntries;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        for (DataFlavor flavor : support.getDataFlavors()) {
            if (flavor.equals(LayerTreeTransferable.LAYERTREE_FLAVOR)) {
                Category cat2Drop;
                if (support.getDropAction() != 2) continue;
                Component c = support.getComponent();
                LayerTree targetTree = (LayerTree)c;
                TreePath tp2Drop = targetTree.getDropLocation().getPath();
                if (targetTree.getDropLocation().getDropPoint().getX() < 15.0) {
                    tp2Drop = null;
                }
                boolean dropInRootCat = false;
                if (tp2Drop != null) {
                    if (!(tp2Drop.getLastPathComponent() instanceof Category)) {
                        return false;
                    }
                    cat2Drop = (Category)tp2Drop.getLastPathComponent();
                } else {
                    cat2Drop = targetTree.getLayerManager().getRootCatLocal();
                    dropInRootCat = true;
                }
                try {
                    Collection layerTreeEntries = (Collection)support.getTransferable().getTransferData(LayerTreeTransferable.LAYERTREE_FLAVOR);
                    for (Object objTree : layerTreeEntries) {
                        LabelLayer labelLayer;
                        String labelLayerKey;
                        if (objTree instanceof Category) {
                            Category catTree = (Category)objTree;
                            if (cat2Drop == catTree) {
                                return false;
                            }
                            catTree.setParentCategory(cat2Drop);
                            continue;
                        }
                        if (!(objTree instanceof Layerable)) continue;
                        if (dropInRootCat) {
                            return false;
                        }
                        Layerable lyTree = (Layerable)objTree;
                        if (lyTree.getLayerManager() != targetTree.getLayerManager()) {
                            lyTree.setName(targetTree.getLayerManager().uniqueLayerName(lyTree.getName()));
                            lyTree.setKey(targetTree.getLayerManager().uniqueLayerKey(lyTree.getKey()));
                        }
                        if (lyTree instanceof Layer && StringUtils.isNotEmpty((CharSequence)(labelLayerKey = ((Layer)lyTree).getLabelLayerKey())) && (labelLayer = ((Layer)lyTree).getLabelLayer()) != null && labelLayer.getLayerManager() != targetTree.getLayerManager()) {
                            labelLayer.setName(targetTree.getLayerManager().uniqueLayerName(labelLayer.getName()));
                            labelLayer.setKey(targetTree.getLayerManager().uniqueLayerKey(labelLayer.getKey()));
                            labelLayer.setCategory(cat2Drop);
                        }
                        lyTree.setCategory(cat2Drop);
                    }
                    return true;
                }
                catch (Exception e) {
                    ErrorBox.showException((Window)JUMPWorkbench.getFrame(), (String)I18N.get("common.error"), (Throwable)e);
                    return false;
                }
            }
            if (!flavor.equals(DataFlavor.javaFileListFlavor)) continue;
            if (support.getDropAction() != 2) {
                return false;
            }
            WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)WorkbenchContext.getFrame(), (String)I18N.get("common.wait"));
            try {
                List files = (List)support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                for (File file : files) {
                    Runnable work = () -> {
                        try {
                            if (ShapefileUtils.SHP_FILE_FILTER.accept(file)) {
                                ShapefileUtils.addShapeFiles(JUMPWorkbench.getContext().createPlugInContext(), Collections.singletonList(file), "ISO-8859-1");
                            } else if (RedlineLayerUtils.RLY_FILE_FILTER.accept(file)) {
                                LoadRedlineLayerPlugIn.loadRedlineLayers(JUMPWorkbench.getContext().createPlugInContext(), new File[]{file});
                            }
                        }
                        catch (Exception e) {
                            dlgWait.setError(e);
                        }
                    };
                    dlgWait.addWorkToDo(work);
                }
            }
            catch (Exception e) {
                dlgWait.setError(e);
            }
            dlgWait.setVisible(true);
            if (dlgWait.getError() != null) {
                ErrorBox.showException((Window)JUMPWorkbench.getFrame(), (String)I18N.get("common.error"), (Throwable)dlgWait.getError());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        Component c = support.getComponent();
        if (!(c instanceof LayerTree)) {
            return false;
        }
        if (!support.isDrop()) {
            return false;
        }
        for (DataFlavor flavor : support.getDataFlavors()) {
            if (flavor.equals(LayerTreeTransferable.LAYERTREE_FLAVOR)) {
                try {
                    JTree.DropLocation dl;
                    TreePath dropPath;
                    Collection layerTreeEntries = (Collection)support.getTransferable().getTransferData(flavor);
                    if (layerTreeEntries.isEmpty()) {
                        return false;
                    }
                    boolean onlyRedline = !layerTreeEntries.isEmpty();
                    for (Object objTree : layerTreeEntries) {
                        if (objTree instanceof RedlineLayer) continue;
                        onlyRedline = false;
                        break;
                    }
                    if ((dropPath = (dl = (JTree.DropLocation)support.getDropLocation()).getPath()) != null) {
                        Object dropNode = dropPath.getLastPathComponent();
                        if (!(dropNode instanceof Category)) {
                            return false;
                        }
                        if (!onlyRedline && ((Category)dropNode).isBuildIn()) {
                            return false;
                        }
                    }
                    boolean catFound = false;
                    boolean layerFound = false;
                    for (Object objTree : layerTreeEntries) {
                        if (dropPath != null) {
                            if (dl.getDropPoint().getX() < 15.0) {
                                if (objTree instanceof Category && !((Category)objTree).isBuildIn()) {
                                    int indexOfChild = ((LayerTree)c).getModel().getIndexOfChild(((LayerTree)c).getLayerManager().getRootCatLocal(), objTree);
                                    return indexOfChild == -1;
                                }
                                return false;
                            }
                            for (Object dropPathObject : dropPath.getPath()) {
                                if (dropPathObject != objTree) continue;
                                return false;
                            }
                            int indexOfChild = ((LayerTree)c).getModel().getIndexOfChild(dropPath.getLastPathComponent(), objTree);
                            if (indexOfChild != -1) {
                                return false;
                            }
                        }
                        if (objTree instanceof Category) {
                            if (catFound) {
                                return false;
                            }
                            Category catTree = (Category)objTree;
                            catFound = true;
                            if (catTree.isBuildIn()) {
                                return false;
                            }
                            if (!layerFound) continue;
                            return false;
                        }
                        if (objTree instanceof Layerable) {
                            Layerable lyTree = (Layerable)objTree;
                            layerFound = true;
                            if (dropPath == null) {
                                return false;
                            }
                            if (lyTree.isBuildIn() && !(lyTree instanceof RedlineLayer)) {
                                return false;
                            }
                            if (lyTree instanceof LabelLayer) {
                                Object dropNode = dropPath.getLastPathComponent();
                                return lyTree.getLayerManager() == ((Category)dropNode).getLayerManager();
                            }
                            if (!catFound) continue;
                            return false;
                        }
                        return false;
                    }
                    return true;
                }
                catch (UnsupportedFlavorException | IOException ufe) {
                    return false;
                }
            }
            if (!flavor.equals(DataFlavor.javaFileListFlavor)) continue;
            try {
                if (support.getDropAction() != 2) {
                    return false;
                }
                JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
                TreePath dropPath = dl.getPath();
                if (dropPath == null) {
                    return false;
                }
                Object dropNode = dropPath.getLastPathComponent();
                if (!(dropNode instanceof Category)) {
                    return false;
                }
                List files = (List)support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                if (files == null || files.isEmpty()) {
                    return false;
                }
                for (File file : files) {
                    if (file.isDirectory() || !file.exists()) {
                        return false;
                    }
                    if (ShapefileUtils.SHP_FILE_FILTER.accept(file)) {
                        if (!((Category)dropNode).isBuildIn()) continue;
                        return false;
                    }
                    if (RedlineLayerUtils.RLY_FILE_FILTER.accept(file)) continue;
                    return false;
                }
                return true;
            }
            catch (InvalidDnDOperationException e) {
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        List<Object> lstEntries = new ArrayList();
        if (c instanceof JTree) {
            JTree lyTree = (JTree)c;
            lstEntries = LayerTreeTransferHandler.createTransferData(lyTree);
        }
        return new LayerTreeTransferable(lstEntries);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }
}

