/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.layertree;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.SimpleTreeModel;
import com.vividsolutions.jump.workbench.COpt;
import com.vividsolutions.jump.workbench.model.CadLayer;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.model.WithScale;
import com.vividsolutions.jump.workbench.ui.layertree.LayerTreeModelFilter;
import com.vividsolutions.jump.workbench.ui.layertree.sublayervalues.CadLayerValue;
import com.vividsolutions.jump.workbench.ui.layertree.sublayervalues.ColorThemingValue;
import com.vividsolutions.jump.workbench.ui.layertree.sublayervalues.SubLayerValue;
import com.vividsolutions.jump.workbench.ui.layertree.sublayervalues.WMSLayerValue;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.theming.ThemeRetriever;
import de.riwagis.riwajump.model.style.CadStyleModel;
import de.riwagis.riwajump.model.style.ColorThemingStyleModel;
import de.riwagis.riwajump.model.style.WMSStyleModel;
import de.riwagis.riwajump.model.style.theme.ThemeModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreePath;
import org.locationtech.jts.util.Assert;

public class LayerTreeModel
extends SimpleTreeModel {
    private static final int MAX_THEMES_IN_TREE = 50;
    private final List<LayerTreeModelFilter> lstFilters = new ArrayList<LayerTreeModelFilter>();
    private WithScale withScale = null;

    public LayerTreeModel(LayerManagerProxy layerManagerProxy) {
        super(layerManagerProxy.getLayerManager());
        this.withScale = layerManagerProxy.getLayerManager().getTask();
    }

    public void setWithScale(WithScale withScale) {
        if (withScale.getScaleType() != 1) {
            throw new IllegalArgumentException("Should never reach here. Wrong type of WithScale. MAP_IN_PIXEL_TO_REALITY_IN_UNITS is needed.");
        }
        this.withScale = withScale;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        for (int i = 0; i < this.getChildCount(parent); ++i) {
            if (!(child instanceof SubLayerValue) || !(this.getChild(parent, i) instanceof SubLayerValue) || !this.getChild(parent, i).equals(child)) continue;
            return i;
        }
        return super.getIndexOfChild(parent, child);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<?> getChildren(Object parent) {
        WMSStyleModel wmsStyle;
        CadStyleModel cadStyle;
        StyleCollection sCol;
        if (parent instanceof LayerManager) {
            return this.filterChildren(((LayerManager)parent).getSubcategories());
        }
        if (parent instanceof Category) {
            List<Object> lstChildren = ((Category)parent).getChildren();
            if (COpt.VIEWER) {
                ArrayList<Object> lstChildren4Loop = new ArrayList<Object>(lstChildren);
                for (Object e : lstChildren4Loop) {
                    if (!(e instanceof Layerable) || ((Layerable)e).isVisibleInViewerTree()) continue;
                    lstChildren.remove(e);
                }
            }
            return this.filterChildren(lstChildren);
        }
        if (parent instanceof CadLayer && (sCol = ((Layer)parent).getStyleCollectionByScale(this.withScale.getScale())) != null && (cadStyle = sCol.getStyle(CadStyleModel.class)) != null && !cadStyle.isLoadAllLayers()) {
            ArrayList<CadLayerValue> drawingLayers = new ArrayList<CadLayerValue>();
            for (String strDrawingLayer : cadStyle.getMapLayerID().keySet()) {
                drawingLayers.add(new CadLayerValue(strDrawingLayer, (Layer)parent, cadStyle));
            }
            Collections.sort(drawingLayers);
            return this.filterChildren(drawingLayers);
        }
        if (parent instanceof WMSLayer && (sCol = ((WMSLayer)parent).getStyleCollectionByScale(this.withScale.getScale())) != null && (wmsStyle = sCol.getStyle(WMSStyleModel.class)) != null && !wmsStyle.isHideWmsLayers()) {
            ArrayList<WMSLayerValue> wmsLayers = new ArrayList<WMSLayerValue>();
            for (String strWMSLayer : wmsStyle.getLstLayerNames()) {
                wmsLayers.add(new WMSLayerValue(strWMSLayer, (WMSLayer)parent, wmsStyle));
            }
            Collections.sort(wmsLayers);
            return this.filterChildren(wmsLayers);
        }
        if (parent instanceof Layer && (sCol = (LayerStyleCollection)((Layer)parent).getStyleCollectionByScale(this.withScale.getScale())) != null && ((LayerStyleCollection)sCol).getBasicStyle() != null && !((LayerStyleCollection)sCol).getBasicStyle().isEnabled()) {
            ColorThemingStyleModel thStyle = ColorThemingRenderer.get((LayerStyleCollection)sCol);
            ArrayList<ColorThemingValue> colorThemingValues = new ArrayList<ColorThemingValue>();
            boolean bl = false;
            ThemeRetriever retriever = (ThemeRetriever)thStyle.getThemeSource().getIntelligence();
            Collection<ThemeModel> themes = retriever.getThemesOrEmptyOnError((Layer)parent);
            for (ThemeModel theme : themes) {
                ColorThemingValue ctv;
                void var5_14;
                Object key = theme.getKey();
                if (++var5_14 > 50) {
                    colorThemingValues.add(new ColorThemingValue(key, (Layer)parent, theme.getStyle(), "..."));
                    break;
                }
                String strLabel = theme.getLabel();
                if (strLabel == null && key != null) {
                    strLabel = key.toString();
                }
                int index = 0;
                Iterator iCTV = colorThemingValues.iterator();
                while (iCTV.hasNext() && strLabel.compareToIgnoreCase((ctv = (ColorThemingValue)iCTV.next()).toString()) >= 0) {
                    ++index;
                }
                colorThemingValues.add(index, new ColorThemingValue(key, (Layer)parent, theme.getStyle(), strLabel));
            }
            String strDefaultLbl = thStyle.getDefaultLabel() == null || thStyle.getDefaultLabel().length() == 0 ? I18N.get("model.LayerTreeModel.default") : thStyle.getDefaultLabel();
            if (thStyle.isUseElseFilter()) {
                colorThemingValues.add(new ColorThemingValue(null, (Layer)parent, thStyle.getDefaultStyle(), strDefaultLbl));
            }
            return this.filterChildren(colorThemingValues);
        }
        if (parent instanceof SubLayerValue) {
            return Collections.EMPTY_LIST;
        }
        if (parent instanceof Layerable) {
            return new ArrayList();
        }
        Assert.shouldNeverReachHere((String)parent.getClass().getName());
        return null;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        if (path.getLastPathComponent() instanceof Layerable) {
            ((Layerable)path.getLastPathComponent()).setName((String)newValue);
        } else if (path.getLastPathComponent() instanceof Category) {
            ((Category)path.getLastPathComponent()).setName((String)newValue);
        } else {
            Assert.shouldNeverReachHere();
        }
    }

    public void addListFilter(LayerTreeModelFilter filt) {
        if (!this.lstFilters.contains(filt)) {
            this.lstFilters.add(filt);
        }
    }

    public void removeListFilter(LayerTreeModelFilter filt) {
        this.lstFilters.remove(filt);
    }

    private List<?> filterChildren(List<?> lstChildren) {
        for (LayerTreeModelFilter filt : this.lstFilters) {
            ArrayList filteredChildren = new ArrayList();
            for (Object element : lstChildren) {
                if (filt.doDisplay(element)) continue;
                filteredChildren.add(element);
            }
            lstChildren.removeAll(filteredChildren);
        }
        return lstChildren;
    }
}

