/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.layertree;

import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.WithScale;
import com.vividsolutions.jump.workbench.ui.layertree.CategoryNameRenderer;
import com.vividsolutions.jump.workbench.ui.layertree.ColorThemingTreeRenderer;
import com.vividsolutions.jump.workbench.ui.layertree.LayerNameRenderer;
import com.vividsolutions.jump.workbench.ui.layertree.Root;
import com.vividsolutions.jump.workbench.ui.layertree.SubLayerValueRenderer;
import com.vividsolutions.jump.workbench.ui.layertree.sublayervalues.ColorThemingValue;
import com.vividsolutions.jump.workbench.ui.layertree.sublayervalues.SubLayerValue;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import org.locationtech.jts.util.Assert;

public class LayerTreeCellRenderer
implements TreeCellRenderer {
    private final LayerNameRenderer layerNameRenderer = new LayerNameRenderer(LayerNameRenderer.Style.MULIPLE_ROWS);
    private final ColorThemingTreeRenderer colorThemingRenderer = new ColorThemingTreeRenderer();
    private final SubLayerValueRenderer subLayerValueRenderer = new SubLayerValueRenderer();
    private final JLabel rootRendererComponent = new JLabel("Root");
    private final CategoryNameRenderer categoryRenderer = new CategoryNameRenderer();

    public LayerTreeCellRenderer() {
        this(true, true, false, false);
    }

    public LayerTreeCellRenderer(boolean checkboxVisible, boolean indicateEditable, boolean renderLayerState, boolean renderSubCategory) {
        this.layerNameRenderer.setRenderLayerStates(renderLayerState);
        this.layerNameRenderer.setRenderSubCategory(renderSubCategory);
        this.layerNameRenderer.setCheckBoxVisible(checkboxVisible);
        this.layerNameRenderer.setIndicatingEditability(indicateEditable);
        this.colorThemingRenderer.setCheckBoxVisible(checkboxVisible);
        this.subLayerValueRenderer.setCheckBoxVisible(checkboxVisible);
        this.categoryRenderer.setCheckBoxVisible(checkboxVisible);
        this.categoryRenderer.setRenderLayerStates(renderLayerState);
    }

    public LayerNameRenderer getLayerNameRenderer() {
        return this.layerNameRenderer;
    }

    public ColorThemingTreeRenderer getColorThemingRenderer() {
        return this.colorThemingRenderer;
    }

    public SubLayerValueRenderer getSubLayerValueRenderer() {
        return this.subLayerValueRenderer;
    }

    public CategoryNameRenderer getCategoryNameRenderer() {
        return this.categoryRenderer;
    }

    public void setWithScale(WithScale withScale) {
        this.categoryRenderer.setWithScale(withScale);
        this.layerNameRenderer.setWithScale(withScale);
        this.colorThemingRenderer.setWithScale(withScale);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Object node = value;
        if (node instanceof Root) {
            return this.rootRendererComponent;
        }
        if (node instanceof Category) {
            return this.categoryRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
        if (node instanceof Layerable) {
            this.layerNameRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            return this.layerNameRenderer;
        }
        if (node instanceof ColorThemingValue) {
            this.colorThemingRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            return this.colorThemingRenderer;
        }
        if (node instanceof SubLayerValue) {
            this.subLayerValueRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            return this.subLayerValueRenderer;
        }
        if (node instanceof LayerManager) {
            return new JLabel(((LayerManager)node).getTask().getName());
        }
        Assert.shouldNeverReachHere((String)node.getClass().toString());
        return null;
    }

    public void setRenderPriority(boolean boolRenderPriority) {
        this.layerNameRenderer.setRenderPriority(boolRenderPriority);
    }

    public boolean isRenderPriority() {
        return this.layerNameRenderer.isRenderPriority();
    }

    public boolean isRenderErrors() {
        return this.layerNameRenderer.isRenderErrors();
    }

    public void setRenderErrors(boolean bolRenderErrors) {
        this.layerNameRenderer.setRenderErrors(bolRenderErrors);
        this.categoryRenderer.setRenderErrors(bolRenderErrors);
    }
}

