/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.layertree;

import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.model.AbstractLayerable;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.CategoryEventType;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.ViewportListener;
import com.vividsolutions.jump.workbench.ui.components.menutree.AnimatedWidthTree;
import com.vividsolutions.jump.workbench.ui.layertree.ClickableTreeCellRenderer;
import com.vividsolutions.jump.workbench.ui.layertree.FirableTreeModelWrapper;
import com.vividsolutions.jump.workbench.ui.layertree.LayerTreeCellEditor;
import com.vividsolutions.jump.workbench.ui.layertree.LayerTreeCellRenderer;
import com.vividsolutions.jump.workbench.ui.layertree.sublayervalues.ColorThemingValue;
import com.vividsolutions.jump.workbench.ui.layertree.sublayervalues.SubLayerValue;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import de.riwagis.icons.IconLoader;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.locationtech.jts.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayerTree
extends AnimatedWidthTree
implements ViewportListener,
LayerListener {
    public static final String GROUP_VISIBLE_WITH_LAYER = "GROUP_VISI_LAYER";
    private static final ImageIcon iconExpanded = IconLoader.svgIcon((String)"show_tree_expanded.svg", (int)6);
    private static final ImageIcon iconCollapsed = IconLoader.svgIcon((String)"show_next_gray.svg", (int)8);
    private static final Logger LOG = LoggerFactory.getLogger(LayerTree.class);
    private final LayerManagerProxy layerManagerProxy;
    private final LayerTreeCellRenderer layerTreeCellRenderer;
    private final Blackboard pBB;
    private FirableTreeModelWrapper firableTreeModelWrapper = null;
    private final TreeCellEditor treeCellEditor;
    private Collection<Object> selectionArchive = new ArrayList<Object>();
    private TimerTask delayedAction = null;
    private final Timer delayedActionTimer = new Timer("LayerTree_delayedAction");
    private final boolean checkboxVisible;

    public LayerTree(JScrollPane scrollPane, LayerManagerProxy layerManagerProxy, TreeModel treeModel, boolean checkboxVisible, boolean indicateEditable, boolean renderLayerState) {
        super(scrollPane, false, iconExpanded, iconCollapsed, 6);
        scrollPane.getVerticalScrollBar().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SwingUtilities.invokeLater(() -> {
                    try {
                        LayerTree.this.reactivateUI();
                    }
                    catch (Exception e1) {
                        LOG.error(e1.getLocalizedMessage(), (Throwable)e1);
                    }
                });
            }
        });
        this.layerManagerProxy = layerManagerProxy;
        this.checkboxVisible = checkboxVisible;
        this.setModel(treeModel);
        this.treeCellEditor = new LayerTreeCellEditor(this);
        this.setCellEditor(this.treeCellEditor);
        this.setInvokesStopCellEditing(true);
        this.layerTreeCellRenderer = new LayerTreeCellRenderer(checkboxVisible, indicateEditable, renderLayerState, false);
        this.layerTreeCellRenderer.setRenderErrors(true);
        this.setCellRenderer(this.layerTreeCellRenderer);
        this.setRootVisible(false);
        this.setToggleClickCount(2);
        this.setRowHeight(-1);
        this.setShowsRootHandles(true);
        this.pBB = PersistentBlackboardPlugIn.get();
        this.setMaximumSize(new Dimension());
        this.getSelectionModel().setSelectionMode(4);
        this.addTreeSelectionListener(e -> {
            this.selectionArchive = new ArrayList<Object>(this.selectedNodes(Object.class));
        });
        this.addDefaultMouseListeners();
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TreePath[] selPaths;
                if (e.getKeyCode() == 113 && (selPaths = LayerTree.this.getSelectionPaths()).length == 1 && LayerTree.this.isEditable() && LayerTree.this.editTreePath(selPaths[0])) {
                    e.consume();
                }
            }
        });
    }

    @Override
    public boolean isPathEditable(TreePath path) {
        if (!this.isEditable()) {
            return false;
        }
        return path.getLastPathComponent() instanceof Layerable || path.getLastPathComponent() instanceof Category;
    }

    @Override
    public boolean hasBeenExpanded(TreePath path) {
        return super.hasBeenExpanded(path) || !this.getModel().isLeaf(path.getLastPathComponent());
    }

    @Override
    public void zoomChanged(Viewport vPort) {
        SwingUtilities.invokeLater(new Runnable(){

            private void refreshLayers(TreePath tp) {
                if (tp.getLastPathComponent() instanceof Category) {
                    Category cat = (Category)tp.getLastPathComponent();
                    Enumeration<TreePath> enumExpanded = LayerTree.this.getExpandedDescendants(tp);
                    if (enumExpanded != null) {
                        while (enumExpanded.hasMoreElements()) {
                            this.refreshLayers(enumExpanded.nextElement());
                        }
                    }
                    List<Layerable> lstLy = cat.getLayerables();
                    for (Layerable ly : lstLy) {
                        TreePath tpLy = ly.getTreePath();
                        boolean expanded = LayerTree.this.isExpanded(tpLy);
                        TreeModelEvent treeModelEventLy = new TreeModelEvent((Object)this, tpLy);
                        LayerTree.this.firableTreeModelWrapper.fireTreeStructureChanged(treeModelEventLy);
                        if (!expanded) continue;
                        SwingUtilities.invokeLater(() -> LayerTree.this.expandPath(tpLy));
                    }
                }
            }

            @Override
            public void run() {
                LayerTree.this.repaint();
                Enumeration<TreePath> enumExpanded = LayerTree.this.getExpandedDescendants(new TreePath(new Object[]{LayerTree.this.treeModel.getRoot()}));
                if (enumExpanded != null) {
                    while (enumExpanded.hasMoreElements()) {
                        this.refreshLayers(enumExpanded.nextElement());
                    }
                }
            }
        });
    }

    private Runnable handleCheckBoxClick(MouseEvent e, Collection<Object> lstNodes) {
        JPanel renderer;
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return null;
        }
        TreePath path = this.getPathForLocation(e.getX(), e.getY());
        if (path == null) {
            return null;
        }
        Object node = path.getLastPathComponent();
        if (node instanceof Layerable) {
            renderer = this.layerTreeCellRenderer.getLayerNameRenderer();
        } else if (node instanceof Category) {
            renderer = this.layerTreeCellRenderer.getCategoryNameRenderer();
        } else if (node instanceof ColorThemingValue) {
            renderer = this.layerTreeCellRenderer.getColorThemingRenderer();
        } else if (node instanceof SubLayerValue) {
            renderer = this.layerTreeCellRenderer.getSubLayerValueRenderer();
        } else {
            return null;
        }
        if (!this.wasCheckBoxHit(e, path, (ClickableTreeCellRenderer)((Object)renderer))) {
            return null;
        }
        return () -> {
            if (!lstNodes.contains(node)) {
                lstNodes.clear();
                lstNodes.add(node);
                this.getSelectionModel().clearSelection();
            }
            boolean bolVisible = true;
            if (node instanceof Layerable) {
                bolVisible = !((Layerable)node).isVisible();
            } else if (node instanceof Category) {
                bolVisible = !((Category)node).isVisible();
            } else if (node instanceof SubLayerValue) {
                bolVisible = !((SubLayerValue)node).isVisible();
            }
            boolean bolGroupVisibleWithLayer = this.pBB.get(GROUP_VISIBLE_WITH_LAYER, true);
            for (Object tmpNode : lstNodes) {
                if (tmpNode instanceof Layerable) {
                    Layerable layerable = (Layerable)tmpNode;
                    if (bolVisible && bolGroupVisibleWithLayer) {
                        layerable.setVisibleOnScreen();
                    } else {
                        layerable.setVisible(bolVisible);
                    }
                }
                if (tmpNode instanceof Category) {
                    Category cat = (Category)tmpNode;
                    cat.setVisible(bolVisible);
                }
                if (!(tmpNode instanceof SubLayerValue)) continue;
                SubLayerValue ctv = (SubLayerValue)tmpNode;
                boolean bolSuccess = ctv.setVisible(bolVisible);
                AbstractLayerable ly = ctv.getLayer();
                if (!bolSuccess || !bolGroupVisibleWithLayer || !bolVisible || ly.isVisibleOnScreen()) continue;
                ly.setVisibleOnScreen();
            }
            this.revalidate();
            this.repaint();
        };
    }

    private boolean wasCheckBoxHit(MouseEvent e, TreePath path, ClickableTreeCellRenderer renderer) {
        Point layerNodeLocation = this.getUI().getPathBounds(this, path).getLocation();
        renderer.getTreeCellRendererComponent(this, path.getLastPathComponent(), false, false, false, 0, false);
        Rectangle checkBoxBounds = renderer.getCheckBoxBounds();
        checkBoxBounds.translate((int)layerNodeLocation.getX(), (int)layerNodeLocation.getY());
        return checkBoxBounds.contains(e.getPoint());
    }

    public <T> Collection<T> selectedNodes(Class<T> c) {
        return LayerTree.selectedNodes(c, this);
    }

    public static <T> Collection<T> selectedNodes(Class<T> c, JTree tree) {
        ArrayList<Object> selectedNodes = new ArrayList<Object>();
        TreePath[] selectionPaths = tree.getSelectionPaths();
        if (selectionPaths != null) {
            for (TreePath currPath : selectionPaths) {
                Object node = currPath.getLastPathComponent();
                if (!c.isInstance(node)) continue;
                Object tnode = node;
                selectedNodes.add(tnode);
            }
        }
        return selectedNodes;
    }

    @Override
    public void categoryChanged(CategoryEvent e) {
        Category cat = e.getCategory();
        Category catParent = e.getParentCategory();
        TreePath tpathCat = cat.getTreePath();
        TreePath tpathParent = catParent == null ? tpathCat : catParent.getTreePath();
        if (e.getType() == CategoryEventType.ADDED || e.getType() == CategoryEventType.REMOVED || e.getType() == CategoryEventType.METADATA_CHANGED) {
            TreeModelEvent treeModelEventStructureChange = new TreeModelEvent((Object)this, tpathParent);
            SwingUtilities.invokeLater(() -> {
                Enumeration<TreePath> enumExpanded = this.getExpandedDescendants(tpathParent);
                this.firableTreeModelWrapper.fireTreeStructureChanged(treeModelEventStructureChange);
                SwingUtilities.invokeLater(() -> {
                    if (enumExpanded != null) {
                        while (enumExpanded.hasMoreElements()) {
                            TreePath tp = (TreePath)enumExpanded.nextElement();
                            this.expandPath(tp);
                        }
                    }
                    this.makeVisible(tpathCat);
                });
            });
            return;
        }
        if (e.getType() == CategoryEventType.VISIBILITY_CHANGED) {
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, tpathParent, new int[]{cat.getTreeModelIndex()}, new Object[]{cat});
            SwingUtilities.invokeLater(() -> this.firableTreeModelWrapper.fireTreeNodesChanged(treeModelEvent));
            return;
        }
        Assert.shouldNeverReachHere();
    }

    public LayerManager getLayerManager() {
        if (this.layerManagerProxy == null) {
            return null;
        }
        return this.layerManagerProxy.getLayerManager();
    }

    @Override
    public void featuresChanged(FeatureEvent e) {
    }

    @Override
    public void layerChanged(LayerEvent e) {
        Category cat = e.getCategory();
        TreePath tpLayer = e.getLayerable().getTreePath();
        TreePath tpCat = cat.getTreePath();
        if (e.getType() == LayerEventType.ADDED || e.getType() == LayerEventType.REMOVED || e.getType() == LayerEventType.APPEARANCE_CHANGED) {
            TreeModelEvent treeModelEventStructureChange = new TreeModelEvent((Object)this, tpCat);
            SwingUtilities.invokeLater(() -> {
                Enumeration<TreePath> enumExpanded = this.getExpandedDescendants(tpCat);
                this.firableTreeModelWrapper.fireTreeStructureChanged(treeModelEventStructureChange);
                SwingUtilities.invokeLater(() -> {
                    if (enumExpanded != null) {
                        while (enumExpanded.hasMoreElements()) {
                            TreePath tp = (TreePath)enumExpanded.nextElement();
                            this.expandPath(tp);
                        }
                    }
                    if (tpLayer != null && e.getType() == LayerEventType.ADDED) {
                        this.makeVisible(tpLayer);
                        this.scrollPathToVisible(tpLayer);
                        this.setSelectionPath(tpLayer);
                    }
                });
            });
            return;
        }
        if (e.getType() == LayerEventType.METADATA_CHANGED) {
            TreeModelEvent treeModelEventMetadataChange = new TreeModelEvent((Object)this, tpLayer);
            SwingUtilities.invokeLater(() -> this.firableTreeModelWrapper.fireTreeStructureChanged(treeModelEventMetadataChange));
            return;
        }
        if (e.getType() == LayerEventType.VISIBILITY_CHANGED) {
            if (tpLayer == null) {
                return;
            }
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, tpLayer);
            SwingUtilities.invokeLater(() -> this.firableTreeModelWrapper.fireTreeNodesChanged(treeModelEvent));
            return;
        }
        if (e.getType() == LayerEventType.TABLE_DATA_CHANGED) {
            return;
        }
        Assert.shouldNeverReachHere();
    }

    private void addDefaultMouseListeners() {
        this.addMouseListener(new MouseAdapter(){
            boolean consumed = false;

            @Override
            public void mouseClicked(MouseEvent e) {
                if (this.consumed) {
                    e.consume();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.consumed = false;
                ArrayList<Object> lstNodes = new ArrayList<Object>(LayerTree.this.selectionArchive);
                if (e.getClickCount() == 1 && LayerTree.this.checkboxVisible) {
                    final Runnable checkboxAction = LayerTree.this.handleCheckBoxClick(e, lstNodes);
                    if (checkboxAction != null) {
                        LayerTree.this.delayedAction = new TimerTask(this){

                            @Override
                            public void run() {
                                SwingUtilities.invokeLater(checkboxAction);
                            }
                        };
                        LayerTree.this.delayedActionTimer.schedule(LayerTree.this.delayedAction, 200L);
                        this.consumed = true;
                    }
                } else {
                    if (LayerTree.this.delayedAction != null) {
                        LayerTree.this.delayedAction.cancel();
                    }
                    LayerTree.this.delayedAction = null;
                    TreePath selpath = LayerTree.this.getPathForLocation(e.getX(), e.getY());
                    if (selpath != null && LayerTree.this.isEditable()) {
                        this.consumed = LayerTree.this.editTreePath(selpath);
                    }
                }
                if (this.consumed) {
                    e.consume();
                }
            }
        });
    }

    @Override
    public final void setModel(TreeModel newModel) {
        this.firableTreeModelWrapper = newModel != null ? (newModel instanceof FirableTreeModelWrapper ? (FirableTreeModelWrapper)newModel : new FirableTreeModelWrapper(newModel)) : null;
        super.setModel(this.firableTreeModelWrapper);
    }

    protected boolean editTreePath(TreePath tp) {
        return false;
    }

    public void dispose() {
        this.delayedActionTimer.cancel();
    }
}

