/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.layertree;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.WithScale;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.gis3d.Gis3DContextImpl;
import com.vividsolutions.jump.workbench.ui.layertree.ClickableTreeCellRenderer;
import com.vividsolutions.jump.workbench.ui.layertree.LegendLabelPanel;
import com.vividsolutions.jump.workbench.ui.layertree.RendererUtil;
import de.riwagis.icons.IconLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;
import org.apache.commons.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayerNameRenderer
extends JPanel
implements ListCellRenderer<Layerable>,
ClickableTreeCellRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(LayerNameRenderer.class);
    private static final long serialVersionUID = 1268641990159208498L;
    private static final Color UNSELECTED_EDITABLE_FONT_COLOR = Color.GREEN.darker();
    private static final Color SELECTED_EDITABLE_FONT_COLOR = Color.yellow;
    private static final Color BACKGROUND_COLOR = new Color(238, 238, 238);
    private static final Color NOT_BUILDIN_BACKGROUND_COLOR = new Color(240, 255, 240);
    public static final Color GREY = new Color(128, 128, 128);
    private MatteBorder white1pxBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, Color.WHITE);
    public static final ImageIcon ERROR_ICON = IconLoader.svgIcon((String)"layer_error.svg", (int)10);
    public static final ImageIcon FILTER_ICON = IconLoader.svgIconSmall((String)"filter_show.svg");
    public static final ImageIcon _3D_ICON = IconLoader.svgIconSmall((String)"common_map_3d.svg");
    private static final ImageIcon DIGI_ACTIVE_ICON = IconLoader.svgIconSmall((String)"common_edit.svg");
    private static final ImageIcon DIGI_POSSIBLE_ICON = IconLoader.svgIconSmall((String)"common_edit_grey.svg");
    private static final ImageIcon EMPTY_ICON = GUIUtil.createSmallBlankImage();
    private final JCheckBox checkBox = new JCheckBox();
    private final LegendLabelPanel llPanel = new LegendLabelPanel();
    private final GridBagLayout gridBagLayout = new GridBagLayout();
    protected final JLabel lblLayerName = new JLabel();
    private boolean indicatingEditability = false;
    private final DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer();
    private final JLabel errorIconLabel = new JLabel(ERROR_ICON);
    private final JLabel filterIconLabel = new JLabel(FILTER_ICON);
    private final JLabel _3dIconLabel = new JLabel(_3D_ICON);
    private final JLabel digiLayerLabel = new JLabel(DIGI_ACTIVE_ICON);
    private WithScale withScale = null;
    private boolean bolRenderPriority = false;
    private boolean bolRenderErrors = false;
    private boolean renderLayerStates = false;
    private boolean renderSubCategory = false;

    public LayerNameRenderer() {
        this(Style.MULIPLE_ROWS);
    }

    public LayerNameRenderer(Style style) {
        try {
            this.jbInit(style);
        }
        catch (Exception ex) {
            LOG.error("Error at initializing LayerNameRenderer", (Throwable)ex);
        }
    }

    public JLabel getLabel() {
        return this.lblLayerName;
    }

    public void setWithScale(WithScale withScale) {
        this.withScale = withScale;
        this.llPanel.setWithScale(withScale);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Rectangle rect = new Rectangle(1, 5, 10, 10);
        if (this.bolRenderErrors && this.errorIconLabel.isVisible() && rect.contains(event.getPoint())) {
            return this.errorIconLabel.getToolTipText();
        }
        return super.getToolTipText(event);
    }

    @Override
    public Rectangle getCheckBoxBounds() {
        int i = this.gridBagLayout.getConstraints((Component)this.checkBox).gridx;
        int x = 0;
        for (int j = 0; j < i; ++j) {
            x += this.getColumnWidth(j);
        }
        return new Rectangle(x, 0, this.getColumnWidth(i), 100);
    }

    public Rectangle getErrorLblBounds() {
        int i = this.gridBagLayout.getConstraints((Component)this.errorIconLabel).gridx;
        int x = 0;
        for (int j = 0; j < i; ++j) {
            x += this.getColumnWidth(j);
        }
        return new Rectangle(x, 0, this.getColumnWidth(i), 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getColumnWidth(int i) {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.validateTree();
        }
        return this.gridBagLayout.getLayoutDimensions()[0][i];
    }

    public void setCheckBoxVisible(boolean checkBoxVisible) {
        this.checkBox.setVisible(checkBoxVisible);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.validate();
    }

    protected String layerName(Layerable layerable) {
        return layerable.getName();
    }

    protected void renderLayerName(Layerable layerable) {
        StringBuilder sbLabel = new StringBuilder();
        if (this.renderSubCategory && layerable.getDepthInTree() > 3) {
            sbLabel.append(layerable.getCategory().getName()).append(", ");
        }
        sbLabel.append(this.layerName(layerable));
        if (this.bolRenderPriority) {
            sbLabel.append(" - ").append(I18N.get("ui.layertree.LayerNameRenderer.priority")).append(" ").append(NumberFormat.getIntegerInstance().format(layerable.getRenderPrio()));
        }
        this.lblLayerName.setBackground(Color.BLUE);
        this.lblLayerName.setText(sbLabel.toString());
    }

    protected void renderTooltip(Layerable layerable) {
        StringBuilder sbTooltip = new StringBuilder();
        sbTooltip.append("<html><b>").append(this.layerName(layerable));
        if (this.renderLayerStates) {
            boolean filteredLayer = this.isFilteredLayer(layerable);
            boolean _3dLayer = this.is3dLayer(layerable);
            if (filteredLayer || _3dLayer) {
                sbTooltip.append(" (");
                if (filteredLayer) {
                    sbTooltip.append(I18N.get("ui.layertree.LayerNameRenderer.filtered"));
                }
                if (_3dLayer) {
                    if (filteredLayer) {
                        sbTooltip.append(", ");
                    }
                    sbTooltip.append(I18N.get("ui.layertree.LayerNameRenderer.three-dimensional"));
                }
                sbTooltip.append(")");
            }
            if (LayerNameRenderer.isCurrentDigiLayer(layerable)) {
                sbTooltip.append(" - ").append(I18N.get("ui.layertree.LayerNameRenderer.active-digilayer"));
            }
        }
        sbTooltip.append("</b>");
        if (layerable instanceof Layer && !((Layer)layerable).isSelectable()) {
            sbTooltip.append("<br>- ").append(I18N.get("ui.layertree.LayerNameRenderer.not-selectable"));
        }
        if (!layerable.isVisibleInViewerTree()) {
            sbTooltip.append("<br>- ").append(I18N.get("ui.layertree.LayerNameRenderer.invisible-in-viewer-tree"));
        }
        if (Objects.toString(layerable.getDescription(), "").length() > 0) {
            sbTooltip.append("<br>").append(layerable.getDescription());
        }
        sbTooltip.append("</html>");
        this.setToolTipText(sbTooltip.toString());
    }

    protected void renderColorsBorders(Layerable layerable, boolean isSelected, Color selForeground, Color selBackground, Color foreground, Color background) {
        this.setOpaque(true);
        this.setBorder(this.white1pxBorder);
        if (isSelected) {
            this.lblLayerName.setForeground(selForeground);
            this.lblLayerName.setBackground(selBackground);
            this.setForeground(selForeground);
            this.setBackground(selBackground);
        } else {
            this.lblLayerName.setForeground(foreground);
            this.lblLayerName.setBackground(background);
            this.setForeground(foreground);
            if (layerable.isBuildIn()) {
                this.setBackground(BACKGROUND_COLOR);
            } else {
                this.setBackground(NOT_BUILDIN_BACKGROUND_COLOR);
            }
            if (this.indicatingEditability && layerable instanceof Layer && ((Layer)layerable).isEditable()) {
                this.lblLayerName.setForeground(isSelected ? SELECTED_EDITABLE_FONT_COLOR : UNSELECTED_EDITABLE_FONT_COLOR);
            }
            if (this.renderLayerStates && !RendererUtil.isValidForScale(layerable, this.withScale)) {
                this.lblLayerName.setForeground(GREY);
            }
        }
    }

    protected void handleRenderError(Layerable layerable) {
        if (layerable.getRenderError() != null) {
            this.errorIconLabel.setVisible(true);
            String arrErrorText = WordUtils.wrap((String)layerable.getRenderError(), (int)150, (String)"<br/>", (boolean)true);
            this.errorIconLabel.setToolTipText("<html>" + arrErrorText + "</html>");
        } else {
            this.errorIconLabel.setVisible(false);
        }
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends Layerable> list, Layerable layerable, int index, boolean isSelected, boolean cellHasFocus) {
        if (layerable == null) {
            return this.defaultListCellRenderer.getListCellRendererComponent(list, layerable, index, isSelected, cellHasFocus);
        }
        this.renderLayerName(layerable);
        this.renderTooltip(layerable);
        this.renderColorsBorders(layerable, isSelected, list.getSelectionForeground(), list.getSelectionBackground(), list.getForeground(), list.getBackground());
        if (this.bolRenderErrors) {
            this.handleRenderError(layerable);
        }
        this.checkBox.setSelected(layerable.isVisible());
        this.llPanel.setImageForLayerable(layerable);
        return this;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Layerable layerable = (Layerable)value;
        this.renderLayerName(layerable);
        this.renderTooltip(layerable);
        this.renderColorsBorders(layerable, selected, UIManager.getColor("Tree.selectionForeground"), UIManager.getColor("Tree.selectionBackground"), tree.getForeground(), tree.getBackground());
        if (this.bolRenderErrors) {
            this.handleRenderError(layerable);
        }
        this.checkBox.setSelected(layerable.isVisible());
        this.llPanel.setImageForLayerable(layerable);
        if (this.renderLayerStates) {
            boolean areSomeLayersFiltered = layerable.getLayerManager().getLayerablesUnordered(Layer.class).stream().anyMatch(l -> l.isDataFiltered());
            boolean is3dLayer = this.is3dLayer(layerable);
            boolean isFilteredLayer = this.isFilteredLayer(layerable);
            boolean isPossibleDigiLayer = LayerNameRenderer.isPossibleDigiLayer(layerable);
            this._3dIconLabel.setVisible(is3dLayer);
            this.filterIconLabel.setVisible(isFilteredLayer || areSomeLayersFiltered && is3dLayer);
            this.digiLayerLabel.setVisible(isPossibleDigiLayer || isFilteredLayer || is3dLayer);
            this.filterIconLabel.setIcon(this.getIconOrBlankPlaceHolder(isFilteredLayer, () -> FILTER_ICON));
            this.digiLayerLabel.setIcon(this.getIconOrBlankPlaceHolder(isPossibleDigiLayer, () -> this.getDigiLayerIcon(layerable)));
        } else {
            this.filterIconLabel.setVisible(false);
            this.digiLayerLabel.setVisible(false);
            this._3dIconLabel.setVisible(false);
        }
        return this;
    }

    public boolean is3dLayer(Layerable layerable) {
        return Gis3DContextImpl.getInstance().isLayerAvailable(layerable.getKey());
    }

    public boolean isFilteredLayer(Layerable layerable) {
        return layerable instanceof Layer && ((Layer)layerable).isDataFiltered();
    }

    private ImageIcon getIconOrBlankPlaceHolder(boolean state, Supplier<ImageIcon> iconSuplier) {
        if (!state) {
            return EMPTY_ICON;
        }
        return iconSuplier.get();
    }

    private ImageIcon getDigiLayerIcon(Layerable layerable) {
        if (LayerNameRenderer.isCurrentDigiLayer(layerable)) {
            return DIGI_ACTIVE_ICON;
        }
        return DIGI_POSSIBLE_ICON;
    }

    static boolean isPossibleDigiLayer(Layerable layerable) {
        if (!(layerable instanceof Layer)) {
            return false;
        }
        Layer layer = (Layer)layerable;
        return layer.canBeDigiLayer();
    }

    private static boolean isCurrentDigiLayer(Layerable layerable) {
        return EditingPanel.instanceOf().getCurrentLayer() == layerable;
    }

    private void jbInit(Style style) {
        GridBagConstraints constraintsFilte;
        GridBagConstraints constraints3dAva;
        GridBagConstraints constraintsGeomP;
        GridBagConstraints constraintsLName;
        GridBagConstraints constraintsCheck;
        GridBagConstraints constraintsError;
        this.checkBox.setVisible(false);
        this.setLayout(this.gridBagLayout);
        this.lblLayerName.setOpaque(false);
        this.checkBox.setOpaque(false);
        this.errorIconLabel.setVisible(false);
        this._3dIconLabel.setVisible(false);
        this.filterIconLabel.setVisible(false);
        this.digiLayerLabel.setVisible(false);
        GridBagConstraints constraintsDigiL = switch (style.ordinal()) {
            default -> {
                constraintsError = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 2), 0, 0);
                constraintsCheck = new GridBagConstraints(1, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0);
                constraintsLName = new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0);
                constraintsGeomP = new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 1, 1), 0, 0);
                constraints3dAva = new GridBagConstraints(3, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0);
                constraintsFilte = new GridBagConstraints(4, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0);
                yield new GridBagConstraints(5, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0);
            }
            case 1 -> {
                constraintsError = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 2), 0, 0);
                constraintsCheck = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0);
                constraintsGeomP = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 1, 1), 0, 0);
                constraintsLName = new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0);
                constraints3dAva = new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0);
                constraintsFilte = new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0);
                yield new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0);
            }
            case 2 -> {
                constraintsError = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 2), 0, 0);
                constraintsCheck = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0);
                constraintsLName = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0);
                constraintsGeomP = new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 1, 1), 0, 0);
                constraints3dAva = new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0);
                constraintsFilte = new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0);
                yield new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0);
            }
        };
        this.add((Component)this.errorIconLabel, constraintsError);
        this.add((Component)this.checkBox, constraintsCheck);
        this.add((Component)this.lblLayerName, constraintsLName);
        this.add((Component)this.llPanel, constraintsGeomP);
        this.add((Component)this._3dIconLabel, constraints3dAva);
        this.add((Component)this.filterIconLabel, constraintsFilte);
        this.add((Component)this.digiLayerLabel, constraintsDigiL);
    }

    public void setRenderPriority(boolean boolRenderPriority) {
        this.bolRenderPriority = boolRenderPriority;
    }

    public boolean isRenderPriority() {
        return this.bolRenderPriority;
    }

    public boolean isRenderErrors() {
        return this.bolRenderErrors;
    }

    public void setRenderErrors(boolean bolRenderErrors) {
        this.bolRenderErrors = bolRenderErrors;
    }

    public boolean isRenderLayerStates() {
        return this.renderLayerStates;
    }

    public void setRenderLayerStates(boolean renderLayerStates) {
        this.renderLayerStates = renderLayerStates;
    }

    public boolean isRenderSubCategory() {
        return this.renderSubCategory;
    }

    public void setRenderSubCategory(boolean renderSubCategory) {
        this.renderSubCategory = renderSubCategory;
    }

    public void setIndicatingEditability(boolean indicatingEditability) {
        this.indicatingEditability = indicatingEditability;
    }

    public static enum Style {
        MULIPLE_ROWS,
        SINGLE_ROW_PREVIEW_LEFT,
        SINGLE_ROW_PREVIEW_RIGHT;

    }
}

