/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.layertree;

import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.WithScale;
import com.vividsolutions.jump.workbench.ui.layertree.ClickableTreeCellRenderer;
import com.vividsolutions.jump.workbench.ui.layertree.LayerNameRenderer;
import com.vividsolutions.jump.workbench.ui.layertree.LegendLabelPanel;
import com.vividsolutions.jump.workbench.ui.layertree.RendererUtil;
import com.vividsolutions.jump.workbench.ui.layertree.sublayervalues.ColorThemingValue;
import com.vividsolutions.jump.workbench.ui.renderer.style.DefaultLegendLabelRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.LegendLabelRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColorThemingTreeRenderer
extends JPanel
implements ListCellRenderer<ColorThemingValue>,
ClickableTreeCellRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(ColorThemingTreeRenderer.class);
    private static final Color NOT_BUILDIN_BORDER_COLOR = new Color(78, 204, 100);
    private static final Color TREE_SELECTION_BACKGROUND = UIManager.getColor("Tree.selectionBackground");
    private static final Color TREE_SELECTION_FOREGROUND = UIManager.getColor("Tree.selectionForeground");
    private final JCheckBox checkBox = new JCheckBox();
    private final LegendLabelPanel llPanel = new LegendLabelPanel();
    private final GridBagLayout gridBagLayout = new GridBagLayout();
    private final JLabel label = new JLabel();
    private final transient ListCellRenderer<Object> defaultListCellRenderer = new DefaultListCellRenderer();
    private Font labelFont = new JLabel().getFont();
    private WithScale withScale = null;

    public ColorThemingTreeRenderer() {
        try {
            this.labelFont = this.labelFont.deriveFont(2, this.labelFont.getSize());
            this.checkBox.setBorder(new EmptyBorder(1, 1, 1, 1));
            this.jbInit();
        }
        catch (Exception ex) {
            LOG.warn("unable to initialize ColorThemingRenderer: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public void setWithScale(WithScale withScale) {
        this.withScale = withScale;
        this.llPanel.setWithScale(withScale);
    }

    public JLabel getLabel() {
        return this.label;
    }

    @Override
    public Rectangle getCheckBoxBounds() {
        int i = this.gridBagLayout.getConstraints((Component)this.checkBox).gridx;
        int x = 0;
        for (int j = 0; j < i; ++j) {
            x += this.getColumnWidth(j);
        }
        return new Rectangle(x, 0, this.getColumnWidth(i), 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getColumnWidth(int i) {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.validateTree();
        }
        return this.gridBagLayout.getLayoutDimensions()[0][i];
    }

    public void setCheckBoxVisible(boolean checkBoxVisible) {
        this.checkBox.setVisible(checkBoxVisible);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.validate();
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends ColorThemingValue> list, ColorThemingValue value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value == null) {
            return this.defaultListCellRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
        ColorThemingValue ctv = value;
        this.label.setText(ctv.toString());
        this.setToolTipText(ctv.toString());
        if (isSelected) {
            this.setOpaque(true);
            this.label.setForeground(list.getSelectionForeground());
            this.label.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
            this.setBackground(list.getSelectionBackground());
        } else {
            this.setOpaque(false);
            this.label.setForeground(list.getForeground());
            this.label.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
            if (ctv.getLayer().isBuildIn()) {
                this.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.LIGHT_GRAY));
            } else {
                this.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, NOT_BUILDIN_BORDER_COLOR));
            }
        }
        if (this.checkBox.isVisible() && ctv.getStyle() != null) {
            this.checkBox.setEnabled(true);
            this.checkBox.setSelected(ctv.getStyle().isEnabled());
        } else if (this.checkBox.isVisible()) {
            this.checkBox.setEnabled(false);
            this.checkBox.setSelected(false);
        }
        if (!RendererUtil.isValidForScale(ctv.getLayer(), this.withScale)) {
            this.label.setForeground(LayerNameRenderer.GREY);
        }
        this.label.setFont(this.labelFont);
        if (ctv.getStyle() != null) {
            LegendLabelRenderer renderer = (LegendLabelRenderer)ctv.getStyle().getIntelligence();
            LayerStyleCollection style = RendererUtil.getValidStyleCollection(ctv.getLayer(), this.withScale);
            this.llPanel.setIconImage(renderer.getLegendLabel(style));
        } else {
            this.llPanel.setIconImage(DefaultLegendLabelRenderer.getEmptyIcon());
        }
        return this;
    }

    private JList<ColorThemingValue> list(JTree tree) {
        JList<ColorThemingValue> list = new JList<ColorThemingValue>();
        list.setForeground(tree.getForeground());
        list.setBackground(tree.getBackground());
        list.setSelectionForeground(TREE_SELECTION_FOREGROUND);
        list.setSelectionBackground(TREE_SELECTION_BACKGROUND);
        return list;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        ColorThemingValue ctv = (ColorThemingValue)value;
        this.getListCellRendererComponent(this.list(tree), ctv, -1, selected, hasFocus);
        if (selected) {
            this.setOpaque(true);
            this.label.setForeground(TREE_SELECTION_FOREGROUND);
            this.label.setBackground(TREE_SELECTION_BACKGROUND);
            this.setForeground(TREE_SELECTION_FOREGROUND);
            this.setBackground(TREE_SELECTION_BACKGROUND);
        } else {
            this.setOpaque(false);
            this.label.setForeground(tree.getForeground());
            this.label.setBackground(tree.getBackground());
            this.setForeground(tree.getForeground());
            if (ctv.getLayer().isBuildIn()) {
                this.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 0, Color.LIGHT_GRAY));
            } else {
                this.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 0, NOT_BUILDIN_BORDER_COLOR));
            }
        }
        return this;
    }

    private final void jbInit() {
        this.checkBox.setVisible(false);
        this.setLayout(this.gridBagLayout);
        this.label.setOpaque(false);
        this.checkBox.setOpaque(false);
        this.add((Component)this.checkBox, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.add((Component)this.label, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.llPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 1, 1), 0, 0));
        this.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 0, Color.LIGHT_GRAY));
    }
}

