/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.layertree;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.WithScale;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.gis3d.Gis3DContextImpl;
import com.vividsolutions.jump.workbench.ui.layertree.ClickableTreeCellRenderer;
import com.vividsolutions.jump.workbench.ui.layertree.LayerNameRenderer;
import com.vividsolutions.jump.workbench.ui.layertree.RendererUtil;
import de.riwagis.icons.IconLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryNameRenderer
extends JPanel
implements ListCellRenderer<Category>,
ClickableTreeCellRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(CategoryNameRenderer.class);
    private static final long serialVersionUID = -2314860698817697680L;
    private static final Color BACKGROUND_COLOR = new Color(221, 221, 221);
    private static final Color NOT_BUILDIN_BACKGROUND_COLOR = new Color(220, 255, 220);
    private static final ImageIcon DIGI_ACTIVE_ICON = IconLoader.svgIconSmall((String)"common_edit.svg");
    private static final ImageIcon DIGI_POSSIBLE_ICON = IconLoader.svgIconSmall((String)"common_edit_grey.svg");
    private static final ImageIcon EMPTY_ICON = GUIUtil.createSmallBlankImage();
    private final MatteBorder white1PxBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, Color.WHITE);
    private final JCheckBox checkBox = new JCheckBox();
    private final GridBagLayout gridBagLayout = new GridBagLayout();
    private final JLabel label = new JLabel();
    private final String strLayers = I18N.get("common.layers");
    private final DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer();
    private WithScale withScale = null;
    private final JLabel errorIconLabel = new JLabel(IconLoader.svgIcon((String)"layer_error.svg", (int)10));
    private final JLabel _3dIconLabel = new JLabel(_3D_ICON);
    private final JLabel digiLayerLabel = new JLabel(DIGI_ACTIVE_ICON);
    private boolean bolRenderErrors = false;
    private final JLabel filterIconLabel = new JLabel(LayerNameRenderer.FILTER_ICON);
    public static final ImageIcon _3D_ICON = IconLoader.svgIconSmall((String)"common_map_3d.svg");
    private boolean containsActiveDigiLayer = false;
    private boolean renderLayerStates = false;
    private static final boolean DISPLAY_ONLY_ACTIVE_DIGI_LAYER_CATEGORIES = true;

    public CategoryNameRenderer() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LOG.warn(String.format("unable to initialize CategoryNameRenderer: %s", ex.getMessage()), (Throwable)ex);
        }
    }

    public void setWithScale(WithScale withScale) {
        this.withScale = withScale;
    }

    public JLabel getLabel() {
        return this.label;
    }

    @Override
    public Rectangle getCheckBoxBounds() {
        int i = this.gridBagLayout.getConstraints((Component)this.checkBox).gridx;
        int x = 0;
        for (int j = 0; j < i; ++j) {
            x += this.getColumnWidth(j);
        }
        return new Rectangle(x, 0, this.getColumnWidth(i), 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getColumnWidth(int i) {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.validateTree();
        }
        return this.gridBagLayout.getLayoutDimensions()[0][i];
    }

    public void setCheckBoxVisible(boolean checkBoxVisible) {
        this.checkBox.setVisible(checkBoxVisible);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.validate();
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends Category> list, Category value, int index, boolean isSelected, boolean cellHasFocus) {
        boolean has3dLayers;
        if (value == null) {
            return this.defaultListCellRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
        Category cat = value;
        this.label.setText(cat.getName());
        List<Layerable> lstLy = cat.getAllLayerables();
        long filteredLayers = lstLy.stream().filter(layerable -> layerable instanceof Layer && ((Layer)layerable).isDataFiltered()).count();
        boolean hasFilteredLayers = filteredLayers > 0L;
        long _3dLayers = lstLy.stream().filter(l -> Gis3DContextImpl.getInstance().isLayerAvailable(l.getKey())).count();
        boolean bl = has3dLayers = _3dLayers > 0L;
        if (this.renderLayerStates) {
            boolean areSomeLayersFiltered = cat.getLayerManager().getLayerablesUnordered(Layer.class).stream().anyMatch(l -> l.isDataFiltered());
            Layer digiLayer = EditingPanel.instanceOf().getCurrentLayer();
            this.containsActiveDigiLayer = lstLy.contains(digiLayer);
            this.filterIconLabel.setVisible(hasFilteredLayers);
            boolean hasPossibleDigiLayers = this.containsActiveDigiLayer;
            this._3dIconLabel.setVisible(has3dLayers);
            this.filterIconLabel.setVisible(hasFilteredLayers || areSomeLayersFiltered && has3dLayers);
            this.digiLayerLabel.setVisible(hasPossibleDigiLayers || hasFilteredLayers || has3dLayers);
            this.filterIconLabel.setIcon(this.getIconOrBlankPlaceHolder(hasFilteredLayers, () -> LayerNameRenderer.FILTER_ICON));
            this.digiLayerLabel.setIcon(this.getIconOrBlankPlaceHolder(hasPossibleDigiLayers, this::getDigiLayerIcon));
        } else {
            this.filterIconLabel.setVisible(false);
            this.digiLayerLabel.setVisible(false);
            this._3dIconLabel.setVisible(false);
        }
        StringBuilder sbToolTip = new StringBuilder();
        sbToolTip.append("<html>").append("<b>").append(cat.getName()).append("</b>");
        sbToolTip.append(" - ").append(lstLy.size()).append(" ").append(this.strLayers);
        if (this.renderLayerStates) {
            if (hasFilteredLayers || has3dLayers) {
                sbToolTip.append(" (");
                if (hasFilteredLayers) {
                    String filterText = String.format("%d %s", filteredLayers, I18N.get("ui.layertree.LayerNameRenderer.filtered"));
                    sbToolTip.append(filterText);
                }
                if (has3dLayers) {
                    if (hasFilteredLayers) {
                        sbToolTip.append(", ");
                    }
                    String _3dText = String.format("%d %s", _3dLayers, I18N.get("ui.layertree.LayerNameRenderer.three-dimensional"));
                    sbToolTip.append(_3dText);
                }
                sbToolTip.append(")");
            }
            if (this.containsActiveDigiLayer) {
                sbToolTip.append(" - ").append(I18N.get("ui.layertree.LayerNameRenderer.active-digilayer"));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)cat.getDescription())) {
            sbToolTip.append("<br/>").append(cat.getDescription());
        }
        sbToolTip.append("</html>");
        this.setToolTipText(sbToolTip.toString());
        boolean hasLayerInRange = !this.renderLayerStates || lstLy.stream().anyMatch(ly -> RendererUtil.isValidForScale(ly, this.withScale));
        Color foregroundColor = hasLayerInRange ? Color.BLACK : Color.GRAY;
        this.checkBox.setSelected(cat.isVisible());
        this.setOpaque(true);
        if (isSelected) {
            this.label.setForeground(list.getSelectionForeground());
            this.setForeground(list.getSelectionForeground());
            this.setBackground(list.getSelectionBackground());
        } else {
            this.label.setForeground(foregroundColor);
            this.setForeground(foregroundColor);
            if (cat.isBuildIn()) {
                this.setBackground(BACKGROUND_COLOR);
            } else {
                this.setBackground(NOT_BUILDIN_BACKGROUND_COLOR);
            }
        }
        this.setBorder(this.white1PxBorder);
        return this;
    }

    private ImageIcon getIconOrBlankPlaceHolder(boolean state, Supplier<ImageIcon> iconSuplier) {
        if (!state) {
            return EMPTY_ICON;
        }
        return iconSuplier.get();
    }

    private ImageIcon getDigiLayerIcon() {
        if (this.containsActiveDigiLayer) {
            return DIGI_ACTIVE_ICON;
        }
        return DIGI_POSSIBLE_ICON;
    }

    private JList<Category> list(JTree tree) {
        JList<Category> list = new JList<Category>();
        list.setForeground(tree.getForeground());
        list.setBackground(tree.getBackground());
        list.setSelectionForeground(UIManager.getColor("Tree.selectionForeground"));
        list.setSelectionBackground(UIManager.getColor("Tree.selectionBackground"));
        return list;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.getListCellRendererComponent(this.list(tree), (Category)value, -1, selected, hasFocus);
        if (this.bolRenderErrors) {
            this.handleRenderError((Category)value);
        }
        return this;
    }

    private void handleRenderError(Category category) {
        String strRenderError = category.getRenderError();
        if (strRenderError != null) {
            this.errorIconLabel.setVisible(true);
            String arrErrorText = WordUtils.wrap((String)strRenderError, (int)150, (String)"<br/>", (boolean)true);
            this.errorIconLabel.setToolTipText("<html>" + arrErrorText + "</html>");
        } else {
            this.errorIconLabel.setVisible(false);
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Rectangle rect = new Rectangle(1, 1, 10, 10);
        if (this.errorIconLabel.isVisible() && rect.contains(event.getPoint())) {
            return this.errorIconLabel.getToolTipText();
        }
        return super.getToolTipText(event);
    }

    final void jbInit() {
        this.setLayout(this.gridBagLayout);
        this.label.setOpaque(false);
        this.checkBox.setOpaque(false);
        this.errorIconLabel.setVisible(false);
        this._3dIconLabel.setVisible(false);
        this.filterIconLabel.setVisible(false);
        this.add((Component)this.errorIconLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 2), 0, 0));
        this.add((Component)this.checkBox, new GridBagConstraints(1, 0, 1, 2, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.add((Component)this.label, new GridBagConstraints(2, 0, 1, 2, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this._3dIconLabel, new GridBagConstraints(4, 0, 1, 2, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.filterIconLabel, new GridBagConstraints(5, 0, 1, 2, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.digiLayerLabel, new GridBagConstraints(6, 0, 1, 2, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.label.setFont(this.label.getFont().deriveFont(1));
    }

    public boolean isRenderErrors() {
        return this.bolRenderErrors;
    }

    public void setRenderErrors(boolean bolRenderErrors) {
        this.bolRenderErrors = bolRenderErrors;
    }

    public boolean isRenderLayerStates() {
        return this.renderLayerStates;
    }

    public void setRenderLayerStates(boolean renderLayerStates) {
        this.renderLayerStates = renderLayerStates;
    }
}

