/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.gis3d;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.CategoryEventType;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.FeatureEventType;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.selection.SelectionListener;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import de.riwagis.browser.BrowserFrame;
import de.riwagis.browser.BrowserPanel;
import de.riwagis.browser.BrowserScriptable;
import de.riwagis.browser.WindowManager;
import de.riwagis.browser.dummy.DummyBrowserFrame;
import de.riwagis.browser.dummy.DummyBrowserPanel;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.crs.Transformer;
import de.riwagis.gis.context.map.Gis3DContext;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.DataUtilities;
import org.geotools.feature.FeatureCollection;
import org.geotools.geojson.feature.FeatureJSON;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Gis3DContextImpl
implements Gis3DContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Gis3DContextImpl.class);
    private Set<String> availableLayers = new HashSet<String>();
    private static final Gis3DContextImpl INSTANCE = new Gis3DContextImpl();
    private static final String USR_PROJECT3D_URL = "usr_project3d_url";
    private static final String VCS_3DMAP_PATH = "/map3d/client28/vcm/";
    private String overrideMapPath = "";
    private Gis3DMode gis3DMode = Gis3DMode.SPLITVIEW;
    private BrowserPanel browser;
    private BrowserFrame externalBrowser;
    private boolean _3DActive;
    private boolean autoSyncPositionTo3D = true;
    private boolean isBrowserInitialized = false;
    private final LayerListener layerListener = new LayerListener(){

        @Override
        public void featuresChanged(FeatureEvent e) {
            if (!Gis3DContextImpl.this.is3DActive()) {
                return;
            }
            Gis3DContextImpl.this.fireFeaturesChanged(e.getLayer(), e.getFeatures(), e.getType());
        }

        @Override
        public void layerChanged(LayerEvent e) {
            if (!Gis3DContextImpl.this.is3DActive()) {
                return;
            }
            if (e.getType() == LayerEventType.VISIBILITY_CHANGED) {
                Gis3DContextImpl.this.syncLayerVisibility(e.getLayerable());
            } else if (e.getType() == LayerEventType.APPEARANCE_CHANGED) {
                Gis3DContextImpl.this.syncWmsActiveServiceLayers(e.getLayerable());
            }
        }

        @Override
        public void categoryChanged(CategoryEvent e) {
            if (!Gis3DContextImpl.this.is3DActive()) {
                return;
            }
            if (e.getType() == CategoryEventType.VISIBILITY_CHANGED) {
                Gis3DContextImpl.this.syncLayerVisibility(e.getCategory().getAllLayerables());
            }
        }
    };
    private final SelectionListener selectionListener = () -> {
        SelectionManager selectionManager = WorkbenchContext.getInstance().getSelectionManager();
        LayerManager layerManager = WorkbenchContext.getInstance().getLayerManager();
        this.syncSelection(layerManager, selectionManager);
    };

    public void clearSelection() {
        this.getActiveBrowser().execJS("riwagis3d.in.clearSelectionSet();");
    }

    public void selectFeatures(Layer layer, Collection<SimpleFeature> selection) {
        String layerKey = layer.getKey();
        String geoJson = this.convertFeaturesToGeoJson(selection);
        this.getActiveBrowser().execJS(String.format("riwagis3d.in.selectFeatures('%s', %s)", layerKey, geoJson));
    }

    public String sendMessage(String functionName, String arguments, boolean waitForResult) {
        if (this.is3DActive() && this.isBrowserInitialized) {
            String message = String.format("{functionName: '%s', arguments: '%s', waitForResult: %s}", functionName, arguments != null && !arguments.isBlank() ? arguments : "[]", waitForResult ? "true" : "false");
            if (waitForResult) {
                return this.getActiveBrowser().execJSWithReturn(String.format("RiwaGisClient.onMessage(%s)", message));
            }
            this.getActiveBrowser().execJS(String.format("RiwaGisClient.onMessage(%s);", message));
            return "";
        }
        log.warn(String.format("Sending function call \"%s\" to 3dgis failed. 3dgis ist not active.", functionName));
        return "";
    }

    public void setAvailableLayers(Set<String> availableLayers) {
        this.availableLayers = availableLayers;
        this.refreshLayerNamePanel();
    }

    public boolean isLayerAvailable(String layerKey) {
        return this.is3DActive() && this.availableLayers.contains(layerKey);
    }

    public void signalInitialized() {
        this.isBrowserInitialized = true;
        this.fireSetClientApiVersion();
        this.fireEnableJS();
    }

    private void fireEnableJS() {
        this.getActiveBrowser().execJS(String.format("riwagis3d.in.enable('%s');", switch (this.gis3DMode.ordinal()) {
            case 1 -> "external";
            default -> "split";
        }));
    }

    private void fireSetClientApiVersion() {
        int apiLevel = JUMPWorkbench.GIS_CONTEXT.getModuleApp().getClientAPILevel();
        this.getActiveBrowser().execJS(String.format("riwagis3d.in.setClientApiVersion(%d);", apiLevel));
    }

    private void fireFeaturesChanged(Layerable layer, Collection<SimpleFeature> features, FeatureEventType eventType) {
        String geoJson = this.convertFeaturesToGeoJson(features);
        this.getActiveBrowser().execJS(String.format("riwagis3d.in.onFeaturesChanged('%s', %s, '%s');", layer.getKey(), geoJson, eventType.toString()));
    }

    private String convertFeaturesToGeoJson(Collection<SimpleFeature> features) {
        try {
            FeatureJSON fjson = new FeatureJSON();
            StringWriter writer = new StringWriter();
            fjson.writeFeatureCollection((FeatureCollection)DataUtilities.collection(new ArrayList<SimpleFeature>(features)), (Object)writer);
            return writer.toString();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public void setMapPath(String mapPath) {
        this.overrideMapPath = mapPath;
    }

    public void syncVectorTileLayerContent(Layerable layer) {
        if (!this.is3DActive()) {
            return;
        }
        this.getActiveBrowser().execJS(String.format("riwagis3d.in.syncVectorTileLayerContent('%s');", layer.getKey()));
    }

    public void syncWmsActiveServiceLayers(Layerable layer) {
        if (!this.is3DActive()) {
            return;
        }
        if (layer instanceof WMSLayer) {
            this.getActiveBrowser().execJS(String.format("riwagis3d.in.syncWmsActiveServiceLayers('%s');", layer.getKey()));
        }
    }

    public void syncLayerVisibility(Layerable layer) {
        if (!this.is3DActive()) {
            return;
        }
        this.getActiveBrowser().execJS(String.format("riwagis3d.in.syncLayerVisibility('%s');", layer.getKey()));
    }

    public void syncLayerVisibility(List<Layerable> layerList) {
        if (!this.is3DActive()) {
            return;
        }
        String layerKeys = layerList.stream().map(layer -> String.format("'%s'", layer.getKey())).collect(Collectors.joining(","));
        this.getActiveBrowser().execJS(String.format("riwagis3d.in.syncLayersVisibility([%s]);", layerKeys));
    }

    public void syncSelection(LayerManager layerManager, SelectionManager selectionManager) {
        if (!this.is3DActive()) {
            return;
        }
        this.clearSelection();
        for (Layer layer : layerManager) {
            if (selectionManager.getFeaturesWithSelectedItems(layer).isEmpty()) continue;
            Collection<SimpleFeature> selection = selectionManager.getFeaturesWithSelectedItems(layer);
            this.selectFeatures(layer, selection);
        }
    }

    public void registerSelectionManager(SelectionManager selectionManager) {
        selectionManager.addSelectionListener(this.selectionListener);
    }

    public void unregisterSelectionManager(SelectionManager selectionManager) {
        selectionManager.removeSelectionListener(this.selectionListener);
    }

    public boolean is3DActive() {
        return this._3DActive;
    }

    public void set3DActive(boolean _3DActive) {
        if (this._3DActive == _3DActive) {
            return;
        }
        this._3DActive = _3DActive;
        if (_3DActive) {
            switch (this.gis3DMode.ordinal()) {
                case 1: {
                    this.getExternalBrowser().setVisible(true);
                    break;
                }
                default: {
                    WorkbenchContext.getFrame().getDesktopPanel().setRightTabsVisible(false);
                    WorkbenchContext.getFrame().setRightSplitComponent((JComponent)this.getBrowser());
                }
            }
            if (this.isBrowserInitialized) {
                this.fireEnableJS();
            }
            WorkbenchContext.getInstance().getLayerManager().addLayerListener(this.layerListener);
        } else {
            if (WorkbenchContext.getInstance() != null && WorkbenchContext.getInstance().getLayerManager() != null) {
                WorkbenchContext.getInstance().getLayerManager().removeLayerListener(this.layerListener);
            }
            switch (this.gis3DMode.ordinal()) {
                case 1: {
                    this.getExternalBrowser().setVisible(false);
                    break;
                }
                default: {
                    WorkbenchContext.getFrame().setRightSplitComponent(null);
                }
            }
            BrowserScriptable browserPanel = this.getActiveBrowser();
            browserPanel.execJS("riwagis3d.in.disable();");
            this.refreshLayerNamePanel();
        }
    }

    public void refreshLayerNamePanel() {
        if (WorkbenchContext.getInstance() != null && WorkbenchContext.getInstance().getLayerNamePanel() != null) {
            JPanel layerNamePanel = (JPanel)((Object)WorkbenchContext.getInstance().getLayerNamePanel());
            layerNamePanel.validate();
            layerNamePanel.repaint();
        }
    }

    public void set3DPosition(Coordinate c, CRSDefinition sourceDef) throws Exception {
        Transformer trans = new Transformer(sourceDef.getCode(), "EPSG:4326");
        trans.transform2d(c);
        Transformer trans2 = new Transformer(sourceDef.getCode(), "EPSG:3857");
        Viewport viewport = WorkbenchContext.getInstance().getLayerViewPanel().getViewport();
        Envelope extent = viewport.getEnvelopeInModelCoordinates();
        trans2.transform2d(extent);
        double distance = 0.5 * Math.sqrt(Math.pow(extent.getMaxX() - extent.getMinX(), 2.0) + Math.pow(extent.getMaxY() - extent.getMinY(), 2.0)) * Math.tan(1.0471975511965976);
        this.set3DActive(true);
        this.getActiveBrowser().execJS(String.format("riwagis3d.in.setPosition(%s, %s, %s, undefined, undefined, 1.0);", c.x, c.y, distance));
    }

    public void autoSync3DPosition() {
        if (!this.isAutoSyncPositionTo3D()) {
            return;
        }
        this.syncPositionTo3D();
    }

    public void syncPositionTo3D() {
        if (!this.is3DActive()) {
            return;
        }
        this.getActiveBrowser().execJS("riwagis3d.in.syncMapExtent(undefined,1.0);");
    }

    private BrowserScriptable getActiveBrowser() {
        if (this.getGis3DMode() == Gis3DMode.EXTERNAL) {
            return this.getExternalBrowser();
        }
        return this.getBrowser();
    }

    private BrowserPanel getBrowser() {
        if (this.browser == null) {
            String url = this.getURL();
            this.browser = WindowManager.getInstance().createBrowserPanel();
            this.browser.navigate(url);
        }
        return this.browser;
    }

    private BrowserFrame getExternalBrowser() {
        if (this.externalBrowser == null) {
            this.externalBrowser = WindowManager.getInstance().window().absoluteAddress(this.getURL()).size(1024, 768).open();
            JFrame frame = (JFrame)this.externalBrowser;
            this.disableDisposalOfBrowserFrame(frame);
        }
        return this.externalBrowser;
    }

    private void disableDisposalOfBrowserFrame(JFrame frame) {
        frame.setDefaultCloseOperation(1);
        for (WindowListener listener : frame.getWindowListeners()) {
            frame.removeWindowListener(listener);
        }
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Gis3DContextImpl.this.set3DActive(false);
                WorkbenchContext.getFrame().updateEnabledState();
            }
        });
    }

    private String getURL() {
        String server3DMapURL = "";
        try {
            String jetty3DServer = (String)JUMPWorkbench.GIS_CONTEXT.getModuleApp().getModuleAppObject("GIS-3D-SERVER");
            String projectURL = this.get3DProjectURL();
            if (projectURL != null && !projectURL.isBlank()) {
                server3DMapURL = jetty3DServer.concat((String)StringUtils.defaultIfBlank((CharSequence)this.overrideMapPath, (CharSequence)VCS_3DMAP_PATH));
            }
        }
        catch (Exception e) {
            log.error("could not retrieve 3d map jetty URL", (Throwable)e);
        }
        return server3DMapURL;
    }

    private String get3DProjectURL() {
        try {
            return Objects.toString(JUMPWorkbench.GIS_CONTEXT.getModuleApp().getUserInfo().get(USR_PROJECT3D_URL), "");
        }
        catch (Exception ex) {
            log.error("Could not retrieve 3d project url", (Throwable)ex);
            return null;
        }
    }

    public void dispose() {
        this.set3DActive(false);
        this.isBrowserInitialized = false;
        if (this.browser != null) {
            this.browser.dispose();
            this.browser = null;
        }
        if (this.externalBrowser != null) {
            this.externalBrowser.dispose();
            this.externalBrowser = null;
        }
    }

    public Gis3DMode getGis3DMode() {
        return this.gis3DMode;
    }

    public void setGis3DMode(Gis3DMode gis3DMode) {
        if (this.gis3DMode == gis3DMode) {
            return;
        }
        boolean wasActive = this._3DActive;
        this.dispose();
        this.gis3DMode = gis3DMode;
        this.set3DActive(wasActive);
    }

    public static synchronized Gis3DContextImpl getInstance() {
        return INSTANCE;
    }

    public boolean is3DAvailable() {
        return StringUtils.isNotBlank((CharSequence)this.getURL());
    }

    public boolean isAutoSyncPositionTo3D() {
        return this.autoSyncPositionTo3D;
    }

    public void setAutoSyncPositionTo3D(boolean autoSyncPositionTo3D) {
        this.autoSyncPositionTo3D = autoSyncPositionTo3D;
    }

    private Gis3DContextImpl() {
        if (JUMPWorkbench.GIS_CONTEXT == null) {
            this.browser = new DummyBrowserPanel();
            this.externalBrowser = new DummyBrowserFrame();
        }
    }

    public static enum Gis3DMode {
        SPLITVIEW(I18N.get("ui.plugin.Show3DMapPlugIn.mode-split")),
        EXTERNAL(I18N.get("ui.plugin.Show3DMapPlugIn.mode-external"));

        private String name;

        private Gis3DMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

