/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.hovering;

import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.cursortool.hovering.HoverType;
import java.util.Map;
import java.util.Objects;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;

public class HoveredElement
implements Comparable<HoveredElement> {
    private static final Map<HoverType, Integer> HOVER_PRIORITIES = Map.of(HoverType.VERTEX, 1, HoverType.LINE, 500, HoverType.FEATURE, 100);
    private final Layer layer;
    private final SimpleFeature feature;
    private final HoverType type;
    private final Geometry hoveredGeometry;

    public HoveredElement(Layer layer, SimpleFeature feature, HoverType type, Geometry hoveredGeometry) {
        this.layer = layer;
        this.feature = feature;
        this.type = type;
        this.hoveredGeometry = hoveredGeometry;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public SimpleFeature getFeature() {
        return this.feature;
    }

    public HoverType getType() {
        return this.type;
    }

    public Geometry getHoveredGeometry() {
        return this.hoveredGeometry;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.layer);
        hash = 29 * hash + Objects.hashCode(this.feature);
        hash = 29 * hash + Objects.hashCode((Object)this.type);
        hash = 29 * hash + Objects.hashCode(this.hoveredGeometry);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HoveredElement other = (HoveredElement)obj;
        if (!Objects.equals(this.layer, other.layer)) {
            return false;
        }
        if (!Objects.equals(this.feature, other.feature)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return Objects.equals(this.hoveredGeometry, other.hoveredGeometry);
    }

    @Override
    public int compareTo(HoveredElement o) {
        int rightPriority;
        int leftPriority = HOVER_PRIORITIES.get((Object)this.type);
        int result = Integer.compare(leftPriority, rightPriority = HOVER_PRIORITIES.get((Object)o.type).intValue());
        if (result != 0) {
            return result;
        }
        return this.feature.getID().compareTo(o.feature.getID());
    }

    public String toString() {
        return "HoveredElement{layer=" + String.valueOf(this.layer) + ", feature=" + String.valueOf(this.feature) + ", type=" + String.valueOf((Object)this.type) + ", hoveredGeometry=" + String.valueOf(this.hoveredGeometry) + "}";
    }
}

