/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing.label;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.EditAttTransaction;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.label.EditLabelPanel;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.bsh.BshCalculator;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.geotools.feature.type.Types;
import org.opengis.feature.type.AttributeDescriptor;

public class SetLabelPropertiesPlugIn
extends AbstractPlugIn {
    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.label.SetLabelPropertiesPlugIn.name");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"label_set_attributes.svg");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Layer ly;
        Collection<Layer> colSelLy = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems();
        if (colSelLy.size() == 1 && (ly = colSelLy.iterator().next()).getFMD().getUseText()) {
            String strText = ly.getFMD().getTextAtt();
            String strTextOri = ly.getFMD().getTextOriAtt();
            String strTextOriTrans = ly.getFMD().getOriTrans();
            EditAttTransaction trans = this.createTransaction(ly);
            if (strText != null && strText.length() > 0 && ly.getFeatureType().indexOf(strText) > -1) {
                Object objText = Types.parse((AttributeDescriptor)ly.getFeatureType().getDescriptor(strText), (Object)EditLabelPanel.instanceOf().getText());
                trans.addAttribute(strText, objText);
            }
            if (strTextOri != null && strTextOri.length() > 0 && ly.getFeatureType().indexOf(strTextOri) > -1) {
                if (strTextOriTrans == null || strTextOriTrans.trim().length() == 0) {
                    Object objOri = Types.parse((AttributeDescriptor)ly.getFeatureType().getDescriptor(strTextOri), (Object)new Double(EditLabelPanel.instanceOf().getOri()));
                    trans.addAttribute(strTextOri, objOri);
                } else {
                    BshCalculator calc = ly.getFMD().getOriTransCalc();
                    calc.setValue(EditLabelPanel.instanceOf().getOri());
                    Object objOri = Types.parse((AttributeDescriptor)ly.getFeatureType().getDescriptor(strTextOri), (Object)new Double(calc.getDouble()));
                    trans.addAttribute(strTextOri, objOri);
                }
            }
            ArrayList<EditAttTransaction> lstTrans = new ArrayList<EditAttTransaction>();
            lstTrans.add(trans);
            EditAttTransaction.commit(lstTrans);
        }
        return true;
    }

    private EditAttTransaction createTransaction(Layer layer) {
        return EditAttTransaction.createTransactionOnSelection(WorkbenchContext.getInstance().getLayerViewPanel(), WorkbenchContext.getInstance().getLayerViewPanel().getContext(), this.getName(), layer);
    }

    @Override
    public EnableCheck createEnableCheck() {
        return new EnableCheck(this){

            @Override
            public String check(JComponent component) {
                String strCheck = EditingPanel.instanceOf().getInternalFrameActiveCheck().check(component);
                if (strCheck != null) {
                    return strCheck;
                }
                Collection<Layer> colSelLy = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems();
                if (colSelLy.size() != 1) {
                    return "Only one item on one layer should be selected.";
                }
                Layer ly = colSelLy.iterator().next();
                if (ly.getFMD().getUseText()) {
                    return null;
                }
                return "The layer must use labels.";
            }
        };
    }
}

